/*
 * Decompiled with CFR 0.152.
 */
package com.martinprobst.xqpretty;

import com.martinprobst.xqpretty.DecisionAwareParseTreeBuilder;
import com.martinprobst.xqpretty.Formatter;
import com.martinprobst.xqpretty.LazyTokenStream;
import com.martinprobst.xqpretty.XQueryLexer;
import com.martinprobst.xqpretty.XQueryParser;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.JTree;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import org.antlr.runtime.ANTLRStringStream;
import org.antlr.runtime.CharStream;
import org.antlr.runtime.RecognitionException;
import org.antlr.runtime.TokenSource;
import org.antlr.runtime.TokenStream;
import org.antlr.runtime.debug.DebugEventListener;
import org.antlr.runtime.tree.CommonTree;

public class GUI {
    public static void main(String[] args) {
        JFrame mainWindow = new JFrame("XQuery Parser");
        mainWindow.setDefaultCloseOperation(3);
        GUI.setWindowSize(mainWindow);
        final JTextArea queryArea = new JTextArea();
        queryArea.setBorder(BorderFactory.createLoweredBevelBorder());
        JButton button = new JButton("Parse");
        JButton showTree = new JButton("Show Tree");
        final JTextArea errors = new JTextArea();
        errors.setEditable(false);
        errors.setOpaque(false);
        button.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ANTLRStringStream source = new ANTLRStringStream(queryArea.getText());
                XQueryLexer lexer = new XQueryLexer((CharStream)source);
                LazyTokenStream tokenStream = new LazyTokenStream((TokenSource)lexer);
                XQueryParser parser = new XQueryParser((TokenStream)tokenStream, (DebugEventListener)new DecisionAwareParseTreeBuilder("XQuery"));
                parser.setCharSource((CharStream)source);
                try {
                    parser.module();
                }
                catch (RecognitionException e1) {
                    e1.printStackTrace();
                }
                if (parser.errors.isEmpty()) {
                    errors.setText("All OK");
                } else {
                    StringBuilder txt = new StringBuilder();
                    for (String error : parser.errors) {
                        txt.append(error);
                        txt.append('\n');
                    }
                    errors.setText(txt.toString());
                }
            }
        });
        showTree.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ANTLRStringStream source = new ANTLRStringStream(queryArea.getText());
                XQueryLexer lexer = new XQueryLexer((CharStream)source);
                LazyTokenStream tokenStream = new LazyTokenStream((TokenSource)lexer);
                XQueryParser parser = new XQueryParser((TokenStream)tokenStream, (DebugEventListener)new DecisionAwareParseTreeBuilder("XQuery"));
                parser.setCharSource((CharStream)source);
                CommonTree result = null;
                try {
                    result = parser.module().tree;
                }
                catch (RecognitionException e1) {
                    e1.printStackTrace();
                }
                if (parser.errors.isEmpty()) {
                    JFrame treeWindow = new JFrame();
                    treeWindow.setDefaultCloseOperation(2);
                    JTree tree = new JTree();
                    tree.setModel(new ASTTreeModel(result));
                    tree.setCellRenderer(new ASTRenderer());
                    treeWindow.getContentPane().add(tree);
                    GUI.setWindowSize(treeWindow);
                    treeWindow.setVisible(true);
                }
            }
        });
        JButton format = new JButton("Format");
        format.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                try {
                    String html = Formatter.format(queryArea.getText(), Formatter.Mode.HTML);
                    System.out.println(html);
                    errors.setText(html);
                }
                catch (RecognitionException e1) {
                    e1.printStackTrace();
                }
            }
        });
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 1));
        panel.add(queryArea);
        panel.add(button);
        panel.add(showTree);
        panel.add(format);
        panel.add(errors);
        mainWindow.getContentPane().add(panel);
        mainWindow.validate();
        mainWindow.setVisible(true);
    }

    private static void setWindowSize(JFrame window) {
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension size = new Dimension((int)((double)screenSize.width * 0.5), (int)((double)screenSize.height * 0.75));
        window.setSize(size);
        window.setLocation((int)((double)screenSize.width * 0.25), (int)((double)screenSize.height * 0.125));
    }

    static class ASTRenderer
    implements TreeCellRenderer {
        ASTRenderer() {
        }

        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            CommonTree ast = (CommonTree)value;
            return new JLabel(ast.token != null ? ast.token.toString() : "null");
        }
    }

    static class ASTTreeModel
    implements TreeModel {
        private final CommonTree root;

        ASTTreeModel(CommonTree result) {
            this.root = result;
        }

        public Object getChild(Object parent, int index) {
            return ((CommonTree)parent).getChild(index);
        }

        public int getChildCount(Object parent) {
            return ((CommonTree)parent).getChildCount();
        }

        public int getIndexOfChild(Object parent, Object child) {
            return ((CommonTree)child).getChildIndex();
        }

        public Object getRoot() {
            return this.root;
        }

        public boolean isLeaf(Object node) {
            return ((CommonTree)node).getChildCount() == 0;
        }

        public void removeTreeModelListener(TreeModelListener l) {
        }

        public void addTreeModelListener(TreeModelListener l) {
        }

        public void valueForPathChanged(TreePath path, Object newValue) {
        }
    }
}

