/*
 * Decompiled with CFR 0.152.
 */
package com.martinprobst.xqpretty;

import com.martinprobst.xqpretty.DecisionAwareParseTreeBuilder;
import com.martinprobst.xqpretty.IndentationFilter;
import com.martinprobst.xqpretty.LazyTokenStream;
import com.martinprobst.xqpretty.XQToken;
import com.martinprobst.xqpretty.XQueryLexer;
import com.martinprobst.xqpretty.XQueryParser;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Result;
import javax.xml.transform.Templates;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.sax.SAXResult;
import javax.xml.transform.sax.SAXTransformerFactory;
import javax.xml.transform.sax.TransformerHandler;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import net.sf.saxon.TransformerFactoryImpl;
import org.antlr.runtime.ANTLRInputStream;
import org.antlr.runtime.ANTLRStringStream;
import org.antlr.runtime.CharStream;
import org.antlr.runtime.RecognitionException;
import org.antlr.runtime.TokenSource;
import org.antlr.runtime.TokenStream;
import org.antlr.runtime.debug.DebugEventListener;
import org.antlr.runtime.tree.ParseTree;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.ls.DOMImplementationLS;
import org.w3c.dom.ls.LSOutput;
import org.w3c.dom.ls.LSSerializer;

public class Formatter {
    private static Templates templates = Formatter.loadTemplate();

    private static Templates loadTemplate() {
        InputStream resource = Formatter.class.getClassLoader().getResourceAsStream("xqpretty.xsl");
        Templates tmplts = null;
        try {
            tmplts = TransformerFactoryImpl.newInstance().newTemplates(new StreamSource(resource));
        }
        catch (TransformerConfigurationException e) {
            e.printStackTrace();
        }
        catch (TransformerFactoryConfigurationError e) {
            e.printStackTrace();
        }
        return tmplts;
    }

    public static String format(String query, Mode mode) throws RecognitionException {
        ParseTree tree = Formatter.parse(query);
        Document document = Formatter.convertToDocument(tree);
        StringWriter writer = new StringWriter();
        switch (mode) {
            case HTML: {
                Formatter.transformAndIndent(document, writer, true, false);
                break;
            }
            case TEXT: {
                Formatter.transformAndIndent(document, writer, true, true);
                break;
            }
            case PRE_INDENT: {
                Formatter.transformAndIndent(document, writer, false, false);
                break;
            }
            case PARSE_TREE: {
                Formatter.serialize(document, writer);
            }
        }
        return writer.toString();
    }

    private static void serialize(Document document, Writer writer) {
        DOMImplementationLS impl = (DOMImplementationLS)((Object)document.getImplementation());
        LSOutput output = impl.createLSOutput();
        LSSerializer serializer = impl.createLSSerializer();
        output.setCharacterStream(writer);
        serializer.write(document, output);
    }

    private static void transformAndIndent(Document document, Writer writer, boolean filterIndents, boolean asText) {
        try {
            Result result;
            if (filterIndents) {
                IndentationFilter indentationFilter = new IndentationFilter(asText);
                SAXResult saxResult = new SAXResult(indentationFilter);
                SAXTransformerFactory tFactory = (SAXTransformerFactory)SAXTransformerFactory.newInstance();
                TransformerHandler tHandler = tFactory.newTransformerHandler();
                tHandler.getTransformer().setOutputProperty("omit-xml-declaration", "yes");
                saxResult.setHandler(indentationFilter);
                indentationFilter.setContentHandler(tHandler);
                StreamResult actualResult = new StreamResult(writer);
                tHandler.setResult(actualResult);
                result = saxResult;
            } else {
                result = new StreamResult(writer);
            }
            templates.newTransformer().transform(new DOMSource(document), result);
        }
        catch (TransformerConfigurationException e) {
            throw new RuntimeException("Unable to obtain transformer", e);
        }
        catch (TransformerException e) {
            throw new RuntimeException("Exception transforming parse tree", e);
        }
    }

    public static void main(String[] args) {
        try {
            ParseTree tree = args.length > 0 ? Formatter.parse(args[0]) : Formatter.parse((CharStream)new ANTLRInputStream(System.in));
            Document document = Formatter.convertToDocument(tree);
            Mode mode = Mode.HTML;
            switch (mode) {
                case HTML: {
                    Formatter.transformAndIndent(document, new PrintWriter(System.out), true, false);
                    break;
                }
                case TEXT: {
                    Formatter.transformAndIndent(document, new PrintWriter(System.out), true, true);
                    break;
                }
                case PRE_INDENT: {
                    Formatter.transformAndIndent(document, new PrintWriter(System.out), false, false);
                    break;
                }
                case PARSE_TREE: {
                    DOMImplementationLS impl = (DOMImplementationLS)((Object)document.getImplementation());
                    LSOutput output = impl.createLSOutput();
                    LSSerializer serializer = impl.createLSSerializer();
                    output.setByteStream(System.out);
                    serializer.write(document, output);
                }
            }
        }
        catch (RecognitionException e) {
            e.printStackTrace();
        }
        catch (TransformerFactoryConfigurationError e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static Document convertToDocument(ParseTree tree) {
        try {
            DocumentBuilder docBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            Document document = docBuilder.newDocument();
            Formatter.dumpTreeAsXML(document, tree);
            return document;
        }
        catch (ParserConfigurationException e) {
            throw new RuntimeException("Could not obtain document builder", e);
        }
    }

    static ParseTree parse(String test) throws RecognitionException {
        ANTLRStringStream source = new ANTLRStringStream(test);
        return Formatter.parse((CharStream)source);
    }

    static ParseTree parse(CharStream source) throws RecognitionException {
        XQueryLexer lexer = new XQueryLexer(source);
        LazyTokenStream tokenStream = new LazyTokenStream((TokenSource)lexer);
        DecisionAwareParseTreeBuilder builder = new DecisionAwareParseTreeBuilder("XQuery");
        XQueryParser parser = new XQueryParser((TokenStream)tokenStream, (DebugEventListener)builder);
        parser.setCharSource(source);
        parser.module();
        ParseTree tree = builder.getTree();
        return tree;
    }

    private static void dumpTreeAsXML(Node node, ParseTree root) {
        List children = root.getChildren();
        if (children == null) {
            return;
        }
        for (ParseTree parseTree : children) {
            if (parseTree.getChildCount() == 0) {
                XQToken token;
                if (!(parseTree.payload instanceof XQToken) || (token = (XQToken)((Object)parseTree.payload)).getText() == null) continue;
                Formatter.addHiddenTokens(node, token);
                Element element = Formatter.elem(node, "token");
                String tokenName = XQueryParser.tokenNames[token.getType()];
                if (tokenName.startsWith("'") && tokenName.endsWith("'")) {
                    tokenName = tokenName.substring(1, tokenName.length() - 1);
                }
                element.setAttribute("type", tokenName);
                element.setTextContent(token.getText());
                continue;
            }
            Element element = Formatter.elem(node, parseTree.payload.toString());
            Formatter.dumpTreeAsXML(element, parseTree);
        }
    }

    private static void addHiddenTokens(Node node, XQToken token) {
        if (token.getHiddenPredecessor() != null) {
            XQToken last = token.getHiddenPredecessor();
            Formatter.addHiddenTokens(node, last);
            if (last.getChannel() == 99) {
                if (last.getType() == 210) {
                    Element element = Formatter.elem(node, "comment");
                    element.setTextContent(last.getText());
                } else {
                    Element element = Formatter.elem(node, "ws");
                    element.setTextContent(last.getText());
                }
            }
        }
    }

    private static Element elem(Node node, String name) {
        Document doc = (Document)(node.getOwnerDocument() != null ? node.getOwnerDocument() : node);
        Element element = doc.createElement(name);
        node.appendChild(element);
        return element;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Mode {
        PARSE_TREE,
        HTML,
        TEXT,
        PRE_INDENT;

    }
}

