<?xml version="1.0" encoding="UTF-8"?>
<!--
    This stylesheet deals with string-set generated static content.
    It genereates the fo:marker/fo:retrieve-marker pairs.
-->
<xsl:stylesheet 
    xmlns:xsl="http://www.w3.org/1999/XSL/Transform" 
    xmlns:xs="http://www.w3.org/2001/XMLSchema" 
    xmlns:css="http://www.w3.org/1998/CSS" 
    xmlns:fo="http://www.w3.org/1999/XSL/Format" 
    xmlns:oxy="http://www.oxygenxml.com/css2fo" 
    xmlns:nd="http://www.oxygenxml.com/css2fo/named-destinations"
    exclude-result-prefixes="xs oxy nd" 
    version="2.0">
    
    <!-- 
        Deals with the string() / string-set property,
        equivalant of fo:retrieve-marker / fo:marker elements.
    -->

    <!-- This appears in the document flow. -->
    <!-- 
         This inline preserves the whitespaces from start of the text.
         The alternative would be to patch the org.apache.fop.fo.flow.AbstractRetrieveMarker
         to skip the whitespace processing. 
    -->
    <xsl:template match="css:string-set">
        <fo:marker marker-class-name="{@name}"><fo:inline/><xsl:apply-templates/></fo:marker>
    </xsl:template>

    <!-- The content is used from the string-set -->
    <xsl:template match="css:content[@source = 'text']">        
        <xsl:comment>content(<xsl:value-of select="@source"/>)</xsl:comment>
        <fo:inline>
            <xsl:value-of select="oxy:get-text-content(.)"/>
        </fo:inline>
    </xsl:template>

    <xsl:template match="css:content[@source = 'first_letter']">
        <xsl:comment>content(<xsl:value-of select="@source"/>)</xsl:comment>
        <xsl:variable name="text" select="oxy:get-text-content(.)"/>
        <fo:inline>
            <xsl:if test="string-length($text) > 0">
                <xsl:value-of select="substring($text, 1, 1)"/>
            </xsl:if>
        </fo:inline>
    </xsl:template>
    <xsl:template match="css:content[@source = 'before']">
        <xsl:variable name="befores" select="../../css:before"/>
        <xsl:if test="$befores">
            <xsl:comment>content(<xsl:value-of select="@source"/>)</xsl:comment>
            <fo:inline>
                <xsl:apply-templates select="$befores"/>
            </fo:inline>
        </xsl:if>
    </xsl:template>
    <xsl:template match="css:content[@source = 'after']">
        <xsl:variable name="afters" select="../../css:after"/>
        <xsl:if test="$afters">
            <xsl:comment>content(<xsl:value-of select="@source"/>)</xsl:comment>
            <fo:inline>
                <xsl:apply-templates select="$afters"/>
            </fo:inline>
        </xsl:if>
    </xsl:template>

    <!--
        Gets the text that is under an element that contains static content. Takes into account counters, content(text), etc.
        @param static-content-container The element: one of css:before, css:bookmark-label or css:oxy-pdf-meta-author, etc.. 
    -->
    <xsl:function name="oxy:get-all-static-as-text" as="xs:string">
        <xsl:param name="static-content-container" as="node()"/>
        
        <xsl:variable name="fragment">
            <xsl:apply-templates select="$static-content-container/*"/>
        </xsl:variable>
        
        <xsl:variable name="text"
            select="
                if (contains(string-join($fragment//text(), ''), '&#x2060;')) then
                    replace(string-join($fragment//text(), ''), '&#x2060;', '&#x200d;')
                else
                    string-join($fragment//text(), '')"
        />
        
        <xsl:value-of select="normalize-space($text)"/>
    </xsl:function>
    
    <!-- 
        Gets the text content referred by a CSS function content(text) or content(first-letter) 
        @return a string.
    -->
    <xsl:function name="oxy:get-text-content" as="xs:string">
        <xsl:param name="content" as="item()"/>
        <xsl:variable name="text" as="xs:string">
            <!-- 
                The css:content element is located in a css:string-set, inside the 'real' element.
                To collect the real element text, we need to skip the elements from the intermediate format language and the links.
                We also need to skip the elements with @class containing "oxy" except "oxy-insert-hl" which contains the inserted text.
            -->
            <xsl:value-of select="string-join($content/../../(text() |
                descendant::*[namespace-uri() != 'http://www.w3.org/1998/CSS'][not(local-name() = 'a')][not(contains(@class, 'oxy'))]/text() |
                descendant::*[@class = 'oxy-insert-hl']/text()), '')"/>
        </xsl:variable>
        <xsl:value-of select="normalize-space($text)"/>
    </xsl:function>

    <!-- 
        This appears in the page margin boxes, it refers a named string defined in the flow.     
    -->
    <xsl:template match="css:string">
        <fo:retrieve-marker retrieve-class-name="{@name}" retrieve-boundary="document">
            <xsl:choose>
                <xsl:when test="@position = 'first'">
                    <!-- TODO - not sure -->
                    <xsl:attribute name="retrieve-position" select="'first-including-carryover'"/>
                </xsl:when>
                <xsl:when test="@position = 'start'">
                    <xsl:attribute name="retrieve-position" select="'first-starting-within-page'"/>
                </xsl:when>
                <xsl:when test="@position = 'last'">
                    <xsl:attribute name="retrieve-position" select="'last-starting-within-page'"/>
                </xsl:when>
                <xsl:when test="@position = 'first-except'">
                    <xsl:message>WARNING The 'first-except' string is not supported, it cannot be mapped to FO.</xsl:message>
                </xsl:when>
            </xsl:choose>
            <xsl:apply-templates/>
        </fo:retrieve-marker>
    </xsl:template>
    
</xsl:stylesheet>
