<?xml version="1.0" encoding="UTF-8"?>
<!-- 

  The :first-letter typographic pseudo element is used to style the first letter from the first text node.
    
-->
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
  xmlns:xs="http://www.w3.org/2001/XMLSchema"
  xmlns:css="http://www.w3.org/1998/CSS"
  xmlns:fo="http://www.w3.org/1999/XSL/Format"
  xmlns:oxy="http://www.oxygenxml.com/css2fo" 
  exclude-result-prefixes="xs css oxy"
  version="2.0">
  
  <!--
    
    This is not generating content by itself.
    
    -->
  <xsl:template match="css:first-letter"/>
  
  
  
  <!--
    
    Propagate the element that contains the first-letter marker down to the text nodes.
    
    -->
  <xsl:template match="*[css:first-letter and oxy:is-block(.)]" priority="6">
    <xsl:next-match>
      <xsl:with-param name="element-with-first-letter" select="." tunnel="yes"/>
    </xsl:next-match>
  </xsl:template>
  
  
  
  <!-- 
  
    Match the first text node from an element marked as having a first-letter, and create
    an inline around the first non-ws character.
  

    "A first line has meaning only in a block-container box, therefore the ::first-letter 
    pseudo-element has an effect only on elements with a display value of block, inline-block, 
    table-cell, list-item or table-caption. In all other cases, ::first-letter has no effect."
    https://developer.mozilla.org/en/docs/Web/CSS/::first-letter

  -->
  <xsl:template match="text()">
    <xsl:param name="element-with-first-letter" tunnel="yes"/>
    
    <xsl:choose>
      <xsl:when test="$element-with-first-letter">
        <xsl:variable name="context" select="."/>
        <xsl:choose>
          <xsl:when test="($element-with-first-letter//text())[1]/generate-id() = generate-id($context)">
            <!-- 
              Is the first text node from the element with the first letter. 
            -->            
            <xsl:variable name="puctuation" select="'\p{Ps}|\p{Pe}|\p{Pi}|\p{Pf}|\p{Po}|-|_'"/>
            <xsl:analyze-string select="." regex="^(\s*)({$puctuation})?(\p{{L}})({$puctuation})?(.*)$" flags="s">
              <xsl:matching-substring>
                
                <!-- Whitespaces before the first letter -->
                <xsl:value-of select="regex-group(1)"/>
                
                
                <xsl:variable name="fl1" select="regex-group(2)"/>
                <xsl:variable name="fl2" select="regex-group(3)"/>
                <xsl:variable name="fl3" select="regex-group(4)"/>
                
                <xsl:call-template name="generate-inline-margin-left">
                  <xsl:with-param name="size" select="$element-with-first-letter/css:first-letter/@css:margin-left"/>
                </xsl:call-template>
                
                <!-- The first letter, together with the puctuation char before and after it. -->
                <fo:inline>
                  <xsl:apply-templates select="$element-with-first-letter/css:first-letter/(@* except (@css:margin-left, @css:margin-right))"/>
                  
                  <xsl:value-of select="$fl1"/>
                  <xsl:value-of select="$fl2"/>
                  <xsl:value-of select="$fl3"/>
                </fo:inline>
                
                <xsl:call-template name="generate-inline-margin-right">
                  <xsl:with-param name="size" select="$element-with-first-letter/css:first-letter/@css:margin-right"/>
                </xsl:call-template>
                
                <!-- The rest of the text. -->
                <xsl:value-of select="regex-group(5)"/>
                
              </xsl:matching-substring>
              <xsl:non-matching-substring>
                <xsl:value-of select="."/>
              </xsl:non-matching-substring>
            </xsl:analyze-string>
            
          </xsl:when>
          <xsl:otherwise>
            <!-- 
              Is not the first text node from the element with the first letter. 
            -->
            <xsl:next-match/>
          </xsl:otherwise>
        </xsl:choose>
      </xsl:when>
      <xsl:otherwise>
        <!-- The text node is not in the context of any element marked with first-letter -->
        <xsl:next-match/>
      </xsl:otherwise>
    </xsl:choose>
    
  </xsl:template>
  

  <!--
    Tests if an element has a display value of block, inline-block, 
    table-cell, list-item or table-caption.
    
    @param element The element to be checked.
    @return true() if the element is a block.
  -->
  <xsl:function name="oxy:is-block" as="xs:boolean">
    <xsl:param name="element" as="item()"/>
    <xsl:variable name="display" select="$element/@css:display"/>    
    <xsl:value-of select="$display = 'block' or $display = 'inline-block' or $display = 'table-cell' or $display = 'list-item' or $display = 'table-caption'"/>
  </xsl:function>
  
</xsl:stylesheet>