<!--
    
    This stylesheet copies the embedded MathML from the intermediate format to the output.
    
-->
<xsl:stylesheet version="2.0"
  xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
  xmlns:fo="http://www.w3.org/1999/XSL/Format"
  xmlns:mml="http://www.w3.org/1998/Math/MathML"
  xmlns:fox="http://xmlgraphics.apache.org/fop/extensions"
  exclude-result-prefixes="mml fox">  
  
  <xsl:template match="mml:math">     
    <fo:instream-foreign-object>
      <!-- Use as alternate text the @alttext attribute. -->
      <xsl:if test="@alttext">
        <xsl:attribute name="fox:alt-text" select="@alttext"/>
      </xsl:if>
      
      <xsl:copy-of select="."/>
    </fo:instream-foreign-object>
  </xsl:template>
  
</xsl:stylesheet>