<?xml version="1.0" encoding="UTF-8"?>
<!--
  
	This stylesheet translates the CSS directionality properties into FO structures.
	There are templates that deal with BIDI direction, writing-mode and bidi-override in 
	other stylesheets. 
	
-->
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
  xmlns:css="http://www.w3.org/1998/CSS"
  xmlns:xs="http://www.w3.org/2001/XMLSchema" 
  xmlns:fo="http://www.w3.org/1999/XSL/Format"
  xmlns:oxy="http://www.oxygenxml.com/css2fo"  
  xmlns:fox="http://xmlgraphics.apache.org/fop/extensions"
  exclude-result-prefixes="css fox oxy xs"
  version="2.0">
 	
 	<!-- 
 	  General template that transforms the CSS 'direction' property 
 	  into a XSL-FO 'writing-mode' attribute. 	  
 	  -->
   <xsl:template match="@css:direction" priority="2">
     <xsl:attribute name="writing-mode" select="oxy:get-writing-mode(.)"/>
   </xsl:template>

  
  
  <!-- 
    Gets the inherited 'direction' property. The closest to the node wins. 
    @param node The context node.
    @param The closest @direction attribute, if any.
  -->
  <xsl:function name="oxy:get-inherited-direction">
    <xsl:param name="node"/>
    <xsl:value-of select="($node/ancestor-or-self::*[@css:direction]/@css:direction)[1]"/>
  </xsl:function>
  
  
  <!-- 
    Gets the writing mode, by converting a CSS 'direction' property 
    to one of the constants supported by the FO '@writing-mode' attribute. 
  
  -->
  <xsl:function name="oxy:get-writing-mode">
    <xsl:param name="direction" as="xs:string"/>    
    <xsl:choose>
      <xsl:when test="$direction='rtl'">
        <xsl:value-of select="'rl'"/>
      </xsl:when>
      <xsl:when test="$direction='ltr'">
        <xsl:value-of select="'lr'"/>
      </xsl:when>
    </xsl:choose>    
  </xsl:function>
  
  
</xsl:stylesheet>