<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
    xmlns:xs="http://www.w3.org/2001/XMLSchema"
    exclude-result-prefixes="xs util s"
    xmlns:util="http://www.oxygenxml.com/ns/framework/extend/util"
    xmlns:s="http://www.oxygenxml.com/ns/framework/extend"
    version="3.0">
    
    <xd:doc scope="stylesheet" xmlns:xd="http://www.oxygenxml.com/ns/doc/xsl">
        <xd:desc>
            <xd:p>Updates author content completion configuration.</xd:p>
        </xd:desc>
    </xd:doc>
    
    <xd:doc xmlns:xd="http://www.oxygenxml.com/ns/doc/xsl">
        <xd:desc>
            <xd:p>Updates author content completion configuration.</xd:p>
        </xd:desc>
    </xd:doc>
    <xsl:template
        match="authorExtension/field[@name='contextualItems']/contextProvider/field[@name='items']/contextItem-array"
        mode="copy-target">
        <xsl:copy>
            <xsl:apply-templates select="@* | node()" mode="#current"/>
            
            <!-- Copy all new actions without an anchor -->
            <xsl:variable name="ccNewEntries" select="$script/s:author/s:contentCompletion/s:authorActions/s:addAction[not(s:anchor)]"/>
            <xsl:for-each select="$ccNewEntries">
                <xsl:sequence select="util:createCCEntry(.)"></xsl:sequence>
            </xsl:for-each>
        </xsl:copy>
    </xsl:template>
    
    <xsl:template
        match="authorExtension/field[@name='contextualItems']/contextProvider/field[@name='items']/contextItem-array/contextItem"
        mode="copy-target">
        <xsl:param name="skippedAuthorActions" tunnel="yes"/>
        
        <xsl:variable name="actionID" select="field[@name='actionID']/String/text()"/>
        
        <xsl:variable 
            name="before" 
            select="$script/s:author/s:contentCompletion/s:authorActions/s:addAction[s:anchor/@actionID=$actionID][s:anchor/@position='before']"/>
        <xsl:for-each select="$before">
            <xsl:sequence select="util:createCCEntry(.)"></xsl:sequence>
        </xsl:for-each>
        
        <xsl:variable name="skipit" select="
            $script/s:author/s:contentCompletion/s:authorActions/s:removeAction[@id=$actionID]
            or not(empty(index-of($skippedAuthorActions, $actionID)))"/>
        
        <xsl:if test="not($skipit)">
            <xsl:copy>
                <xsl:apply-templates select="@* | node()" mode="#current"/>
            </xsl:copy>
        </xsl:if>
        
        <xsl:variable 
            name="after" 
            select="$script/s:author/s:contentCompletion/s:authorActions/s:addAction[s:anchor/@actionID=$actionID][s:anchor/@position='after']"/>
        <xsl:for-each select="$after">
            <xsl:sequence select="util:createCCEntry(.)"></xsl:sequence>
        </xsl:for-each>
    </xsl:template>
    
    
    <xd:doc xmlns:xd="http://www.oxygenxml.com/ns/doc/xsl">
        <xd:desc>
            <xd:p>Updates author content completion configuration.</xd:p>
        </xd:desc>
    </xd:doc>
    <xsl:template
        match="authorExtension/field[@name='contextualItems']/contextProvider/field[@name='removeItems']/contextRemoveItem-array"
        mode="copy-target">
        <xsl:copy>
            <xsl:apply-templates select="@* | node()" mode="#current"/>
            
            <xsl:call-template name="generateSchemaProposalsRemovals"/>
        </xsl:copy>
    </xsl:template>
    
    <xd:doc xmlns:xd="http://www.oxygenxml.com/ns/doc/xsl">
        <xd:desc>
            <xd:p>A content completion configuration without any filtered schema proposal.</xd:p>
        </xd:desc>
    </xd:doc>
    <xsl:template
        match="authorExtension/field[@name='contextualItems']/contextProvider/field[@name='removeItems']/null"
        mode="copy-target">
        <contextRemoveItem-array>
            <xsl:call-template name="generateSchemaProposalsRemovals"/>
        </contextRemoveItem-array>
    </xsl:template>
    
    <xd:doc xmlns:xd="http://www.oxygenxml.com/ns/doc/xsl">
        <xd:desc>Generates all the entries for filtering schema proposals.</xd:desc>
    </xd:doc>
    <xsl:template name="generateSchemaProposalsRemovals">
        <!-- Add the required entries to remove proposals obtained from the schema. -->
        <xsl:variable name="removeCCEntries" select="$script/s:author/s:contentCompletion/s:schemaProposals/s:removeProposal"/>
        <xsl:for-each select="$removeCCEntries">
            <xsl:sequence select="util:createRemoveCCEntry(.)"></xsl:sequence>
        </xsl:for-each>
    </xsl:template>
    
    <xd:doc xmlns:xd="http://www.oxygenxml.com/ns/doc/xsl">
        <xd:desc>
            <xd:p>Is a schema proposal was removed in the base framework we have a chance to reject that removal
                and put it back.</xd:p>
            <xd:p>If the base removes the proposal from more views and the script wants to remove it from jsut a few, it 
            can cancel the base removal and add its own removal, more restrictive, item.</xd:p>
        </xd:desc>
    </xd:doc>
    <xsl:template
        match="authorExtension/field[@name='contextualItems']/contextProvider/field[@name='removeItems']/contextRemoveItem-array/contextRemoveItem"
        mode="copy-target">
        <xsl:variable name="name" select="field[@name='renderName']/String/text()"/>
        <xsl:variable 
            name="skipped"
            select="$script/s:author/s:contentCompletion/s:schemaProposals/s:addProposal[@renderName=$name]"/>
        <xsl:if test="not($skipped)">
            <xsl:copy>
                <xsl:apply-templates select="@* | node()" mode="#current"/>
            </xsl:copy>
        </xsl:if>
    </xsl:template>
    
</xsl:stylesheet>