<?xml version="1.0" encoding="UTF-8"?>
<!-- 
  Copyright 2001-2011 Syncro Soft SRL. All rights reserved.
 -->
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
    xpath-default-namespace="http://www.oxygenxml.com/ns/doc/xsl"
    exclude-result-prefixes="#all"
    xmlns:xd="http://www.oxygenxml.com/ns/doc/xsl"
    version="2.0">

    <xsl:output indent="yes" method="html"/>

    <xd:doc scope="stylesheet">
        <xd:desc>Generates XHTML output from the oXygen XSL documentation format.</xd:desc>
    </xd:doc>

    <xd:doc>
        <xd:desc>Generate documentation for a component.</xd:desc>
    </xd:doc>
    <xsl:template match="doc">
        <div>
            <xsl:apply-templates select="desc"/>
            <xsl:variable name="params" select="param"/>
            <xsl:if test="not(empty($params))">
                <p>
                    <!-- First param -->
                    <b>Parameters:</b>
                    <ul>
                        <xsl:for-each select="$params">
                            <xsl:call-template name="param"/>
                        </xsl:for-each>
                    </ul>
                </p>
            </xsl:if>
            <xsl:apply-templates select="return"/>
        </div>
    </xsl:template>

    <xd:doc>
        <xd:desc>Generate content for the description of a component.</xd:desc>
    </xd:doc>
    <xsl:template match="desc">
        <b>
            <xsl:apply-templates/>
        </b>
    </xsl:template>

    <xd:doc>
        <xd:desc>Make sure the spaces are normalized.</xd:desc>
    </xd:doc>
    <xsl:template match="text()">
        <xsl:value-of select="normalize-space(.)"/>
    </xsl:template>
    
    <xd:doc>
        <xd:desc>Generate content for a parameter of a function.</xd:desc>
    </xd:doc>
    <xsl:template name="param" match="param">
        <li>
            <b>
                <xsl:value-of select="@name"/>
            </b>
            <xsl:text> </xsl:text>
            <xsl:apply-templates/>
        </li>
    </xsl:template>

    <xd:doc>
        <xd:desc>Generate content for the return statement of a function.</xd:desc>
    </xd:doc>
    <xsl:template match="return">
        <b>Return</b>
        <xsl:text> </xsl:text>
        <xsl:apply-templates/>
    </xsl:template>

    <xd:doc>
        <xd:desc>Generate content for paragraphs, for whitespace preserve elements, for bold, italic and for unordered lists.</xd:desc>
    </xd:doc>
    <xsl:template match="p|pre|b|i">
        <xsl:element name="{local-name()}" namespace="http://www.w3.org/1999/xhtml">
            <xsl:apply-templates/>
        </xsl:element>
    </xsl:template>

    <xd:doc>
        <xd:desc>Generate content for a list item.</xd:desc>
    </xd:doc>
    <xsl:template match="li|ul">
        <p>
            <xsl:apply-templates/>
        </p>
    </xsl:template>

    <xd:doc>
        <xd:desc>
            <xd:p>Construct a link to another component. Attribute <xd:i>@xdi:location</xd:i> gives
                us the location of the component and attribute <xd:i>@xdi:componentid</xd:i> gives
                us the component's unique id.</xd:p>
        </xd:desc>
    </xd:doc>
    <xsl:template match="ref">
        <!--<a
            href="{concat(substring-before(@xdi:location, $intermediateXmlExtension), $extension, '#', @xdi:componentid)}"
            target="{$target}">
            <xsl:if test="not(*|text())">
                <xsl:value-of select="@name"/>
            </xsl:if>
            <xsl:apply-templates/>
        </a>-->
    </xsl:template>

    <xd:doc>
        <xd:desc>Construct a link with respect to the following rules: <xd:ul>
                <xd:li>
                    <xd:p>If <xd:i>@docid</xd:i> attribute exists than we consider it to be a link
                        to another documentation block. The location of the documentation block in
                        the output files structure is taken from <xd:i>@xdi:location</xd:i>
                        attribute. </xd:p>
                </xd:li>
                <xd:li>
                    <xd:p>If <xd:i>@docid</xd:i> doesn't exist we consider the link to be
                        external.</xd:p>
                </xd:li>
            </xd:ul>
        </xd:desc>
    </xd:doc>
    <xsl:template match="a">
        <xsl:element name="a">
            <xsl:attribute name="href" select="@href"/>
            <xsl:attribute name="target" select="'_blank'"/>
            <xsl:if test="not(*|text())">
                <xsl:value-of select="@href"/>
            </xsl:if>
            <xsl:apply-templates/>
        </xsl:element>
    </xsl:template>
</xsl:stylesheet>
