package ro.sync.util.editorvars.parser.model;

/**
 * Plain text. No special meaning.
 */
public class PlainText extends LexicalItem {

  /**
   * The text content.
   */
  private final String text;
 
  /**
   * Constructor.
   * 
   * @param text The text content.
   */
  public PlainText(String text) {
    super(LexicalItem.Type.PLAIN_TEXT);
    this.text = text;
  }

  /**
   * @return The text
   */
  public String getText() {
    return text;
  }

  @Override
  public String toString() {
    return "'" + text + "', type: " + getType();
  }
  
  @Override
  public String getStringValue() {
    return getText();
  }

}
