/*
 * Copyright (c) 2018 Syncro Soft SRL - All Rights Reserved.
 *
 * This file contains proprietary and confidential source code.
 * Unauthorized copying of this file, via any medium, is strictly prohibited.
 */
package org.w3c.flute.parser.selectors.spc;

import java.util.Map;

/**
 * Represents an element that has a parent element and whose parent 
 * element has no other element children with the same expanded element 
 * name. Same as :first-of-type:last-of-type or 
 * :nth-of-type(1):nth-last-of-type(1), but with a lower specificity. 
 * 
 * @author dan
 *
 * @see "http://www.w3.org/TR/css3-selectors/#only-of-type-pseudo"
 */
public class OnlyOfTypeSPCCondition extends SPCCondition {

  /**
   * @see org.w3c.flute.parser.selectors.spc.SPCCondition#getType()
   */
  @Override
  public Type getType() {
    return Type.ONLY_OF_TYPE;
  }

  /**
   * @see org.w3c.flute.css.sac.Condition#getSerialization(Map)
   */
  @Override
  public String getSerialization(Map<String, String> proxyNamespaceMapping) {
    return ":only-of-type";
  }
}
