/*
 * Copyright (c) 2018 Syncro Soft SRL - All Rights Reserved.
 *
 * This file contains proprietary and confidential source code.
 * Unauthorized copying of this file, via any medium, is strictly prohibited.
 */
package org.w3c.flute.parser.selectors.spc;

import java.util.Map;

/**
 * Same as :nth-of-type(1). The :first-of-type pseudo-class represents 
 * an element that is the first sibling of its type in the list of children 
 * of its parent element.
 *
 * @see "http://www.w3.org/TR/css3-selectors/#first-of-type-pseudo"
 * @author dan
 */
public class FirstOfTypeSPCCondition extends NthOfTypeSPCCondition {

  /**
   * Constructor.
   */
  public FirstOfTypeSPCCondition() {
    super(0, 1);
  }

  /**
   * @see org.w3c.flute.parser.selectors.spc.NthOfTypeSPCCondition#getType()
   */
  @Override
  public Type getType() {
    return Type.FIRST_OF_TYPE;
  }
  

  /**
   * @see org.w3c.flute.parser.selectors.spc.NthChildSPCCondition#getSerialization(Map)
   */
  @Override
  public String getSerialization(Map<String, String> proxyNamespaceMapping) {
    return ":first-of-type";
  }
}
