/*
 * Copyright (c) 2018 Syncro Soft SRL - All Rights Reserved.
 *
 * This file contains proprietary and confidential source code.
 * Unauthorized copying of this file, via any medium, is strictly prohibited.
 */
package org.w3c.flute.parser.selectors.spc;

import java.util.Map;

/**
 * Same as :nth-child(1). The :first-child pseudo-class represents 
 * an element that is the first child of some other element. 
 * 
 * @see "http://www.w3.org/TR/css3-selectors/#first-child-pseudo"
 * @author dan
 */
public class FirstChildSPCCondition extends NthChildSPCCondition {

  /**
   * Constructor.
   */
  public FirstChildSPCCondition() {
    super(0, 1);
  }

  @Override
  public Type getType() {
    return Type.FIRST_CHILD;
  }

  /**
   * @see org.w3c.flute.parser.selectors.spc.NthChildSPCCondition#getSerialization(Map)
   */
  @Override
  public String getSerialization(Map<String, String> proxyNamespaceMapping) {
    return ":first-child";
  }

}
