/*
 * Copyright (c) 2000 World Wide Web Consortium,
 * (Massachusetts Institute of Technology, Institut National de
 * Recherche en Informatique et en Automatique, Keio University). All
 * Rights Reserved. This program is distributed under the W3C's Software
 * Intellectual Property License. This program is distributed in the
 * hope that it will be useful, but WITHOUT ANY WARRANTY; without even
 * the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
 * PURPOSE.
 * See W3C License http://www.w3.org/Consortium/Legal/ for more details.
 *
 * $Id$
 */
package org.w3c.flute.parser.selectors;

import java.util.Map;

import org.w3c.css.sac.Locator;
import org.w3c.flute.css.sac.ElementSelector;
import org.w3c.flute.css.sac.Selector;

/**
 * @version $Revision$
 * @author  Philippe Le Hegaret
 */
public class PseudoElementSelectorImpl extends AbstractLocalizableSelector implements ElementSelector {

  /**
   * The pseudo element name.
   */
  private String localName;
  

  /**
   * Creates a new ElementSelectorImpl
   * 
   * @param name The pseudo element name. 
   * @param locator The CSS parser locator. It is used for back-mapping. Can be <code>null</code>.
   */
  public PseudoElementSelectorImpl(String name, Locator locator) {
    super(locator);
    this.localName = name;
  }

  /**
   * An integer indicating the type of <code>Selector</code>
   */
  @Override
  public short getSelectorType() {
    return Selector.SAC_PSEUDO_ELEMENT_SELECTOR;
  }

  /**
   * Returns the
   * <a href="http://www.w3.org/TR/REC-xml-names/#dt-NSName">namespace
   * URI</a> of this element selector.
   * <p><code>NULL</code> if this element selector can match any namespace.</p>
   */
  @Override
  public String getNamespaceURI() {
    return null;
  }

  /**
   * Returns the
   * <a href="http://www.w3.org/TR/REC-xml-names/#NT-LocalPart">local part</a>
   * of the
   * <a href="http://www.w3.org/TR/REC-xml-names/#ns-qualnames">qualified
   * name</a> of this element.
   * <p><code>NULL</code> if this element selector can match any element.</p>
   */
  @Override
  public String getLocalName() {
    return localName;
  }

  /**
   * @see org.w3c.flute.css.sac.SubjectSelector#setIsSubject(boolean)
   */
  @Override
  public void setIsSubject(boolean isSubject) {
  }

  /**
   * @see org.w3c.flute.css.sac.SubjectSelector#isSubject()
   */
  @Override
  public boolean isSubject() {
    return false;
  }

  /**
   * @see org.w3c.flute.css.sac.SubjectSelector#hasSubject()
   */
  @Override
  public boolean hasSubject() {
    return false;
  }

  /**
   * @see org.w3c.flute.css.sac.SubjectSelector#getSubjectAncestorSelector()
   */
  @Override
  public Selector getSubjectAncestorSelector() {
    return null;
  }
  
  /**
   * @see org.w3c.flute.css.sac.Selector#getSerialization(Map)
   */
  @Override
  public String getSerialization(Map<String, String> proxyNamespaceMapping) {   
    return ":" + localName;
  }
 
}
