/*
 * Copyright (c) 2018 Syncro Soft SRL - All Rights Reserved.
 *
 * This file contains proprietary and confidential source code.
 * Unauthorized copying of this file, via any medium, is strictly prohibited.
 */
package org.w3c.flute.parser;

/**
 * A media feature of the form feature: expression (e.g. min-width: 100px)
 */
public class MediaFeatureExpression implements Cloneable{
  
  /**
   * The feature name
   */
  private final String feature;
  /**
   * The expression value
   */
  private String expression;
  
  /**
   * Constructor.
   * 
   * @param feature The feature name.
   */
  public MediaFeatureExpression(String feature) {
    this(feature, "");
  }
  
  /**
   * Constructor.
   * @param feature The feature name.
   * @param expression The feature expression.
   */
  public MediaFeatureExpression(String feature, String expression) {
    this.feature = feature;
    this.expression = expression;
  }

  /**
   * Get the feature.
   * @return The feature name
   */
  public String getFeature() {
    return feature;
  }

  /**
   * Get the expression.
   * 
   * @return The expression value.
   */
  public String getExpression() {
    return expression;
  }
  
  /**
   * Get the unquoted expression.
   * 
   * @return The expression value.
   */
  public String getUnquotedExpression(){
    String toReturn = expression;
    if(toReturn != null && toReturn.startsWith("\"") && toReturn.endsWith("\"") && toReturn.length() > 2){
      toReturn = toReturn.substring(1, toReturn.length() - 1);
    }
    return toReturn;
  }
  
  @Override
  public String toString() {
    return "(" + feature + 
        (!"".equals(expression) ? ": " + expression : "") +
        ")"; 
  }

  /**
   * @see java.lang.Object#hashCode()
   */
  @Override
  public int hashCode() {
    final int prime = 31;
    int result = 1;
    result = prime * result
        + ((expression == null) ? 0 : expression.hashCode());
    result = prime * result + ((feature == null) ? 0 : feature.hashCode());
    return result;
  }

  /**
   * @see java.lang.Object#equals(java.lang.Object)
   */
  @Override
  public boolean equals(Object obj) {
    if (this == obj)
      return true;
    if (obj == null)
      return false;
    if (getClass() != obj.getClass())
      return false;
    MediaFeatureExpression other = (MediaFeatureExpression) obj;
    if (expression == null) {
      if (other.expression != null)
        return false;
    } else if (!expression.equals(other.expression))
      return false;
    if (feature == null) {
      if (other.feature != null)
        return false;
    } else if (!feature.equals(other.feature))
      return false;
    return true;
  }
  
  /**
   * @see java.lang.Object#clone()
   */
  public MediaFeatureExpression clone() {
    return new MediaFeatureExpression(feature, expression);
  }
}

