package org.w3c.flute.css.sac;

/**
 * A CSS Level 3 page selector, as defined by the grammar:
 * 
 * https://www.w3.org/TR/css3-page/#page_selector 
 *
 * Consists of an optional page name, followed by multiple pseudo pages (:first, :blank, etc..).
 * @author dan
 */
public interface PageSelector {

  /**
   * Matches first page from a sequence.
   */
  String FIRST = "first";

  /**
   * Matches the last page from a sequence.
   */
  String LAST = "last";
  
  /**
   * Matches pages located in the left side of the published output.
   */
  String LEFT = "left";
  
  /**
   * Matches pages located in the right side of the published output.
   */
  String RIGHT = "right";
  
  /**
   * Matches blank pages.
   */
  String BLANK = "blank";
  
  /**
   * Adds a pseudo page.
   * 
   * https://www.w3.org/TR/css3-page/#syntax-prod-pseudo-page
   * 
   * @param pseudo The pseudo page. Can be one of: first, left, right, blank.
   */
  void addPseudo(String pseudo);

  /**
   * Sets the name of the page.
   * 
   * @param name The name of the page. It can be <code>null</code> if the 
   * page styling applies to all pages.
   */
  void setName(String name);
  
  /**
   * Gets all defined pseudo pages.
   * 
   * @return An iterable of strings. It can be <code>null</code>.
   */
  Iterable<String> getPseudos();

  /**
   * Checks if a pseudo page is matched by this selector.
   * 
   * @param pseudo The pseudo to be matched.
   * @return <code>true</code> if the pseudo page is in the selector pseuod list.
   */
  boolean containsPseudo(String pseudo);
  
  /**
   * Gets the name of the page.
   * 
   * @return the name of the page. It can be <code>null</code> if the 
   * page styling applies to all pages.
   */
  String getName();
  
}
