xquery version "3.0" encoding "utf-8";

(: 
    XQuery document used to implement 'Replace element with XML fragment' operation.    
:)

import module namespace xr = "http://www.oxygenxml.com/ns/xmlRefactoring" at "http://www.oxygenxml.com/ns/xmlRefactoring/resources/commons.xq";

declare namespace output = "http://www.w3.org/2010/xslt-xquery-serialization";

declare option output:method   "xml";
declare option output:indent   "no";

declare variable $element_xpath as xs:string external;

(: The XML fragment to be inserted :)
declare variable $xml_fragment as xs:string external;

declare function local:eval($expression as xs:string, $context-item as item()?) as item()* {
  transform(
    map {
      'stylesheet-node' : <xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="3.0" 
        xmlns:mf="http://example.com/mf"
        xmlns:xs="http://www.w3.org/2001/XMLSchema"
        exclude-result-prefixes="#all">
        <xsl:function name="mf:eval" as="item()*" visibility="public">
          <xsl:param name="expression" as="xs:string"/>
          <xsl:param name="context-item" as="item()?"/>
          <xsl:evaluate xpath="$expression" context-item="$context-item"/>
        </xsl:function>
      </xsl:stylesheet>,
      'initial-function' : QName('http://example.com/mf', 'eval'),
      'function-params': [$expression, $context-item],
      'delivery-format': 'raw'
    }
  )?output
};

(: Parse the XML fragment :)
let $xmlFragmentSequence as node()* := xr:parse-xml-fragment($xml_fragment)
let $elements := local:eval($element_xpath, (./*)[1])
for $elem in $elements
where $elem instance of element()
return 
  (
    (: Insert the nodes from the XML fragment before the target element :)
    insert nodes $xmlFragmentSequence before $elem,
         
    (: Delete the target element :)     
    delete node $elem
  )   