<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet exclude-result-prefixes="#all" version="3.0"
	xmlns:x="http://www.jenitennison.com/xslt/xspec" xmlns:xs="http://www.w3.org/2001/XMLSchema"
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform">

	<!--
		This stylesheet module is a collection of utilities to parse XSpec report XML.
		This module is used across component borders. Elements in this stylesheet must
		not affect the other stylesheets.
	-->

	<!--
		Returns a sequence of descendant x:test
	-->
	<xsl:function as="element(x:test)*" name="x:descendant-tests">
		<xsl:param as="node()" name="context-node" />

		<xsl:sequence select="$context-node/descendant::x:test[parent::x:scenario]" />
	</xsl:function>

	<!--
		Returns a sequence of descendant failed x:test
	-->
	<xsl:function as="element(x:test)*" name="x:descendant-failed-tests">
		<xsl:param as="node()" name="context-node" />

		<xsl:sequence select="x:descendant-tests($context-node)[x:is-failed-test(.)]" />
	</xsl:function>

	<!--
		Returns true if x:test represents success
	-->
	<xsl:function as="xs:boolean" name="x:is-passed-test">
		<xsl:param as="element(x:test)" name="test-element" />

		<xsl:sequence select="$test-element/(exists(@successful) and xs:boolean(@successful))" />
	</xsl:function>

	<!--
		Returns true if x:test represents failure
	-->
	<xsl:function as="xs:boolean" name="x:is-failed-test">
		<xsl:param as="element(x:test)" name="test-element" />

		<xsl:sequence select="$test-element/(exists(@successful) and not(xs:boolean(@successful)))"
		 />
	</xsl:function>

	<!--
		Returns true if x:test is pending
	-->
	<xsl:function as="xs:boolean" name="x:is-pending-test">
		<xsl:param as="element(x:test)" name="test-element" />

		<xsl:sequence select="$test-element/exists(@pending)" />
	</xsl:function>

	<!--
		Returns x:expect/@test connected with the given x:test.
		@test might or might not be an xs:boolean at run time.
	-->
	<xsl:function as="attribute(test)?" name="x:test-attr">
		<xsl:param as="element(x:test)" name="test-element" />

		<xsl:sequence select="$test-element/expect-test-wrap/x:expect/@test" />
	</xsl:function>

	<!--
		Returns true if x:expect/@test was an xs:boolean at run time.
	-->
	<xsl:function as="xs:boolean" name="x:is-boolean-test">
		<xsl:param as="element(x:test)" name="test-element" />

		<xsl:sequence select="$test-element ! (empty(x:result) and x:test-attr(.))" />
	</xsl:function>

	<!--
		Returns the content of the report element (x:expect or x:result) generated by
		"rep:report-sequence".
		The content is wrapped in a element. The wrapper element represents the document node (/) in
		@select. To extract the reported item(s) from the content, you need to apply @select to the
		content returned from this function.
		The wrapper element has no namespaces so that it doesn't pollute the content nodes.
		Returns an empty sequence, if the report element has no content. In that case, @select alone
		determines the reported item(s).
	-->
	<xsl:function as="element(content-wrap)?" name="x:reported-content">
		<xsl:param as="element()" name="report-element" />

		<xsl:if test="$report-element[self::x:expect or self::x:result] => empty()">
			<xsl:message terminate="yes">
				<xsl:text expand-text="yes">ERROR: {name($report-element)} is not a report element</xsl:text>
			</xsl:message>
		</xsl:if>

		<xsl:sequence select="$report-element/content-wrap" />
	</xsl:function>

</xsl:stylesheet>
