<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
    xmlns:xs="http://www.w3.org/2001/XMLSchema"
    xmlns:map="http://www.w3.org/2005/xpath-functions/map"
    xmlns:f="http://www.oxygenxml.com/xsl/functions" exclude-result-prefixes="xs f map"
    version="2.0">
    
    <xsl:template match="node() | @*" mode="convertV2">
        <xsl:copy>
            <xsl:apply-templates select="node() | @*" mode="convertV2"/>
        </xsl:copy>
    </xsl:template>
    
    <!-- Change version. -->
    <xsl:template match="swagger" mode="convertV2">
        <openapi>3.0.2</openapi>	
    </xsl:template>
    
    <!-- Genereate servers object after info --> 
    <xsl:template match="info" mode="convertV2">
        <info>
            <xsl:apply-templates select="node() | @*" mode="convertV2"/>
        </info>
        
        <!-- Add server information -->
        <xsl:variable name="host" select="/*/host"/>
        <xsl:variable name="basePath" select="/*/basePath"/>
        <xsl:variable name="schemes" select="/*/schemes"/>
        
        <!-- Generate DITA for host and base path. -->
        <xsl:if test="$host or $basePath">
            <xsl:variable name="baseURL" select="concat($host, $basePath)"/>
            <servers>
                <xsl:choose>
                    <xsl:when test="f:arrayHasElements($schemes)">
                        <xsl:for-each select="$schemes">
                            <url>
                                <xsl:choose>
                                    <xsl:when test="./array">
                                        <xsl:value-of select="concat(./*, '://', $baseURL)"/>
                                    </xsl:when>
                                    <xsl:otherwise>
                                        <xsl:value-of select="concat(., '://', $baseURL)"/>
                                    </xsl:otherwise>
                                </xsl:choose>
                            </url>
                        </xsl:for-each>
                    </xsl:when>
                    <xsl:otherwise>
                        <url>
                            <xsl:value-of select="$baseURL"/>
                        </url>
                    </xsl:otherwise>
                </xsl:choose>
            </servers>
        </xsl:if>
    </xsl:template>
    
    <xsl:template match="basePath" mode="convertV2"></xsl:template>
    <xsl:template match="host" mode="convertV2"></xsl:template>
    <xsl:template match="schemes" mode="convertV2"></xsl:template>
    
    <xsl:template match="produces" mode="convertV2"></xsl:template>
    <xsl:template match="consumes" mode="convertV2"></xsl:template>
    
    <!-- Convert body parameter in RequestBody and add content--> 
    <xsl:template match="parameters[in = 'body']" mode="convertV2">
        <requestBody>
            <xsl:variable name="schemaElement" select="schema"/>
            
            <xsl:variable name="consumers">
                <xsl:choose>
                    <xsl:when test="./../consumes/*">
                        <xsl:value-of select="./../consumes/*"/>
                    </xsl:when>
                    <xsl:otherwise>
                        <xsl:value-of select="/*/consumes/*"/>
                    </xsl:otherwise>
                </xsl:choose>
            </xsl:variable>
            <content>
                <xsl:choose>
                    <xsl:when test="$consumers and string-length($consumers) > 0">
                        <xsl:for-each select="$consumers">
                            <xsl:choose>
                                <xsl:when test="./array">
                                    <xsl:element name="{f:escapeInvalidCharsFromMimeTypes(./*)}">
                                        <schema>
                                            <xsl:apply-templates select="$schemaElement/*" mode="convertV2"/>
                                        </schema>
                                    </xsl:element>
                                </xsl:when>
                                <xsl:otherwise>
                                    <xsl:element name="{f:escapeInvalidCharsFromMimeTypes(.)}">
                                        <schema>
                                            <xsl:apply-templates select="$schemaElement/*" mode="convertV2"/>
                                        </schema>
                                    </xsl:element>
                                </xsl:otherwise>
                            </xsl:choose>
                        </xsl:for-each>
                    </xsl:when>
                    <xsl:otherwise>
                        <xsl:element name="application_X2f_json">
                            <schema>
                                <xsl:apply-templates select="$schemaElement/*" mode="convertV2"/>
                            </schema>
                        </xsl:element>
                    </xsl:otherwise>
                </xsl:choose>
            </content>
            <xsl:apply-templates select="node()[not(local-name() = ('schema', 'in'))]" mode="convertV2"/>
        </requestBody>
    </xsl:template>
    
    <!-- Wrap some fields from parameters or headers in schema element -->
    <xsl:template match="parameters | headers/*" mode="convertV2">
        <xsl:element name="{local-name()}">
            <xsl:call-template name="extractSchemaVariables"/>
        </xsl:element>
    </xsl:template>
    
    <xsl:variable name="schemaVariables" 
        select="('type', 'format', 'items', 'collectionFormat', 'default', 'maximum', 'exclusiveMaximum', 'minimum', 'exclusiveMinimum',
        'maxLength', 'minLength', 'pattern', 'maxItems', 'minItems', 'uniqueItems', 'enum', 'multipleOf')"></xsl:variable>
    
    <xsl:template name="extractSchemaVariables">
        <xsl:apply-templates select="node()[not(local-name() = $schemaVariables)]" mode="convertV2"/>
        <xsl:if test="node()[local-name() = $schemaVariables]">
            <schema>
                <xsl:apply-templates select="node()[local-name() = $schemaVariables]" mode="convertV2"/>
            </schema>
        </xsl:if>
    </xsl:template>
    
    <!-- Added content in response objects -->
    <xsl:template match="responses/*/schema" mode="convertV2">
        <xsl:variable name="schemaElement" select="."/>
        <xsl:variable name="produces">
            <xsl:choose>
                <xsl:when test="./../../../produces/*">
                    <xsl:value-of select="../../../produces/*"/>
                </xsl:when>
                <xsl:otherwise>
                    <xsl:value-of select="/*/produces/*"/>
                </xsl:otherwise>
            </xsl:choose>
        </xsl:variable>
        <content>
            <xsl:choose>
                <xsl:when test="$produces and string-length($produces) > 0">
                    <xsl:for-each select="$produces">
                        <xsl:choose>
                            <xsl:when test="./array">
                                <xsl:element name="{f:escapeInvalidCharsFromMimeTypes(./*)}">
                                    <schema>
                                        <xsl:apply-templates select="$schemaElement/*" mode="convertV2"/>
                                    </schema>
                                </xsl:element>
                            </xsl:when>
                            <xsl:otherwise>
                                <xsl:element name="{f:escapeInvalidCharsFromMimeTypes(.)}">
                                    <schema>
                                        <xsl:apply-templates select="$schemaElement/*" mode="convertV2"/>
                                    </schema>
                                </xsl:element>
                            </xsl:otherwise>
                        </xsl:choose>
                    </xsl:for-each>
                </xsl:when>
                <xsl:otherwise>
                    <xsl:element name="application_X2f_json">
                        <schema>
                            <xsl:apply-templates select="$schemaElement/*" mode="convertV2"/>
                        </schema>
                    </xsl:element>
                </xsl:otherwise>
            </xsl:choose>
        </content>
    </xsl:template>
    
    <xsl:function name="f:escapeInvalidCharsFromMimeTypes" as="xs:string">
        <xsl:param name="toEscape" as="xs:string"/>
        <xsl:variable name="aux0" select="replace(xs:string($toEscape), '/', '_X2f_')"/>
        <xsl:variable name="aux1" select="replace($aux0, '\+', '_X2b_')"/>
        <xsl:variable name="aux2" select="replace($aux1, ' ', '_X20_')"/>
        <xsl:variable name="aux3" select="replace($aux2, ';', '_X3b_')"/>
        <xsl:variable name="aux4" select="replace($aux3, '=', '_X3d_')"/>
        <xsl:variable name="aux5" select="replace($aux4, '\*', '_X2a_')"/>
        <xsl:value-of select="$aux5"/>
    </xsl:function>
    
    <!-- Generate components object after path -->
    <xsl:template match="paths" mode="convertV2">
        <paths>
            <xsl:apply-templates select="node() | @*" mode="convertV2"/>
        </paths>
        
        <components>
            <xsl:if test="../definitions">
                <schemas>
                    <xsl:apply-templates select="./../definitions/*" mode="convertV2"/>
                </schemas>
            </xsl:if>
            <xsl:if test="../parameters">
                <parameters>
                    <xsl:for-each select="../parameters/*">
                        <xsl:element name="{local-name(.)}">
                            <xsl:call-template name="extractSchemaVariables"/>
                        </xsl:element>
                    </xsl:for-each>
                </parameters>
            </xsl:if>
            <xsl:if test="../responses">
                <responses>
                    <xsl:apply-templates select="./../responses/*" mode="convertV2"/>
                </responses>
            </xsl:if>
            <xsl:if test="../securityDefinitions">
                <securitySchemes>
                    <xsl:apply-templates select="./../securityDefinitions/*" mode="convertV2"/>
                </securitySchemes>
            </xsl:if>
        </components>
    </xsl:template>
    
    <xsl:template match="/*/definitions" mode="convertV2"></xsl:template>
    <xsl:template match="/*/parameters" mode="convertV2" priority="1.5"></xsl:template>
    <xsl:template match="/*/responses" mode="convertV2"></xsl:template>
    <xsl:template match="/*/securityDefinitions" mode="convertV2"></xsl:template>
    
    
    <xsl:template match="_X24_ref" mode="convertV2">
        <xsl:variable name="value" select="replace(. , 'definitions', 'components/schemas')"/>
        <xsl:variable name="value2" select="replace($value , '#/parameters', '#/components/parameters')"/>
        <xsl:variable name="value3" select="replace($value2 , '#/responses', '#/components/responses')"/>
        <xsl:variable name="value4" select="replace($value3, '#/securityDefinitions', '#/components/securitySchemes')"/>
        <_X24_ref>
            <xsl:value-of select="$value4"/>
        </_X24_ref>
    </xsl:template>
</xsl:stylesheet>