<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
    xmlns:xs="http://www.w3.org/2001/XMLSchema"
    xmlns:f="http://www.oxygenxml.com/xsl/functions"
    exclude-result-prefixes="xs f"
    version="2.0">
    
    <xsl:include href="handleSchema.xsl"/>
    <xsl:include href="handleOperationFields.xsl"/>
    
    <!-- Generate DITA content for Components object. -->
    <xsl:template name="components">
        <xsl:param name="componentsNode"/>
        <xsl:if test="count($componentsNode/*) > 0">
            <topic id="components" outputclass="openapi-components">
                <title>Components</title>
                <body>
                </body>
                <xsl:call-template name="schemas">
                    <xsl:with-param name="schemasNodes" select="$componentsNode/schemas/*"></xsl:with-param>
                </xsl:call-template>
                <xsl:call-template name="componentResponses">
                    <xsl:with-param name="componentResponsesMapItems" select="$componentsNode/responses/*"></xsl:with-param>
                </xsl:call-template>
                <xsl:call-template name="componentParameters">
                    <xsl:with-param name="paramsMapItems" select="$componentsNode/parameters/*"></xsl:with-param>
                </xsl:call-template>
                <xsl:call-template name="componentExamples">
                    <xsl:with-param name="examplesMapItems" select="$componentsNode/examples/*"></xsl:with-param>
                </xsl:call-template>
                <xsl:call-template name="componentRequestBodies">
                    <xsl:with-param name="reqBodiesMapItems" select="$componentsNode/requestBodies/*"></xsl:with-param>
                </xsl:call-template>
                <xsl:call-template name="componentHeaders">
                    <xsl:with-param name="headersMapItems" select="$componentsNode/headers/*"></xsl:with-param>
                </xsl:call-template>
                <xsl:call-template name="securitySchemes">
                    <xsl:with-param name="securitySchemeMapItems" select="$componentsNode/securitySchemes/*"></xsl:with-param>
                </xsl:call-template>
                <xsl:call-template name="componentLinks">
                    <xsl:with-param name="linksMapItems" select="$componentsNode/links/*"></xsl:with-param>
                </xsl:call-template>
                <xsl:call-template name="componentCallbacks">
                    <xsl:with-param name="callbacksMapItems" select="$componentsNode/callbacks/*"></xsl:with-param>
                </xsl:call-template>
                <xsl:call-template name="componentPathItems">
                    <xsl:with-param name="pathItemMapItems" select="$componentsNode/pathItems/*"></xsl:with-param>
                </xsl:call-template>
                
                <xsl:call-template name="extensionsHandlerAsTopic">
                    <xsl:with-param name="element" select="$componentsNode"/>
                </xsl:call-template>
            </topic>
        </xsl:if>
    </xsl:template>
    
    <!-- Generate DITA content for Header objects from Components. -->
    <xsl:template name="componentHeaders">
        <xsl:param name="headersMapItems"/>
        <xsl:if test="$headersMapItems and count($headersMapItems) > 0">
            <topic id="headers" outputclass="openapi-components-headers">
                <title>Headers</title>
                <body>
                    <xsl:call-template name="headersMap">
                        <xsl:with-param name="headerNodeItems" select="$headersMapItems"/>
                        <xsl:with-param name="isFromComponents" select="true()"></xsl:with-param>
                    </xsl:call-template>
                </body>
            </topic>
        </xsl:if>
    </xsl:template>
    
    <xsl:template name="componentPathItems">
        <xsl:param name="pathItemMapItems"/>
        <xsl:if test="$pathItemMapItems and count($pathItemMapItems) > 0">
            <topic id="pathItems" outputclass="openapi-components-pathItems">
                <title>Path Items</title>
                <body>
                </body>
                <xsl:for-each select="$pathItemMapItems">
                    <topic>
                        <xsl:attribute name="id">
                            <xsl:value-of select="local-name()"/>
                        </xsl:attribute>
                        <xsl:attribute name="outputclass" select="concat('openapi-pathItem ', $toUnescapeIdOutputClass)"/>
                        <title>
                            <xsl:attribute name="outputclass" select="concat('openapi-pathItem-key ', $toUnescapeOutputClass)"/>
                            <xsl:value-of select="local-name()"/>
                        </title>
                        <body>
                            <xsl:if test="./_X24_ref">
                                <div outputclass="openapi-pathItem-ref">
                                    <!-- It's a reference to a pathItem -->
                                    <xsl:call-template name="reference">
                                        <xsl:with-param name="referenceNode" select="./_X24_ref"></xsl:with-param>
                                    </xsl:call-template>
                                </div>
                            </xsl:if>
                        </body>
                        <xsl:if test="not(./_X24_ref)">
                            <xsl:for-each select="./*[local-name() = $restMethods]">
                                <xsl:call-template name="operation">
                                    <xsl:with-param name="operationElement" select="."/>
                                    <xsl:with-param name="parentPathElement" select="./parent::*"/>
                                    <xsl:with-param name="isWebhookOperation" select="false()"/>
                                </xsl:call-template>
                            </xsl:for-each> 
                        </xsl:if>
                    </topic>
                </xsl:for-each>
            </topic>
        </xsl:if>
    </xsl:template>
    
    <!-- Generate DITA content for Callbacks objects from Components. -->
    <xsl:template name="componentCallbacks">
        <xsl:param name="callbacksMapItems"/>
        <xsl:if test="$callbacksMapItems and count($callbacksMapItems) > 0">
            <topic id="callbacks" outputclass="openapi-components-callbacks">
                <title>Callbacks</title>
                <body>
                </body>
                <xsl:call-template name="callbacksMapItems">
                    <xsl:with-param name="calbackItems" select="$callbacksMapItems"/>
                </xsl:call-template>
            </topic>
        </xsl:if>
    </xsl:template>
    
    <!-- Generate DITA content for Link objects from Components. -->
    <xsl:template name="componentLinks">
        <xsl:param name="linksMapItems"/>
        <xsl:if test="$linksMapItems and count($linksMapItems) > 0">
            <topic id="links" outputclass="openapi-components-links">
                <title>Links</title>
                <body>
                    <dl outputclass="openapi-links-list">
                        <xsl:for-each select="$linksMapItems">
                            <dlentry>
                                <xsl:attribute name="id"><xsl:value-of select="local-name()"/></xsl:attribute>
                                <xsl:attribute name="outputclass" select="concat('openapi-link ', $toUnescapeIdOutputClass)"/>
                                <dt>
                                    <xsl:attribute name="outputclass" select="concat('openapi-link-key ', $toUnescapeOutputClass)"/>
                                    <xsl:value-of select="local-name()"/>
                                </dt>
                                <dd>
                                    <xsl:call-template name="link">
                                        <xsl:with-param name="linkObject" select="."/>
                                    </xsl:call-template>
                                </dd>
                            </dlentry>
                        </xsl:for-each>
                    </dl>
                </body>
            </topic>
        </xsl:if>
    </xsl:template>
    
    <!-- Generate DITA content for RequestBody objects from Components. -->
    <xsl:template name="componentRequestBodies">
        <xsl:param name="reqBodiesMapItems"/>
        <xsl:if test="$reqBodiesMapItems and count($reqBodiesMapItems) > 0">
            <topic id="requestBodies" outputclass="openapi-components-requestBodies">
                <title>Request bodies</title>
                <body>
                    <dl outputclass="openapi-requestBodies-list">
                        <xsl:for-each select="$reqBodiesMapItems">
                            <dlentry>
                                <xsl:attribute name="id"><xsl:value-of select="local-name()"/></xsl:attribute>
                                <xsl:attribute name="outputclass" select="concat('openapi-requestBody-key ', $toUnescapeIdOutputClass)"/>
                                <dt>
                                    <xsl:attribute name="outputclass" select="$toUnescapeOutputClass"/>
                                    <xsl:value-of select="local-name()"/>
                                </dt>
                                <dd>
                                    <xsl:call-template name="requestBodyObject">
                                        <xsl:with-param name="requestBody" select="."/>
                                    </xsl:call-template>
                                </dd>
                            </dlentry>
                        </xsl:for-each>
                    </dl>
                </body>
            </topic>
        </xsl:if>
    </xsl:template>
    
    <!-- Generate DITA content for Example objects from Components. -->
    <xsl:template name="componentExamples">
        <xsl:param name="examplesMapItems"/>
        <xsl:if test="$examplesMapItems and count($examplesMapItems) > 0">
            <topic id="examples" outputclass="openapi-components-examples">
                <title>Examples</title>
                <body>
                    <dl outputclass="openapi-examples-list">
                        <xsl:for-each select="$examplesMapItems">
                            <dlentry>
                                <xsl:attribute name="id"><xsl:value-of select="local-name()"/></xsl:attribute>
                                <xsl:attribute name="outputclass" select="concat('openapi-example ',$toUnescapeIdOutputClass)"/>
                                <dt>
                                    <xsl:attribute name="outputclass" select="concat('openapi-example-key ', $toUnescapeOutputClass)"/>
                                    <xsl:value-of select="local-name()"/>
                                </dt>
                                <dd>
                                    <xsl:call-template name="exempleObject">
                                        <xsl:with-param name="exempleObject" select="."/>
                                    </xsl:call-template>
                                </dd>
                            </dlentry>
                        </xsl:for-each>
                    </dl>
                </body>
            </topic>
        </xsl:if>
    </xsl:template>
    
    <!-- Generate DITA content for Response objects from Components. -->
    <xsl:template name="componentResponses">
        <xsl:param name="componentResponsesMapItems"/>
        <xsl:if test="$componentResponsesMapItems and count($componentResponsesMapItems) > 0">
            <topic id="responses" outputclass="openapi-components-responses">
                <title>Responses</title>
                <body>
                    <dl outputclass="openapi-responses-list">
                        <xsl:for-each select="$componentResponsesMapItems">
                            <dlentry>
                                <xsl:attribute name="id"><xsl:value-of select="local-name()"/></xsl:attribute>
                                <xsl:attribute name="outputclass" select="concat('openapi-response ', $toUnescapeIdOutputClass)"/>
                                <dt>
                                    <xsl:attribute name="outputclass" select="concat('openapi-response-key ', $toUnescapeOutputClass)"/>
                                    <xsl:value-of select="local-name()"/>
                                </dt>
                                <dd>
                                    <xsl:call-template name="responseObject">
                                        <xsl:with-param name="responseObjectNode" select="."/>
                                    </xsl:call-template>
                                </dd>
                            </dlentry>
                        </xsl:for-each>
                    </dl>
                </body>
            </topic>
        </xsl:if>
    </xsl:template>
    
    <!-- Generate DITA content for Parameter objects from Components. -->
    <xsl:template name="componentParameters">
        <xsl:param name="paramsMapItems"/>
        <xsl:if test="$paramsMapItems and count($paramsMapItems) > 0">
            <topic id="parameters" outputclass="openapi-components-parameters">
                <title>Parameters</title>
                <body>
                    <dl outputclass="openapi-parameters-list">
                        <xsl:for-each select="$paramsMapItems">
                            <xsl:call-template name="paramObject">
                                <xsl:with-param name="paramObjectNode" select="."/>
                                <xsl:with-param name="paramId" select="local-name()"></xsl:with-param>
                            </xsl:call-template>
                        </xsl:for-each>
                    </dl>
                </body>
            </topic>
        </xsl:if>
    </xsl:template>
</xsl:stylesheet>