/*
 * Decompiled with CFR 0.152.
 */
package com.thaiopensource.relaxng.input.xml;

import com.thaiopensource.datatype.DatatypeLibraryLoader;
import com.thaiopensource.relaxng.edit.AttributePattern;
import com.thaiopensource.relaxng.edit.ChoicePattern;
import com.thaiopensource.relaxng.edit.CompositePattern;
import com.thaiopensource.relaxng.edit.DataPattern;
import com.thaiopensource.relaxng.edit.DefineComponent;
import com.thaiopensource.relaxng.edit.ElementPattern;
import com.thaiopensource.relaxng.edit.EmptyPattern;
import com.thaiopensource.relaxng.edit.GrammarPattern;
import com.thaiopensource.relaxng.edit.GroupPattern;
import com.thaiopensource.relaxng.edit.NameNameClass;
import com.thaiopensource.relaxng.edit.OneOrMorePattern;
import com.thaiopensource.relaxng.edit.OptionalPattern;
import com.thaiopensource.relaxng.edit.Pattern;
import com.thaiopensource.relaxng.edit.RefPattern;
import com.thaiopensource.relaxng.edit.SchemaCollection;
import com.thaiopensource.relaxng.edit.SchemaDocument;
import com.thaiopensource.relaxng.edit.TextPattern;
import com.thaiopensource.relaxng.edit.ZeroOrMorePattern;
import com.thaiopensource.resolver.Resolver;
import com.thaiopensource.resolver.xml.sax.SAXResolver;
import com.thaiopensource.xml.infer.AttributeDecl;
import com.thaiopensource.xml.infer.ChoiceParticle;
import com.thaiopensource.xml.infer.ElementDecl;
import com.thaiopensource.xml.infer.ElementParticle;
import com.thaiopensource.xml.infer.EmptyParticle;
import com.thaiopensource.xml.infer.InferHandler;
import com.thaiopensource.xml.infer.OneOrMoreParticle;
import com.thaiopensource.xml.infer.Particle;
import com.thaiopensource.xml.infer.ParticleVisitor;
import com.thaiopensource.xml.infer.Schema;
import com.thaiopensource.xml.infer.SequenceParticle;
import com.thaiopensource.xml.infer.TextParticle;
import com.thaiopensource.xml.util.Name;
import java.io.IOException;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

class Inferrer {
    private final Schema schema;
    private final Set<Name> multiplyReferencedElementNames = new HashSet<Name>();
    private final GrammarPattern grammar;
    private final ParticleConverter particleConverter = new ParticleConverter();
    private final List<Name> outputQueue = new Vector<Name>();
    private final Set<Name> queued = new HashSet<Name>();
    private String prefixSeparator;
    private static final String SEPARATORS = ".-_";

    static SchemaCollection infer(String[] args, Options options, ErrorHandler eh) throws SAXException, IOException {
        InferHandler handler = new InferHandler(new DatatypeLibraryLoader());
        XMLReader xr = new SAXResolver(options.resolver).createXMLReader();
        xr.setFeature("http://apache.org/xml/features/xinclude", true);
        xr.setFeature("http://apache.org/xml/features/xinclude/fixup-base-uris", false);
        xr.setErrorHandler(eh);
        xr.setContentHandler(handler);
        for (int i = 0; i < args.length; ++i) {
            InputSource in = new InputSource(args[i]);
            if (options.encoding != null) {
                in.setEncoding(options.encoding);
            }
            xr.parse(in);
        }
        SchemaCollection sc = new SchemaCollection();
        sc.setMainUri(args[0]);
        SchemaDocument sd = new SchemaDocument(new Inferrer((Schema)handler.getSchema()).grammar);
        sc.getSchemaDocumentMap().put(sc.getMainUri(), sd);
        return sc;
    }

    private Inferrer(Schema schema) {
        this.schema = schema;
        this.grammar = new GrammarPattern();
        this.findMultiplyReferencedElements();
        this.choosePrefixSeparator();
        this.grammar.getComponents().add(new DefineComponent(DefineComponent.START, this.particleConverter.convert(schema.getStart())));
        for (int i = 0; i < this.outputQueue.size(); ++i) {
            Name elementName = this.outputQueue.get(i);
            this.grammar.getComponents().add(new DefineComponent(this.getDefineName(elementName), this.createElementPattern(elementName)));
        }
    }

    private void findMultiplyReferencedElements() {
        ReferenceFinder finder = new ReferenceFinder();
        this.schema.getStart().accept(finder);
        for (ElementDecl decl : this.schema.getElementDecls().values()) {
            Particle particle = decl.getContentModel();
            if (particle == null) continue;
            particle.accept(finder);
        }
    }

    private void choosePrefixSeparator() {
        Map<String, String> prefixMap = this.schema.getPrefixMap();
        HashSet<String> namespacesInDefines = new HashSet<String>();
        for (Name name : this.multiplyReferencedElementNames) {
            namespacesInDefines.add(name.getNamespaceUri());
        }
        if (namespacesInDefines.size() <= 1) {
            return;
        }
        namespacesInDefines.removeAll(prefixMap.keySet());
        if (namespacesInDefines.size() > 1) {
            namespacesInDefines.remove("");
            int n = 1;
            for (String ns : namespacesInDefines) {
                String prefix;
                while (prefixMap.containsKey(prefix = "ns" + Integer.toString(n++))) {
                }
                prefixMap.put(ns, prefix);
            }
        }
        StringBuffer buf = new StringBuffer();
        boolean bl = true;
        while (true) {
            int n;
            for (int i = 0; i < SEPARATORS.length(); ++i) {
                char c = SEPARATORS.charAt(i);
                for (int j = 0; j < n; ++j) {
                    buf.append(c);
                }
                this.prefixSeparator = buf.toString();
                if (this.prefixSeparatorOk()) {
                    return;
                }
                buf.setLength(0);
            }
            ++n;
        }
    }

    private boolean prefixSeparatorOk() {
        HashSet<String> names = new HashSet<String>();
        for (Name elementName : this.multiplyReferencedElementNames) {
            String name = this.getDefineName(elementName);
            if (names.contains(name)) {
                return false;
            }
            names.add(name);
        }
        return true;
    }

    private Pattern createElementPattern(Name elementName) {
        ElementDecl elementDecl = this.schema.getElementDecl(elementName);
        Particle particle = elementDecl.getContentModel();
        Pattern contentPattern = particle != null ? this.particleConverter.convert(particle) : Inferrer.makeDatatype(elementDecl.getDatatype());
        Map<Name, AttributeDecl> attributeDecls = elementDecl.getAttributeDecls();
        if (attributeDecls.size() > 0) {
            GroupPattern group = new GroupPattern();
            Vector<Name> attributeNames = new Vector<Name>();
            attributeNames.addAll(attributeDecls.keySet());
            Collections.sort(attributeNames, new Comparator<Name>(){

                @Override
                public int compare(Name n1, Name n2) {
                    return Name.compare(n1, n2);
                }
            });
            for (Name attName : attributeNames) {
                AttributeDecl att = attributeDecls.get(attName);
                Pattern tem = att.getDatatype() == null ? new TextPattern() : Inferrer.makeDatatype(att.getDatatype());
                tem = new AttributePattern(this.makeNameClass(attName), tem);
                if (att.isOptional()) {
                    tem = new OptionalPattern(tem);
                }
                group.getChildren().add(tem);
            }
            if (contentPattern instanceof GroupPattern) {
                group.getChildren().addAll(((GroupPattern)contentPattern).getChildren());
            } else if (!(contentPattern instanceof EmptyPattern)) {
                group.getChildren().add(contentPattern);
            }
            contentPattern = group;
        }
        return new ElementPattern(this.makeNameClass(elementName), contentPattern);
    }

    private NameNameClass makeNameClass(Name name) {
        String prefix;
        String ns = name.getNamespaceUri();
        NameNameClass nnc = new NameNameClass(ns, name.getLocalName());
        if (!ns.equals("") && (prefix = this.schema.getPrefixMap().get(ns)) != null) {
            nnc.setPrefix(prefix);
        }
        return nnc;
    }

    private static DataPattern makeDatatype(Name datatypeName) {
        return new DataPattern(datatypeName.getNamespaceUri(), datatypeName.getLocalName());
    }

    private String getDefineName(Name elementName) {
        String prefix;
        if (this.prefixSeparator != null && (prefix = this.schema.getPrefixMap().get(elementName.getNamespaceUri())) != null) {
            return prefix + this.prefixSeparator + elementName.getLocalName();
        }
        return elementName.getLocalName();
    }

    private static Pattern normalize(CompositePattern cp) {
        if (cp.getChildren().size() == 1) {
            return cp.getChildren().get(0);
        }
        return cp;
    }

    static class Options {
        String encoding;
        Resolver resolver;

        Options() {
        }
    }

    private class ParticleConverter
    extends PatternComparator
    implements ParticleVisitor {
        private ParticleConverter() {
        }

        @Override
        public Object visitElement(ElementParticle p) {
            Name name = p.getName();
            if (Inferrer.this.multiplyReferencedElementNames.contains(name)) {
                if (!Inferrer.this.queued.contains(name)) {
                    Inferrer.this.queued.add(name);
                    Inferrer.this.outputQueue.add(name);
                }
                return new RefPattern(Inferrer.this.getDefineName(name));
            }
            return Inferrer.this.createElementPattern(name);
        }

        @Override
        public Object visitChoice(ChoiceParticle p) {
            ChoicePattern cp = new ChoicePattern();
            List<Pattern> children = cp.getChildren();
            this.addChoices(children, p.getChild1());
            this.addChoices(children, p.getChild2());
            Collections.sort(children, this);
            Iterator<Pattern> iter = children.iterator();
            while (iter.hasNext()) {
                if (!(iter.next() instanceof EmptyPattern)) continue;
                iter.remove();
                return this.makeOptional(cp);
            }
            return cp;
        }

        private Object makeOptional(ChoicePattern cp) {
            List<Pattern> children = cp.getChildren();
            boolean done = false;
            int len = children.size();
            for (int i = 0; i < len; ++i) {
                Pattern child = children.get(i);
                if (!(child instanceof OneOrMorePattern)) continue;
                children.set(i, new ZeroOrMorePattern(((OneOrMorePattern)child).getChild()));
                done = true;
            }
            if (done) {
                return Inferrer.normalize(cp);
            }
            return new OptionalPattern(Inferrer.normalize(cp));
        }

        private void addChoices(List<Pattern> children, Particle child) {
            Pattern pattern = this.convert(child);
            if (pattern instanceof ChoicePattern) {
                children.addAll(((ChoicePattern)pattern).getChildren());
            } else {
                children.add(pattern);
            }
        }

        @Override
        public Object visitSequence(SequenceParticle p) {
            GroupPattern gp = new GroupPattern();
            this.addGroup(gp.getChildren(), p.getChild1());
            this.addGroup(gp.getChildren(), p.getChild2());
            return gp;
        }

        private void addGroup(List<Pattern> children, Particle child) {
            Pattern pattern = this.convert(child);
            if (pattern instanceof GroupPattern) {
                children.addAll(((GroupPattern)pattern).getChildren());
            } else {
                children.add(pattern);
            }
        }

        @Override
        public Object visitEmpty(EmptyParticle p) {
            return new EmptyPattern();
        }

        @Override
        public Object visitText(TextParticle p) {
            return new TextPattern();
        }

        @Override
        public Object visitOneOrMore(OneOrMoreParticle p) {
            return new OneOrMorePattern(this.convert(p.getChild()));
        }

        public Pattern convert(Particle particle) {
            return (Pattern)particle.accept(this);
        }
    }

    private class ReferenceFinder
    implements ParticleVisitor {
        private final Set<Name> referencedElementNames = new HashSet<Name>();

        private ReferenceFinder() {
        }

        @Override
        public Object visitElement(ElementParticle p) {
            Name name = p.getName();
            if (this.referencedElementNames.contains(name)) {
                Inferrer.this.multiplyReferencedElementNames.add(name);
            } else {
                this.referencedElementNames.add(name);
            }
            return null;
        }

        @Override
        public Object visitChoice(ChoiceParticle p) {
            p.getChild1().accept(this);
            p.getChild2().accept(this);
            return null;
        }

        @Override
        public Object visitSequence(SequenceParticle p) {
            p.getChild1().accept(this);
            p.getChild2().accept(this);
            return null;
        }

        @Override
        public Object visitEmpty(EmptyParticle p) {
            return null;
        }

        @Override
        public Object visitText(TextParticle p) {
            return null;
        }

        @Override
        public Object visitOneOrMore(OneOrMoreParticle p) {
            return p.getChild().accept(this);
        }
    }

    private static class PatternComparator
    implements Comparator<Pattern> {
        private static final Class<?>[] classOrder = new Class[]{TextPattern.class, RefPattern.class, ElementPattern.class};

        private PatternComparator() {
        }

        @Override
        public int compare(Pattern p1, Pattern p2) {
            if (p1.getClass() != p2.getClass()) {
                return PatternComparator.classIndex(p1.getClass()) - PatternComparator.classIndex(p2.getClass());
            }
            if (p1 instanceof RefPattern) {
                return ((RefPattern)p1).getName().compareTo(((RefPattern)p2).getName());
            }
            if (p1 instanceof ElementPattern) {
                return Name.compare(PatternComparator.extractElementName(p1), PatternComparator.extractElementName(p2));
            }
            return 0;
        }

        private static Name extractElementName(Object o) {
            NameNameClass nnc = (NameNameClass)((ElementPattern)o).getNameClass();
            return new Name(nnc.getNamespaceUri(), nnc.getLocalName());
        }

        private static int classIndex(Class<? extends Pattern> aClass) {
            for (int i = 0; i < classOrder.length; ++i) {
                if (aClass != classOrder[i]) continue;
                return i;
            }
            return classOrder.length;
        }
    }
}

