/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.security.manager;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.security.Policy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.sync.basic.io.FileSystemUtil;
import ro.sync.security.manager.JreNotSupportingSecurityManagerException;
import ro.sync.security.manager.PolicyWrapper;
import ro.sync.security.manager.SandboxSecurityManager;
import ro.sync.security.manager.SystemPropertyPermissionChecker;

public final class SandboxSecurityManagerInstaller {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)SandboxSecurityManagerInstaller.class.getName());
    private static boolean securityDisabled = true;

    @Deprecated
    public static void install(SystemPropertyPermissionChecker propertyChecker, boolean alwaysAskURLConfirmation) {
        try {
            SandboxSecurityManagerInstaller.installInternal(propertyChecker, alwaysAskURLConfirmation);
        }
        catch (IOException ex) {
            LOGGER.error("Cannot install security manager. " + ex, (Throwable)ex);
        }
        catch (JreNotSupportingSecurityManagerException ex) {
            LOGGER.error("Cannot install security manager. Note that starting from java 24 Security Manager isn't supported.", (Throwable)ex);
        }
    }

    public static void installStrict(SystemPropertyPermissionChecker propertyChecker, boolean alwaysAskURLConfirmation) throws JreNotSupportingSecurityManagerException, IOException {
        SandboxSecurityManagerInstaller.installInternal(propertyChecker, alwaysAskURLConfirmation);
    }

    private static void installInternal(SystemPropertyPermissionChecker propertyChecker, boolean alwaysAskURLConfirmation) throws JreNotSupportingSecurityManagerException, IOException {
        try {
            SecurityManager delegate = System.getSecurityManager();
            if (delegate == null) {
                Policy originalPolicy = Policy.getPolicy();
                Policy.setPolicy(new OxygenPolicy(originalPolicy));
                SandboxSecurityManagerInstaller.refreshPolicy(originalPolicy);
            }
            SandboxSecurityManager s = new SandboxSecurityManager(delegate, propertyChecker, alwaysAskURLConfirmation);
            System.setSecurityManager(s);
        }
        catch (UnsupportedOperationException e) {
            throw new JreNotSupportingSecurityManagerException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void refreshPolicy(Policy policy) throws IOException {
        String policyString = "grant { permission java.security.AllPermission; };";
        File dir = null;
        File oxygenTempDir = FileSystemUtil.getOxygenTempDirectory();
        if (oxygenTempDir.exists() || oxygenTempDir.mkdir()) {
            dir = oxygenTempDir;
        }
        File policyFile = File.createTempFile("oxy_policy", ".txt", dir);
        try {
            try (OutputStream fos = Files.newOutputStream(policyFile.toPath(), new OpenOption[0]);){
                fos.write(policyString.getBytes(StandardCharsets.UTF_8));
            }
            System.setProperty("java.security.policy", policyFile.toURI().toURL().toString());
            policy.refresh();
        }
        finally {
            try {
                Files.delete(policyFile.toPath());
            }
            catch (IOException e) {
                LOGGER.warn("Could not delete temporary security policy file: " + policyFile, (Throwable)e);
            }
        }
    }

    public static void restore() {
        SecurityManager manager = System.getSecurityManager();
        if (manager instanceof SandboxSecurityManager) {
            SecurityManager original = ((SandboxSecurityManager)manager).getOriginal();
            System.setSecurityManager(null);
            Policy policy = Policy.getPolicy();
            if (policy instanceof PolicyWrapper) {
                Policy delegate = ((PolicyWrapper)policy).getDelegate();
                Policy.setPolicy(delegate);
                delegate.refresh();
            }
            System.setSecurityManager(original);
        }
    }

    @Deprecated
    public static void installSecurityManager() {
        SandboxSecurityManagerInstaller.installSecurityManager(null, true);
    }

    @Deprecated
    public static void installSecurityManager(SystemPropertyPermissionChecker propertyChecker, boolean alwaysAskURLConfirmation) {
        if (!Boolean.getBoolean("com.oxygenxml.disable.security")) {
            securityDisabled = false;
            SandboxSecurityManagerInstaller.install(propertyChecker, alwaysAskURLConfirmation);
        }
    }

    public static void installSecurityManagerStrict(SystemPropertyPermissionChecker propertyChecker, boolean alwaysAskURLConfirmation) throws JreNotSupportingSecurityManagerException, IOException {
        if (!Boolean.getBoolean("com.oxygenxml.disable.security")) {
            securityDisabled = false;
            SandboxSecurityManagerInstaller.installStrict(propertyChecker, alwaysAskURLConfirmation);
        }
    }

    public static void restoreSecurityManager() {
        SandboxSecurityManagerInstaller.restore();
    }

    public static boolean isSecurityDisabled() {
        return securityDisabled;
    }

    private SandboxSecurityManagerInstaller() {
        throw new UnsupportedOperationException("Instantiation of this utility class is not allowed!");
    }

    public static final class OxygenPolicy
    extends PolicyWrapper {
        public OxygenPolicy(Policy delegate) {
            super(delegate);
        }

        @Override
        public void refresh() {
            try {
                SandboxSecurityManagerInstaller.refreshPolicy(this.delegate);
            }
            catch (IOException e) {
                LOGGER.error("Error refreshing security policy", (Throwable)e);
            }
        }
    }
}

