/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.svn.graph.cache;

import java.io.Serializable;
import org.tmatesoft.svn.core.SVNLogEntryPath;
import ro.sync.annotations.obfuscate.SkipLevel;
import ro.sync.annotations.obfuscate.SkipObfuscate;
import ro.sync.basic.util.Equaler;

@SkipObfuscate(classes=SkipLevel.PRIVATE, fields=SkipLevel.PRIVATE, methods=SkipLevel.PRIVATE)
public class SVNLogEntryPathCache
implements Serializable {
    public static final long serialVersionUID = 5493675984564936543L;
    private String path;
    private char type;
    private String copyPath;
    private long copyRevision;

    public SVNLogEntryPathCache() {
    }

    public SVNLogEntryPathCache(String string, char c2, String string2, long l2) {
        this.path = string;
        this.type = c2;
        this.copyPath = string2;
        this.copyRevision = l2;
    }

    public SVNLogEntryPathCache(SVNLogEntryPath sVNLogEntryPath) {
        this.path = sVNLogEntryPath.getPath();
        this.type = sVNLogEntryPath.getType();
        this.copyPath = sVNLogEntryPath.getCopyPath();
        this.copyRevision = sVNLogEntryPath.getCopyRevision();
    }

    protected Object clone() throws CloneNotSupportedException {
        return new SVNLogEntryPathCache(this.path, this.type, this.copyPath, this.copyRevision);
    }

    public String getCopyPath() {
        return this.copyPath;
    }

    public long getCopyRevision() {
        return this.copyRevision;
    }

    public String getPath() {
        return this.path;
    }

    public char getType() {
        return this.type;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.type);
        stringBuffer.append(' ');
        stringBuffer.append(this.path);
        if (this.copyPath != null) {
            stringBuffer.append("(from ");
            stringBuffer.append(this.copyPath);
            stringBuffer.append(':');
            stringBuffer.append(this.copyRevision);
            stringBuffer.append(')');
        }
        return stringBuffer.toString();
    }

    public boolean equals(Object object) {
        if (object instanceof SVNLogEntryPathCache) {
            SVNLogEntryPathCache sVNLogEntryPathCache = (SVNLogEntryPathCache)object;
            return this.type == sVNLogEntryPathCache.type && this.copyRevision == sVNLogEntryPathCache.copyRevision && Equaler.verifyEquals((Object)this.path, (Object)sVNLogEntryPathCache.path) && Equaler.verifyEquals((Object)this.copyPath, (Object)sVNLogEntryPathCache.copyPath);
        }
        return false;
    }

    public int hashCode() {
        int n2 = (int)((long)this.type + this.copyRevision);
        if (this.path != null) {
            n2 += this.path.hashCode();
        }
        return n2;
    }
}

