/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.svn.auth;

import java.io.File;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.sync.annotations.obfuscate.SkipLevel;
import ro.sync.annotations.obfuscate.SkipObfuscate;
import ro.sync.basic.util.Equaler;
import ro.sync.options.InvalidPersistentObjException;
import ro.sync.options.PersistentObject;

@SkipObfuscate(classes=SkipLevel.PRIVATE, fields=SkipLevel.PRIVATE, methods=SkipLevel.PRIVATE)
public class SVNAuthenticationInfo
implements PersistentObject {
    private static final Logger logger = LoggerFactory.getLogger((String)SVNAuthenticationInfo.class.getName());
    private String password;
    private String user;
    private String realm;
    private String kind;
    private String certificate;
    private String passphrase;
    private String privateKey;
    private String sshSVNUser;

    public SVNAuthenticationInfo() {
    }

    public SVNAuthenticationInfo(String string, String string2, String string3) {
        this.realm = string;
        this.user = string2;
        this.kind = string3;
    }

    public SVNAuthenticationInfo(String string, String string2, String string3, String string4) {
        this.realm = string;
        this.password = string2;
        this.user = string3;
        this.kind = string4;
    }

    public SVNAuthenticationInfo(String string, File file, String string2, String string3) {
        this.realm = string;
        this.certificate = file.getAbsolutePath();
        this.password = string2;
        this.kind = string3;
    }

    public SVNAuthenticationInfo(String string, String string2, File file, String string3, String string4) {
        this.realm = string;
        this.user = string2;
        this.privateKey = file.getAbsolutePath();
        this.passphrase = string3;
        this.kind = string4;
    }

    @Override
    public void checkValid() throws InvalidPersistentObjException {
        if (this.realm == null) {
            throw new InvalidPersistentObjException("null realm for SVNAuthenticationInfo");
        }
        if (this.kind == null) {
            throw new InvalidPersistentObjException("null kind for SVNAuthenticationInfo");
        }
        if ("svn.simple".equals(this.kind)) {
            if (this.user == null) {
                throw new InvalidPersistentObjException("null user for PASSWORD SVNAuthenticationInfo");
            }
            if (this.password == null) {
                throw new InvalidPersistentObjException("null password for PASSWORD SVNAuthenticationInfo");
            }
        } else if ("svn.username".equals(this.kind)) {
            if (this.user == null) {
                throw new InvalidPersistentObjException("null user for USERNAME SVNAuthenticationInfo");
            }
        } else if ("svn.ssl.client-passphrase".equals(this.kind)) {
            if (this.password == null) {
                throw new InvalidPersistentObjException("null password for SSL SVNAuthenticationInfo");
            }
            if (this.certificate == null) {
                throw new InvalidPersistentObjException("null certificate for SSL SVNAuthenticationInfo");
            }
        } else if ("svn.ssh".equals(this.kind)) {
            if (this.privateKey != null) {
                if (this.passphrase == null) {
                    throw new InvalidPersistentObjException("null passphrase for SSH SVNAuthenticationInfo");
                }
                if (this.user == null) {
                    throw new InvalidPersistentObjException("null user for SSH SVNAuthenticationInfo");
                }
            } else {
                if (this.user == null) {
                    throw new InvalidPersistentObjException("null user for SSH SVNAuthenticationInfo");
                }
                if (this.password == null) {
                    throw new InvalidPersistentObjException("null password for SSH SVNAuthenticationInfo");
                }
            }
        }
    }

    public String getPassword() {
        return this.password;
    }

    public boolean isInRealm(String string, String string2) {
        return Equaler.verifyEquals((Object)this.kind, (Object)string2) && Equaler.verifyEquals((Object)this.realm, (Object)string);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Realm: ").append(this.realm);
        stringBuffer.append(" Kind: ").append(this.kind);
        stringBuffer.append(" User: ").append(this.user);
        return stringBuffer.toString();
    }

    public String getUser() {
        return this.user;
    }

    public String getCertificate() {
        return this.certificate;
    }

    public String getPassphrase() {
        return this.passphrase;
    }

    public String getPrivateKey() {
        return this.privateKey;
    }

    public String getKind() {
        return this.kind;
    }

    public boolean equals(Object object) {
        boolean bl = false;
        if (object instanceof SVNAuthenticationInfo) {
            SVNAuthenticationInfo sVNAuthenticationInfo = (SVNAuthenticationInfo)object;
            bl = Equaler.verifyEquals((Object)this.kind, (Object)sVNAuthenticationInfo.kind) && Equaler.verifyEquals((Object)this.realm, (Object)sVNAuthenticationInfo.realm);
        }
        return bl;
    }

    public int hashCode() {
        int n2 = 1;
        if (this.kind != null) {
            n2 += this.kind.hashCode();
        }
        if (this.realm != null) {
            n2 += this.realm.hashCode();
        }
        return n2;
    }

    public String getRealm() {
        return this.realm;
    }

    @Override
    public String[] getNotPersistentFieldNames() {
        return null;
    }

    @Override
    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            logger.error((Object)cloneNotSupportedException, (Throwable)cloneNotSupportedException);
            return null;
        }
    }

    public void setSVNUserName(String string) {
        this.sshSVNUser = string;
    }

    public String getSSHSVNUserName() {
        return this.sshSVNUser;
    }
}

