/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.io;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import ro.sync.annotations.obfuscate.SkipLevel;
import ro.sync.annotations.obfuscate.SkipObfuscate;
import ro.sync.basic.io.FileSystemUtil;
import ro.sync.basic.util.URLUtil;

@SkipObfuscate(classes=SkipLevel.NOT_SPECIFIED, fields=SkipLevel.NOT_SPECIFIED, methods=SkipLevel.PUBLIC)
public class XSLTExtensionIOUtil {
    public static String copyFile(String string, String string2, String string3, String string4) throws IOException {
        return XSLTExtensionIOUtil.copyFile(string, string2, string3, string4, false);
    }

    public static String copyFile(String string, String string2, String string3, String string4, boolean bl) throws IOException {
        Serializable serializable;
        if (string2 == null || "".equals(string2)) {
            return "";
        }
        try {
            serializable = new URL(string2);
            if (!"file".equals(((URL)serializable).getProtocol())) {
                throw new IllegalArgumentException("Only local resources are supported: " + string2);
            }
            string2 = URLUtil.getCanonicalFileFromFileUrl((URL)serializable).toString();
        }
        catch (MalformedURLException malformedURLException) {
            string2 = URLUtil.uncorrect((String)string2);
        }
        serializable = new File(string).getCanonicalFile();
        if (!((File)serializable).exists()) {
            throw new IOException("Input base folder does not exist: " + (File)serializable);
        }
        File file = new File(string2);
        if (!file.isAbsolute()) {
            file = new File((File)serializable, string2);
        }
        file = file.getCanonicalFile();
        File file2 = new File(string3).getCanonicalFile();
        if (!file.exists()) {
            File file3 = new File(file2, string2).getCanonicalFile();
            if (!file3.exists()) {
                throw new IOException("Input file does not exist: " + file);
            }
            return string2;
        }
        String string5 = file.toString();
        String string6 = ((File)serializable).toString();
        Object object = null;
        if (string5.startsWith(string6)) {
            if (string5.length() == string6.length()) {
                throw new IOException("Empty input file path provided. Please provide a non-empty input file path.");
            }
            object = string5.substring(1 + string6.length());
        } else {
            object = string4 + "/" + XSLTExtensionIOUtil.b(file);
        }
        object = ((String)object).replace('\\', '/').replace(' ', '_');
        File file4 = new File(file2, (String)object).getCanonicalFile();
        File file5 = file4.getParentFile();
        if (!file5.exists() && !file5.mkdirs()) {
            throw new IOException("Could not create output folder: " + file5);
        }
        if (!file4.exists() && !bl) {
            FileSystemUtil.copyFile((File)file, (File)file4, (boolean)true);
        }
        return object;
    }

    static String b(File file) {
        String string = file.getName();
        int n2 = string.lastIndexOf(".");
        if (n2 < 0) {
            n2 = string.length();
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(string.substring(0, n2)).append("_").append(Math.abs(file.toString().hashCode())).append(string.substring(n2));
        return stringBuilder.toString();
    }

    public static String getAbsolutePath(String string, String string2, String string3) throws IOException {
        String string4 = null;
        URL uRL = new URL(string2);
        File file = URLUtil.getAbsoluteFileFromFileUrl((URL)uRL).getParentFile();
        File file2 = new File(file, string3).getCanonicalFile();
        URL uRL2 = new URL(string);
        File file3 = URLUtil.getAbsoluteFileFromFileUrl((URL)uRL2).getParentFile();
        string4 = URLUtil.getRelativePath((String)file3.toString(), (String)file2.toString());
        string4 = string4.replace('\\', '/');
        return string4;
    }

    public static String getSubstringBeforeLastSpaceOrDot(String string) {
        int n2 = string.lastIndexOf(" ");
        int n3 = string.lastIndexOf(".");
        String string2 = null;
        string2 = n2 < 0 && n3 < 0 ? string : (n2 > n3 ? string.substring(0, n2) : string.substring(0, n3));
        return string2;
    }

    public static void saveToURL(String string, String string2) throws IOException {
        URL uRL = new URL(string);
        File file = URLUtil.getAbsoluteFileFromFileUrl((URL)uRL);
        file.getParentFile().mkdirs();
        try (OutputStreamWriter outputStreamWriter = new OutputStreamWriter((OutputStream)new FileOutputStream(file), StandardCharsets.UTF_8);){
            outputStreamWriter.write(string2);
        }
    }
}

