/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.ecss.webapp.dita;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.net.URL;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.sync.annotations.api.API;
import ro.sync.annotations.api.APIType;
import ro.sync.annotations.api.SourceType;
import ro.sync.basic.util.URLUtil;
import ro.sync.ecss.conditions.ib;
import ro.sync.ecss.dita.ContextKeyManager;
import ro.sync.ecss.dita.map.checker.d.f;
import ro.sync.ecss.dita.map.checker.d.h;
import ro.sync.ecss.extensions.api.AuthorAccess;
import ro.sync.ecss.extensions.api.AuthorExtensionStateListener;
import ro.sync.ecss.extensions.api.ExtensionsBundle;
import ro.sync.ecss.extensions.api.access.EditingSessionContext;
import ro.sync.ecss.extensions.api.node.AuthorDocument;
import ro.sync.ecss.extensions.api.node.AuthorElement;
import ro.sync.ecss.extensions.api.webapp.AuthorDocumentModel;
import ro.sync.ecss.webapp.dita.DITAMapEntryTitleInfo;
import ro.sync.ecss.webapp.dita.DITAMapLoadingException;
import ro.sync.ecss.webapp.dita.b;
import ro.sync.ecss.webapp.dita.e;
import ro.sync.ecss.webapp.dita.g;
import ro.sync.ecss.webapp.dita.l;
import ro.sync.ecss.webapp.ditamap.DITAMapDocumentModel;
import ro.sync.ecss.webapp.ditamap.DITAMapDocumentModelImpl;
import ro.sync.exml.editor.o;
import ro.sync.exml.editor.xmleditor.db;
import ro.sync.exml.workspace.api.editor.page.ditamap.model.DITAMapModel;

@API(type=APIType.INTERNAL, src=SourceType.PRIVATE)
public final class WebappDITAAccess {
    private static final Logger b = LoggerFactory.getLogger((String)WebappDITAAccess.class.getName());

    private WebappDITAAccess() {
        throw new UnsupportedOperationException("Instantiation of this utility class is not allowed!");
    }

    public static boolean setDitamap(AuthorDocumentModel authorDocumentModel, String string) {
        AuthorAccess authorAccess;
        EditingSessionContext editingSessionContext;
        AuthorExtensionStateListener authorExtensionStateListener = WebappDITAAccess.d(authorDocumentModel);
        if (authorExtensionStateListener != null && (editingSessionContext = (authorAccess = authorDocumentModel.getAuthorAccess()).getEditorAccess().getEditingContext()) != null) {
            editingSessionContext.setAttribute("dita.root.map.url", string);
            authorExtensionStateListener.deactivated(authorAccess);
            authorExtensionStateListener.activated(authorAccess);
            return true;
        }
        return false;
    }

    public static boolean setDitamap(AuthorDocumentModel authorDocumentModel, DITAMapModel dITAMapModel) {
        AuthorAccess authorAccess;
        EditingSessionContext editingSessionContext;
        AuthorExtensionStateListener authorExtensionStateListener = WebappDITAAccess.d(authorDocumentModel);
        if (authorExtensionStateListener != null && (editingSessionContext = (authorAccess = authorDocumentModel.getAuthorAccess()).getEditorAccess().getEditingContext()) != null) {
            String string = dITAMapModel.getUrl().toString();
            editingSessionContext.setAttribute("dita.root.map.url", string);
            b b2 = (b)dITAMapModel;
            ContextKeyManager contextKeyManager = b2.qcq();
            editingSessionContext.setAttribute("dita.root.map.keys.manager", contextKeyManager);
            h h2 = b2.ocq();
            Optional<URL> optional = b2.mcq();
            WebappDITAAccess.c(authorAccess, optional, h2);
            authorExtensionStateListener.deactivated(authorAccess);
            authorExtensionStateListener.activated(authorAccess);
            return true;
        }
        return false;
    }

    public static boolean removeContext(AuthorDocumentModel authorDocumentModel) {
        AuthorAccess authorAccess;
        EditingSessionContext editingSessionContext;
        AuthorExtensionStateListener authorExtensionStateListener = WebappDITAAccess.d(authorDocumentModel);
        if (authorExtensionStateListener != null && (editingSessionContext = (authorAccess = authorDocumentModel.getAuthorAccess()).getEditorAccess().getEditingContext()) != null) {
            editingSessionContext.setAttribute("dita.root.map.url", null);
            WebappDITAAccess.c(authorAccess, Optional.empty(), new ro.sync.ecss.dita.map.checker.d.g());
            authorExtensionStateListener.deactivated(authorAccess);
            authorExtensionStateListener.activated(authorAccess);
            return true;
        }
        return false;
    }

    private static AuthorExtensionStateListener d(AuthorDocumentModel authorDocumentModel) {
        db db2 = authorDocumentModel.getDocTypeProvider();
        if (db2 == null) {
            b.warn("Missing DocumentTypeProvider");
            return null;
        }
        o o2 = db2.qod();
        if (o2 == null) {
            b.warn("Missing EditorDocumentType");
            return null;
        }
        ExtensionsBundle extensionsBundle = o2.pip();
        if (extensionsBundle == null) {
            b.info("Missing extensions bundle");
            return null;
        }
        if (!"DITA.document.type".equals(extensionsBundle.getDocumentTypeID())) {
            return null;
        }
        AuthorExtensionStateListener authorExtensionStateListener = extensionsBundle.createAuthorExtensionStateListener();
        if (authorExtensionStateListener == null) {
            b.warn("Missing AuthorExtensionStateListener");
            return null;
        }
        return authorExtensionStateListener;
    }

    private static void c(AuthorAccess authorAccess, Optional<URL> optional, h h2) {
        EditingSessionContext editingSessionContext = authorAccess.getEditorAccess().getEditingContext();
        AuthorDocument authorDocument = authorAccess.getDocumentController().getAuthorDocumentNode();
        Set<String> set = new ib(authorDocument).d();
        if (set != null && h2 instanceof f) {
            ((f)h2).o(set);
        }
        editingSessionContext.setAttribute("condition.processor", h2);
        String string = optional.map(URL::toExternalForm).orElse(null);
        editingSessionContext.setAttribute("dita.val.url", string);
    }

    public static String getDitamapCompactRepresentation(URL uRL, List<URL> list) {
        return WebappDITAAccess.getDitamapCompactRepresentation(uRL, null, list);
    }

    public static String getDitamapCompactRepresentation(URL uRL2, URL uRL3, List<URL> list) {
        String string = null;
        try {
            List<String> list2 = list.stream().map(uRL -> URLUtil.getEditorLocationKey((URL)uRL, (boolean)true)).collect(Collectors.toList());
            b b2 = new b(uRL2, uRL3);
            List<g> list3 = new l(b2).e(list2);
            if (!list3.isEmpty()) {
                e e2 = new e(b2, list3, list2);
                ObjectMapper objectMapper = new ObjectMapper();
                string = objectMapper.writeValueAsString((Object)e2.b());
            }
        }
        catch (Exception exception) {
            b.error((Object)exception, (Throwable)exception);
        }
        return string;
    }

    public static DITAMapModel createDitaMapModel(URL uRL, URL uRL2) throws DITAMapLoadingException {
        return new b(uRL, uRL2);
    }

    public static String getDitamapEntryTitle(DITAMapModel dITAMapModel, AuthorElement authorElement) {
        return ((b)dITAMapModel).getDitamapEntryTitle(authorElement, false, false).getTitle();
    }

    public static DITAMapEntryTitleInfo getDitamapEntryTitleInfo(DITAMapModel dITAMapModel, AuthorElement authorElement) {
        return ((b)dITAMapModel).getDitamapEntryTitle(authorElement, true, false);
    }

    public static DITAMapEntryTitleInfo getDitamapEntryTitleFast(DITAMapModel dITAMapModel, AuthorElement authorElement) {
        return ((b)dITAMapModel).getDitamapEntryTitle(authorElement, false, true);
    }

    public static void invalidateDitamapEntryTitleInfo(DITAMapModel dITAMapModel, AuthorElement authorElement) {
        ((b)dITAMapModel).invalidateTitle(authorElement);
    }

    public static DITAMapEntryTitleInfo getDitamapEntryTitleInfo(DITAMapDocumentModel dITAMapDocumentModel, AuthorElement authorElement, boolean bl) {
        return ((DITAMapDocumentModelImpl)dITAMapDocumentModel).getDitamapEntryTitle(authorElement, true, bl);
    }

    public static void invalidateDitamapEntryTitleInfo(DITAMapDocumentModel dITAMapDocumentModel, AuthorElement authorElement) {
        ((DITAMapDocumentModelImpl)dITAMapDocumentModel).invalidateTitle(authorElement);
    }
}

