/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.ecss.extensions.commons.table.support;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import ro.sync.annotations.api.API;
import ro.sync.annotations.api.APIType;
import ro.sync.annotations.api.SourceType;
import ro.sync.basic.util.NumberFormatException;
import ro.sync.basic.util.NumberParserUtil;
import ro.sync.ecss.extensions.api.AuthorDocumentController;
import ro.sync.ecss.extensions.api.AuthorOperationException;
import ro.sync.ecss.extensions.api.AuthorTableCellSpanProvider;
import ro.sync.ecss.extensions.api.AuthorTableColumnWidthProviderBase;
import ro.sync.ecss.extensions.api.WidthRepresentation;
import ro.sync.ecss.extensions.api.node.AttrValue;
import ro.sync.ecss.extensions.api.node.AuthorElement;
import ro.sync.ecss.extensions.api.node.AuthorNode;
import ro.sync.ecss.extensions.commons.table.support.CALSTableCellInfoProvider;
import ro.sync.ecss.extensions.commons.table.support.DITACALSTableCellInfoProvider;
import ro.sync.ecss.extensions.commons.table.support.DITASimpleTableCellSpanProvider;
import ro.sync.ecss.extensions.commons.table.support.errorscanner.CALSAndHTMLTableLayoutProblem;

@API(type=APIType.INTERNAL, src=SourceType.PUBLIC)
public class DITATableCellInfoProvider
extends AuthorTableColumnWidthProviderBase
implements AuthorTableCellSpanProvider {
    private static final String SIMPLETABLE_CLASS_VALUE = " topic/simpletable ";
    private static final String SIMPLETABLE_CELL_CLASS_VALUE = " topic/stentry ";
    private static final String SIMPLETABLE_ROW_CLASS_VALUE = " topic/strow ";
    private static final String SIMPLETABLE_HEAD_CLASS_VALUE = " topic/sthead ";
    private static final String ATTRIBUTE_NAME_CLASS = "class";
    private static final String ATTRIBUTE_NAME_RELCOLWIDTH = "relcolwidth";
    private CALSTableCellInfoProvider calsProvider;
    private DITASimpleTableCellSpanProvider simpleTableCellSpanProvider;
    private List<WidthRepresentation> columnWidths = new ArrayList<WidthRepresentation>();
    private Set<String> simpleTableCellTagNames = new HashSet<String>();
    private AuthorElement tableElement;

    @Override
    public void init(AuthorElement authorElement) {
        this.tableElement = authorElement;
        this.calsProvider = null;
        this.simpleTableCellSpanProvider = null;
        AttrValue attrValue = authorElement.getAttribute(ATTRIBUTE_NAME_CLASS);
        if (attrValue == null || attrValue.getRawValue() == null || !attrValue.getRawValue().contains(" ut-d/imagemap ")) {
            if (attrValue != null && attrValue.getRawValue() != null && attrValue.getRawValue().contains(SIMPLETABLE_CLASS_VALUE)) {
                String string;
                this.simpleTableCellSpanProvider = new DITASimpleTableCellSpanProvider();
                this.simpleTableCellSpanProvider.init(authorElement);
                this.simpleTableCellTagNames = DITATableCellInfoProvider.detectSimpleTableCellTagNames(authorElement);
                AttrValue attrValue2 = authorElement.getAttribute(ATTRIBUTE_NAME_RELCOLWIDTH);
                if (attrValue2 != null && (string = attrValue2.getValue().trim()).length() > 0) {
                    String[] stringArray;
                    for (String string2 : stringArray = string.split(" ")) {
                        Object object;
                        float f2 = 0.0f;
                        if (string2.length() <= 0) continue;
                        if (string2.endsWith("*")) {
                            object = string2.substring(0, string2.length() - 1);
                            if (((String)object).length() == 0) {
                                f2 = 1.0f;
                            } else {
                                try {
                                    f2 = NumberParserUtil.parseFloat((String)object);
                                }
                                catch (NumberFormatException numberFormatException) {}
                            }
                        } else if ((string2.endsWith("pt") || string2.endsWith("px") || string2.endsWith("in")) && this.errorsListener != null) {
                            this.errorsListener.add(authorElement, authorElement, CALSAndHTMLTableLayoutProblem.COLUMN_WIDTH_NO_MEASURING_UNITS_VALUE_INCORRECT, string2);
                        }
                        object = new WidthRepresentation(0.0f, null, f2, false);
                        this.columnWidths.add((WidthRepresentation)object);
                    }
                }
            } else {
                this.calsProvider = new DITACALSTableCellInfoProvider();
                this.calsProvider.init(authorElement);
            }
        }
    }

    private static Set<String> detectSimpleTableCellTagNames(AuthorElement authorElement) {
        HashSet<String> hashSet = new HashSet<String>();
        List<AuthorNode> list = authorElement.getContentNodes();
        for (AuthorNode authorNode : list) {
            AttrValue attrValue;
            if (authorNode.getType() != 0 || (attrValue = ((AuthorElement)authorNode).getAttribute(ATTRIBUTE_NAME_CLASS)) == null || attrValue.getRawValue() == null || !attrValue.getRawValue().contains(SIMPLETABLE_ROW_CLASS_VALUE) && !attrValue.getRawValue().contains(SIMPLETABLE_HEAD_CLASS_VALUE)) continue;
            List<AuthorNode> list2 = ((AuthorElement)authorNode).getContentNodes();
            for (AuthorNode authorNode2 : list2) {
                if (authorNode2.getType() != 0 || (attrValue = ((AuthorElement)authorNode2).getAttribute(ATTRIBUTE_NAME_CLASS)) == null || attrValue.getRawValue() == null || !attrValue.getRawValue().contains(SIMPLETABLE_CELL_CLASS_VALUE)) continue;
                hashSet.add(((AuthorElement)authorNode2).getLocalName());
            }
        }
        return hashSet;
    }

    private boolean isSimpleTableCell(String string) {
        return this.simpleTableCellTagNames.contains(string);
    }

    private static boolean isRelTableCell(String string) {
        return "relcell".equals(string) || "relcolspec".equals(string);
    }

    @Override
    public Integer getColSpan(AuthorElement authorElement) {
        Integer n2 = null;
        if (this.calsProvider != null) {
            n2 = this.calsProvider.getColSpan(authorElement);
        } else if (this.simpleTableCellSpanProvider != null) {
            n2 = this.simpleTableCellSpanProvider.getColSpan(authorElement);
        }
        return n2;
    }

    @Override
    public Integer getRowSpan(AuthorElement authorElement) {
        Integer n2 = null;
        if (this.calsProvider != null) {
            n2 = this.calsProvider.getRowSpan(authorElement);
        } else if (this.simpleTableCellSpanProvider != null) {
            n2 = this.simpleTableCellSpanProvider.getRowSpan(authorElement);
        }
        return n2;
    }

    @Override
    public boolean hasColumnSpecifications(AuthorElement authorElement) {
        boolean bl = true;
        if (this.calsProvider != null) {
            bl = this.calsProvider.hasColumnSpecifications(authorElement);
        } else if (this.simpleTableCellSpanProvider != null) {
            bl = this.simpleTableCellSpanProvider.hasColumnSpecifications(authorElement);
        }
        return bl;
    }

    @Override
    public String getDescription() {
        String string = null;
        string = this.calsProvider != null ? this.calsProvider.getDescription() : (this.simpleTableCellSpanProvider != null ? this.simpleTableCellSpanProvider.getDescription() : "Provides information about cells in DITA simple tables");
        return string;
    }

    @Override
    public List<WidthRepresentation> getCellWidth(AuthorElement authorElement, int n2, int n3) {
        List<WidthRepresentation> list = null;
        if (this.calsProvider != null) {
            list = this.calsProvider.getCellWidth(authorElement, n2, n3);
        } else if (n2 < this.columnWidths.size()) {
            list = new ArrayList<WidthRepresentation>();
            list.add(this.columnWidths.get(n2));
        }
        return list;
    }

    @Override
    public void commitColumnWidthModifications(AuthorDocumentController authorDocumentController, WidthRepresentation[] widthRepresentationArray, String string) throws AuthorOperationException {
        if (this.isSimpleTableCell(string)) {
            this.columnWidths.clear();
            StringBuilder stringBuilder = new StringBuilder();
            for (int i2 = 0; i2 < widthRepresentationArray.length; ++i2) {
                this.columnWidths.add(widthRepresentationArray[i2]);
                stringBuilder.append(widthRepresentationArray[i2].getRelativeWidth()).append("*");
                if (i2 == widthRepresentationArray.length - 1) continue;
                stringBuilder.append(" ");
            }
            authorDocumentController.setAttribute(ATTRIBUTE_NAME_RELCOLWIDTH, stringBuilder.length() > 0 ? new AttrValue(stringBuilder.toString()) : null, this.tableElement);
        } else {
            this.calsProvider.commitColumnWidthModifications(authorDocumentController, widthRepresentationArray, string);
        }
    }

    @Override
    public void commitTableWidthModification(AuthorDocumentController authorDocumentController, int n2, String string) throws AuthorOperationException {
        if (this.calsProvider != null) {
            this.calsProvider.commitTableWidthModification(authorDocumentController, n2, string);
        }
    }

    @Override
    public WidthRepresentation getTableWidth(String string) {
        if (this.calsProvider != null) {
            return this.calsProvider.getTableWidth(string);
        }
        return null;
    }

    @Override
    public boolean isTableAcceptingWidth(String string) {
        return false;
    }

    @Override
    public boolean isTableAndColumnsResizable(String string) {
        boolean bl = false;
        if (this.isSimpleTableCell(string)) {
            bl = true;
        } else if (!DITATableCellInfoProvider.isRelTableCell(string) && this.calsProvider != null) {
            bl = this.calsProvider.isTableAndColumnsResizable(string);
        }
        return bl;
    }

    @Override
    public boolean isAcceptingFixedColumnWidths(String string) {
        boolean bl = false;
        if (!this.isSimpleTableCell(string) && !DITATableCellInfoProvider.isRelTableCell(string) && this.calsProvider != null) {
            bl = this.calsProvider.isAcceptingFixedColumnWidths(string);
        }
        return bl;
    }

    @Override
    public boolean isAcceptingPercentageColumnWidths(String string) {
        boolean bl = false;
        if (!this.isSimpleTableCell(string) && !DITATableCellInfoProvider.isRelTableCell(string) && this.calsProvider != null) {
            bl = this.calsProvider.isAcceptingPercentageColumnWidths(string);
        }
        return bl;
    }

    @Override
    public boolean isAcceptingProportionalColumnWidths(String string) {
        boolean bl = false;
        if (this.isSimpleTableCell(string)) {
            bl = true;
        } else if (!DITATableCellInfoProvider.isRelTableCell(string) && this.calsProvider != null) {
            bl = this.calsProvider.isAcceptingProportionalColumnWidths(string);
        }
        return bl;
    }

    @Override
    public List<WidthRepresentation> getAllColspecWidthRepresentations() {
        List<WidthRepresentation> list = null;
        list = this.calsProvider != null ? this.calsProvider.getAllColspecWidthRepresentations() : this.columnWidths;
        return list;
    }
}

