/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.ecss.extensions.commons.table.properties;

import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.ListCellRenderer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.sync.annotations.api.API;
import ro.sync.annotations.api.APIType;
import ro.sync.annotations.api.SourceType;
import ro.sync.annotations.obfuscate.SkipLevel;
import ro.sync.annotations.obfuscate.SkipObfuscate;
import ro.sync.ecss.extensions.api.AuthorOperationException;
import ro.sync.ecss.extensions.api.AuthorResourceBundle;
import ro.sync.ecss.extensions.commons.table.properties.GuiElements;
import ro.sync.ecss.extensions.commons.table.properties.PropertySelectionController;
import ro.sync.ecss.extensions.commons.table.properties.TableProperty;

@API(type=APIType.NOT_EXTENDABLE, src=SourceType.PRIVATE)
@SkipObfuscate(classes=SkipLevel.NOT_SPECIFIED, fields=SkipLevel.NOT_SPECIFIED, methods=SkipLevel.PUBLIC)
public class SAPropertyPanel {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)SAPropertyPanel.class.getName());
    private TableProperty tableProperty;
    private final List<JComponent> valuesComponent = new ArrayList<JComponent>();
    private String currentlySelectedValue;

    public SAPropertyPanel(JPanel jPanel, GridBagConstraints gridBagConstraints, TableProperty tableProperty, AuthorResourceBundle authorResourceBundle, final PropertySelectionController propertySelectionController, int n2, boolean bl) {
        Object object;
        this.tableProperty = tableProperty;
        this.currentlySelectedValue = tableProperty.getCurrentValue();
        String string = tableProperty.getAttributeName();
        String string2 = tableProperty.getAttributeRenderString();
        GuiElements guiElements = tableProperty.getGuiType();
        List<String> list = tableProperty.getValues();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.insets = new Insets(1, 5, 1, 1);
        gridBagConstraints.gridy = bl ? 0 : ++gridBagConstraints.gridy;
        gridBagConstraints.gridwidth = 1;
        Object object2 = object = string2 != null ? authorResourceBundle.getMessage(string2) : string;
        if (GuiElements.COMBOBOX == guiElements) {
            gridBagConstraints.fill = 0;
            gridBagConstraints.anchor = 17;
            gridBagConstraints.weightx = 0.0;
            object = (String)object + ":";
            JLabel jLabel = new JLabel((String)object);
            jPanel.add((Component)jLabel, gridBagConstraints);
            ++gridBagConstraints.gridx;
            gridBagConstraints.fill = 2;
            gridBagConstraints.weightx = 1.0;
            JComboBox jComboBox = new JComboBox(list.toArray(new String[0])){

                @Override
                public void setSelectedItem(Object object) {
                    String string = (String)this.dataModel.getSelectedItem();
                    super.setSelectedItem(object);
                    if (string.equals(object)) {
                        this.selectedItemChanged();
                    }
                }
            };
            jLabel.setLabelFor(jComboBox);
            final ListCellRenderer listCellRenderer = jComboBox.getRenderer();
            jComboBox.setRenderer(new ListCellRenderer(){

                public Component getListCellRendererComponent(JList jList, Object object, int n2, boolean bl, boolean bl2) {
                    JLabel jLabel = (JLabel)listCellRenderer.getListCellRendererComponent(jList, object, n2, bl, bl2);
                    if ("<preserve>".equals(object) || "<not set>".equals(object)) {
                        Font font = jLabel.getFont();
                        Font font2 = font.deriveFont(2);
                        jLabel.setFont(font2);
                    }
                    return jLabel;
                }
            });
            jComboBox.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent itemEvent) {
                    if (itemEvent.getStateChange() == 1) {
                        SAPropertyPanel.this.currentlySelectedValue = (String)itemEvent.getItem();
                        try {
                            propertySelectionController.selectionChanged(SAPropertyPanel.this.tableProperty, SAPropertyPanel.this.currentlySelectedValue);
                        }
                        catch (AuthorOperationException authorOperationException) {
                            LOGGER.debug(authorOperationException.getMessage(), (Throwable)authorOperationException);
                        }
                    }
                }
            });
            if (tableProperty.getCurrentValue() != null) {
                jComboBox.setSelectedItem(tableProperty.getCurrentValue());
            }
            jComboBox.setEnabled(this.tableProperty.isActive());
            jPanel.add((Component)jComboBox, gridBagConstraints);
            ++gridBagConstraints.gridy;
            this.valuesComponent.add(jComboBox);
        } else if (GuiElements.RADIO_BUTTONS == guiElements) {
            gridBagConstraints.gridwidth = 2;
            gridBagConstraints.fill = 2;
            gridBagConstraints.weightx = 1.0;
            ButtonGroup buttonGroup = new ButtonGroup();
            for (int i2 = 0; i2 < list.size(); ++i2) {
                gridBagConstraints.insets.top = i2 == 0 ? (gridBagConstraints.insets.top += 4) : 3;
                JRadioButton jRadioButton = new JRadioButton(list.get(i2));
                jRadioButton.setOpaque(false);
                this.valuesComponent.add(jRadioButton);
                jRadioButton.addItemListener(new ItemListener(){

                    @Override
                    public void itemStateChanged(ItemEvent itemEvent) {
                        if (itemEvent.getStateChange() == 1) {
                            JRadioButton jRadioButton = (JRadioButton)itemEvent.getItem();
                            SAPropertyPanel.this.currentlySelectedValue = jRadioButton.getText();
                            try {
                                propertySelectionController.selectionChanged(SAPropertyPanel.this.tableProperty, SAPropertyPanel.this.currentlySelectedValue);
                            }
                            catch (AuthorOperationException authorOperationException) {
                                LOGGER.debug(authorOperationException.getMessage(), (Throwable)authorOperationException);
                            }
                        }
                    }
                });
                if (this.tableProperty.getCurrentValue() != null && list.get(i2).equals(this.tableProperty.getCurrentValue())) {
                    jRadioButton.setSelected(true);
                }
                jRadioButton.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
                buttonGroup.add(jRadioButton);
                if ("<preserve>".equals(list.get(i2)) || "<not set>".equals(list.get(i2))) {
                    Font font = jRadioButton.getFont();
                    Font font2 = font.deriveFont(2);
                    jRadioButton.setFont(font2);
                }
                jRadioButton.setEnabled(this.tableProperty.isActive());
                jPanel.add((Component)jRadioButton, gridBagConstraints);
                ++gridBagConstraints.gridy;
            }
        }
    }

    public TableProperty getModifiedProperty() {
        TableProperty tableProperty = null;
        String string = this.tableProperty.getCurrentValue();
        if (this.tableProperty.getGuiType() == GuiElements.COMBOBOX) {
            string = (String)((JComboBox)this.valuesComponent.get(0)).getSelectedItem();
        } else if (this.tableProperty.getGuiType() == GuiElements.RADIO_BUTTONS) {
            for (int i2 = 0; i2 < this.valuesComponent.size(); ++i2) {
                JRadioButton jRadioButton = (JRadioButton)this.valuesComponent.get(i2);
                boolean bl = jRadioButton.isSelected();
                if (!bl) continue;
                string = jRadioButton.getText();
                break;
            }
        }
        if (this.tableProperty.getCurrentValue() == null || this.tableProperty.getCurrentValue() != null && !this.tableProperty.getCurrentValue().equals(string)) {
            tableProperty = new TableProperty(this.tableProperty.getAttributeName(), this.tableProperty.getAttributeRenderString(), this.tableProperty.getValues(), string, this.tableProperty.isAttribute());
            tableProperty.setOldValue(this.tableProperty.getCurrentValue());
        }
        return tableProperty;
    }

    public String getCurrentlySelectedValue() {
        return this.currentlySelectedValue;
    }

    public TableProperty getTableProperty() {
        return this.tableProperty;
    }
}

