/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.ecss.extensions.commons.table.operations.xhtml;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.text.Position;
import ro.sync.annotations.api.API;
import ro.sync.annotations.api.APIType;
import ro.sync.annotations.api.SourceType;
import ro.sync.ecss.extensions.api.ArgumentDescriptor;
import ro.sync.ecss.extensions.api.ArgumentsMap;
import ro.sync.ecss.extensions.api.AuthorAccess;
import ro.sync.ecss.extensions.api.AuthorDocumentController;
import ro.sync.ecss.extensions.api.AuthorOperation;
import ro.sync.ecss.extensions.api.AuthorOperationException;
import ro.sync.ecss.extensions.api.AuthorOperationStoppedByUserException;
import ro.sync.ecss.extensions.api.WebappCompatible;
import ro.sync.ecss.extensions.api.node.AuthorDocumentFragment;
import ro.sync.ecss.extensions.api.node.AuthorElement;
import ro.sync.ecss.extensions.api.node.AuthorNode;
import ro.sync.ecss.extensions.api.schemaaware.SchemaAwareHandlerResult;
import ro.sync.ecss.extensions.api.webapp.WebappRestSafe;
import ro.sync.ecss.extensions.commons.operations.CommonsOperationsUtil;
import ro.sync.ecss.extensions.commons.table.operations.AuthorTableHelper;
import ro.sync.ecss.extensions.commons.table.operations.InsertTableOperationBase;
import ro.sync.ecss.extensions.commons.table.operations.TableInfo;
import ro.sync.ecss.extensions.commons.table.operations.TableOperationsUtil;
import ro.sync.ecss.extensions.commons.table.operations.xhtml.ECXHTMLTableCustomizerInvoker;
import ro.sync.ecss.extensions.commons.table.operations.xhtml.SAXHTMLTableCustomizerInvoker;
import ro.sync.exml.workspace.api.Platform;

@API(type=APIType.INTERNAL, src=SourceType.PUBLIC)
@WebappCompatible(value=false)
@WebappRestSafe
public class InsertTableOperation
implements AuthorOperation,
InsertTableOperationBase {
    private static final String NAMESPACE = "http://www.w3.org/1999/xhtml";
    private static final CommonsOperationsUtil.ConversionElementHelper CONVERSION_ELEMENT_CHECKER = new CommonsOperationsUtil.ConversionElementHelper(){

        @Override
        public boolean blockContentMustBeConverted(AuthorNode authorNode, AuthorAccess authorAccess) throws AuthorOperationException {
            AuthorElement authorElement;
            String string;
            boolean bl = false;
            if (authorNode instanceof AuthorElement && (string = (authorElement = (AuthorElement)authorNode).getLocalName()) != null && ("p".equals(string) || "li".equals(string) || "dd".equals(string) || "dt".equals(string) || "ul".equals(string) || "ol".equals(string) || "dl".equals(string))) {
                bl = true;
            }
            if (!bl) {
                throw new AuthorOperationException(authorAccess.getAuthorResourceBundle().getMessage("table.convert.exception"));
            }
            return bl;
        }
    };

    @Override
    public void doOperation(AuthorAccess authorAccess, ArgumentsMap argumentsMap) throws AuthorOperationException {
        AuthorDocumentFragment[] authorDocumentFragmentArray = null;
        ArrayList<Map<String, String>> arrayList = null;
        List<CommonsOperationsUtil.SelectedFragmentInfo> list = CommonsOperationsUtil.getSelectedFragmentsForConversions(authorAccess, CONVERSION_ELEMENT_CHECKER);
        if (list != null) {
            authorDocumentFragmentArray = new AuthorDocumentFragment[list.size()];
            arrayList = new ArrayList<Map<String, String>>(list.size());
            for (int i2 = 0; i2 < list.size(); ++i2) {
                CommonsOperationsUtil.SelectedFragmentInfo selectedFragmentInfo = list.get(i2);
                authorDocumentFragmentArray[i2] = selectedFragmentInfo.getSelectedFragment();
                arrayList.add(selectedFragmentInfo.getAttributes());
            }
        }
        Object object = argumentsMap.getArgumentValue("table_info");
        int n2 = authorDocumentFragmentArray != null ? authorDocumentFragmentArray.length : 0;
        TableInfo tableInfo = object != null ? new TableInfo((Map)object, n2) : null;
        this.insertTable(authorDocumentFragmentArray, arrayList, false, authorAccess, null, null, tableInfo);
    }

    public void insertTable(AuthorDocumentFragment[] authorDocumentFragmentArray, List<Map<String, String>> list, boolean bl, AuthorAccess authorAccess, String string, AuthorTableHelper authorTableHelper, TableInfo tableInfo) throws AuthorOperationException {
        Object object;
        if (tableInfo == null) {
            int n2 = -1;
            int n3 = -1;
            if (authorDocumentFragmentArray != null) {
                n2 = authorDocumentFragmentArray.length;
                n3 = 1;
            }
            if (Platform.STANDALONE == (object = authorAccess.getWorkspaceAccess().getPlatform())) {
                tableInfo = SAXHTMLTableCustomizerInvoker.getInstance().customizeTable(authorAccess, n2, n3);
            } else if (Platform.ECLIPSE == object) {
                tableInfo = ECXHTMLTableCustomizerInvoker.getInstance().customizeTable(authorAccess, n2, n3);
            }
        }
        if (tableInfo == null) {
            throw new AuthorOperationStoppedByUserException("Cancelled by user");
        }
        List<Position> list2 = CommonsOperationsUtil.removeCurrentSelection(authorAccess);
        AuthorDocumentController authorDocumentController = authorAccess.getDocumentController();
        object = authorDocumentController.insertXMLFragmentSchemaAware(InsertTableOperation.getTableXMLFragment(tableInfo, NAMESPACE, authorDocumentFragmentArray, list, bl, authorAccess, authorTableHelper).toString(), authorAccess.getEditorAccess().getCaretOffset());
        TableOperationsUtil.placeCaretInFirstCell(authorAccess, tableInfo, authorDocumentController, (SchemaAwareHandlerResult)object);
        CommonsOperationsUtil.removeEmptyElements(authorAccess, list2);
    }

    @Override
    public void insertTable(AuthorDocumentFragment[] authorDocumentFragmentArray, boolean bl, AuthorAccess authorAccess, String string, AuthorTableHelper authorTableHelper, TableInfo tableInfo) throws AuthorOperationException {
        this.insertTable(authorDocumentFragmentArray, null, bl, authorAccess, string, authorTableHelper, tableInfo);
    }

    private static void addTableBody(StringBuilder stringBuilder, TableInfo tableInfo, AuthorDocumentFragment[] authorDocumentFragmentArray, List<Map<String, String>> list, boolean bl, AuthorAccess authorAccess, AuthorTableHelper authorTableHelper, String string) throws AuthorOperationException {
        stringBuilder.append("<tbody>");
        for (int i2 = 0; i2 < tableInfo.getRowsNumber(); ++i2) {
            Object object;
            Map<String, String> map;
            stringBuilder.append("<tr");
            if (list != null && i2 < list.size() && (map = list.get(i2)) != null) {
                object = map.keySet();
                Iterator<String> iterator = object.iterator();
                while (iterator.hasNext()) {
                    String string2 = iterator.next();
                    stringBuilder.append(" ").append(string2).append("=").append("\"").append(map.get(string2)).append("\"");
                }
            }
            stringBuilder.append(">");
            for (int i3 = 0; i3 < tableInfo.getColumnsNumber(); ++i3) {
                if (i3 == 0 && authorDocumentFragmentArray != null) {
                    object = TableOperationsUtil.createCellXMLFragment(authorAccess, authorDocumentFragmentArray, bl, "td", i2, string, authorTableHelper, new String[0]);
                    stringBuilder.append((String)object);
                    continue;
                }
                stringBuilder.append("<td></td>");
            }
            stringBuilder.append("</tr>");
        }
        stringBuilder.append("</tbody>");
    }

    private static void addTableCols(StringBuilder stringBuilder, TableInfo tableInfo) {
        stringBuilder.append("<colgroup>");
        for (int i2 = 1; i2 <= tableInfo.getColumnsNumber(); ++i2) {
            stringBuilder.append("<col />");
        }
        stringBuilder.append("</colgroup>");
    }

    private static void addTableFooter(StringBuilder stringBuilder, TableInfo tableInfo) throws AuthorOperationException {
        if (tableInfo.isGenerateFooter()) {
            stringBuilder.append("<tfoot><tr>");
            for (int i2 = 1; i2 <= tableInfo.getColumnsNumber(); ++i2) {
                stringBuilder.append("<td></td>");
            }
            stringBuilder.append("</tr></tfoot>");
        }
    }

    private static void addTableHeader(StringBuilder stringBuilder, TableInfo tableInfo) throws AuthorOperationException {
        if (tableInfo.isGenerateHeader()) {
            stringBuilder.append("<thead><tr>");
            for (int i2 = 1; i2 <= tableInfo.getColumnsNumber(); ++i2) {
                stringBuilder.append("<th></th>");
            }
            stringBuilder.append("</tr></thead>");
        }
    }

    @Override
    public ArgumentDescriptor[] getArguments() {
        return null;
    }

    @Override
    public String getDescription() {
        return "Insert a XHTML table";
    }

    private static StringBuilder getTableXMLFragment(TableInfo tableInfo, String string, AuthorDocumentFragment[] authorDocumentFragmentArray, List<Map<String, String>> list, boolean bl, AuthorAccess authorAccess, AuthorTableHelper authorTableHelper) throws AuthorOperationException {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("<table");
        stringBuilder.append(" xmlns=\"").append(string).append("\"");
        if (tableInfo.getFrame() != null) {
            stringBuilder.append(" frame=\"").append(tableInfo.getFrame()).append("\"");
        }
        if (tableInfo.getAlign() != null) {
            stringBuilder.append(" align=\"").append(tableInfo.getAlign()).append("\"");
        }
        stringBuilder.append(">");
        if (tableInfo.getTitle() != null) {
            stringBuilder.append("<caption>").append(authorAccess.getXMLUtilAccess().escapeTextValue(tableInfo.getTitle())).append("</caption>");
        }
        InsertTableOperation.addTableCols(stringBuilder, tableInfo);
        InsertTableOperation.addTableHeader(stringBuilder, tableInfo);
        InsertTableOperation.addTableBody(stringBuilder, tableInfo, authorDocumentFragmentArray, list, bl, authorAccess, authorTableHelper, string);
        InsertTableOperation.addTableFooter(stringBuilder, tableInfo);
        stringBuilder.append("</table>");
        return stringBuilder;
    }
}

