/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.ecss.extensions.commons.table.operations.cals;

import java.util.List;
import ro.sync.annotations.api.API;
import ro.sync.annotations.api.APIType;
import ro.sync.annotations.api.SourceType;
import ro.sync.ecss.extensions.api.AuthorAccess;
import ro.sync.ecss.extensions.api.AuthorDocumentController;
import ro.sync.ecss.extensions.api.AuthorOperationException;
import ro.sync.ecss.extensions.api.AuthorTableCellSpanProvider;
import ro.sync.ecss.extensions.api.node.AttrValue;
import ro.sync.ecss.extensions.api.node.AuthorDocumentFragment;
import ro.sync.ecss.extensions.api.node.AuthorElement;
import ro.sync.ecss.extensions.api.node.AuthorNode;
import ro.sync.ecss.extensions.api.node.AuthorParentNode;
import ro.sync.ecss.extensions.commons.AbstractDocumentTypeHelper;
import ro.sync.ecss.extensions.commons.table.operations.cals.CALSConstants;
import ro.sync.ecss.extensions.commons.table.support.CALSColSpanSpec;
import ro.sync.ecss.extensions.commons.table.support.CALSColSpec;
import ro.sync.ecss.extensions.commons.table.support.CALSTableCellInfoProvider;

@API(type=APIType.INTERNAL, src=SourceType.PUBLIC)
public class CALSDocumentTypeHelper
extends AbstractDocumentTypeHelper
implements CALSConstants {
    private static final String[] ROW_ELEMENT_NAMES = new String[]{"row"};
    private static final String[] CELL_ELEMENT_NAMES = new String[]{"entry"};
    private static final String[] TABLE_ELEMENT_NAMES = new String[]{"tgroup", "informaltable"};

    @Override
    public String[] getTableCellElementNames() {
        return CELL_ELEMENT_NAMES;
    }

    @Override
    public String[] getTableRowElementNames() {
        return ROW_ELEMENT_NAMES;
    }

    @Override
    public String[] getTableElementLocalName() {
        return TABLE_ELEMENT_NAMES;
    }

    @Override
    public void checkTableColSpanIsDefined(AuthorAccess authorAccess, AuthorTableCellSpanProvider authorTableCellSpanProvider, AuthorElement authorElement) throws AuthorOperationException {
        CALSColSpanSpec cALSColSpanSpec = ((CALSTableCellInfoProvider)authorTableCellSpanProvider).getCellSpanSpec(authorAccess, authorElement);
        if (cALSColSpanSpec == null) {
            AuthorOperationException authorOperationException = new AuthorOperationException("Cannot compute the horizontal span specifications for the involved cells because there are missing 'colspec' elements.");
            authorOperationException.setOperationRejectedOnPurpose(true);
            throw authorOperationException;
        }
    }

    private static CALSColSpec getTableColSpec(AuthorTableCellSpanProvider authorTableCellSpanProvider, int n2) throws AuthorOperationException {
        CALSColSpec cALSColSpec = ((CALSTableCellInfoProvider)authorTableCellSpanProvider).getColSpec(n2);
        if (cALSColSpec == null) {
            throw new AuthorOperationException("There is no column specification for column with index: " + n2);
        }
        return cALSColSpec;
    }

    @Override
    public void updateTableColSpan(AuthorAccess authorAccess, AuthorTableCellSpanProvider authorTableCellSpanProvider, AuthorElement authorElement, int n2, int n3) throws AuthorOperationException {
        CALSColSpec cALSColSpec = CALSDocumentTypeHelper.getTableColSpec(authorTableCellSpanProvider, n2);
        CALSColSpec cALSColSpec2 = CALSDocumentTypeHelper.getTableColSpec(authorTableCellSpanProvider, n3);
        AuthorDocumentController authorDocumentController = authorAccess.getDocumentController();
        if (cALSColSpec.getColumnNumber() == cALSColSpec2.getColumnNumber()) {
            authorDocumentController.removeAttribute("namest", authorElement);
            authorDocumentController.removeAttribute("nameend", authorElement);
        } else {
            authorDocumentController.setAttribute("namest", new AttrValue(cALSColSpec.getColumnName()), authorElement);
            authorDocumentController.setAttribute("nameend", new AttrValue(cALSColSpec2.getColumnName()), authorElement);
        }
        authorAccess.getDocumentController().removeAttribute("spanname", authorElement);
        authorAccess.getDocumentController().removeAttribute("colname", authorElement);
    }

    @Override
    public AuthorTableCellSpanProvider getTableCellSpanProvider(AuthorElement authorElement) {
        CALSTableCellInfoProvider cALSTableCellInfoProvider = new CALSTableCellInfoProvider();
        cALSTableCellInfoProvider.init(authorElement);
        return cALSTableCellInfoProvider;
    }

    @Override
    public void updateTableRowSpan(AuthorAccess authorAccess, AuthorElement authorElement, int n2) {
        if (n2 > 1) {
            authorAccess.getDocumentController().setAttribute("morerows", new AttrValue(String.valueOf(n2 - 1)), authorElement);
        } else {
            authorAccess.getDocumentController().removeAttribute("morerows", authorElement);
        }
    }

    @Override
    public void updateTableColumnNumber(AuthorAccess authorAccess, AuthorElement authorElement, int n2) {
        authorAccess.getDocumentController().setAttribute("cols", new AttrValue(String.valueOf(n2)), authorElement);
    }

    @Override
    public void updateTableRowNumber(AuthorAccess authorAccess, AuthorElement authorElement, int n2) {
    }

    @Override
    public String[] getIgnoredRowAttributes() {
        return new String[]{"morerows"};
    }

    @Override
    public String[] getIgnoredCellIDAttributes() {
        return new String[]{"xml:id", "id"};
    }

    @Override
    public String[] getAllowedCellAttributesToCopy() {
        return new String[]{"namest", "nameend", "rowsep", "colsep", "colname", "spanname", "align", "valign", "charoff", "rotate"};
    }

    @Override
    public String[] getIgnoredColumnAttributes() {
        return new String[]{"namest", "nameend"};
    }

    @Override
    public AuthorNode getTableElementForDeletion(AuthorNode authorNode) {
        AuthorNode authorNode2 = null;
        if (this.isActuallyTableAndNotTgroup(authorNode)) {
            authorNode2 = authorNode;
        } else {
            while (authorNode.getParent() != null) {
                if (!this.isActuallyTableAndNotTgroup(authorNode.getParent())) continue;
                authorNode2 = authorNode.getParent();
                break;
            }
        }
        return authorNode2;
    }

    protected boolean isActuallyTableAndNotTgroup(AuthorNode authorNode) {
        AuthorElement authorElement;
        return authorNode instanceof AuthorElement && ("table".equals((authorElement = (AuthorElement)authorNode).getLocalName()) || "informaltable".equals(authorElement.getLocalName()));
    }

    public void limitRowSpan(AuthorDocumentFragment[] authorDocumentFragmentArray) {
        int n2 = authorDocumentFragmentArray.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            AuthorDocumentFragment authorDocumentFragment = authorDocumentFragmentArray[i2];
            int n3 = n2 - (i2 + 1);
            this.limitRowSpanInRowDocumentFragment(authorDocumentFragment, n3);
        }
    }

    private AuthorDocumentFragment limitRowSpanInRowDocumentFragment(AuthorDocumentFragment authorDocumentFragment, int n2) {
        AuthorNode authorNode;
        List<AuthorNode> list = authorDocumentFragment.getContentNodes();
        if (list != null && !list.isEmpty() && this.isTableRow(authorNode = list.get(0))) {
            CALSDocumentTypeHelper.limitRowSpanInRowCells((AuthorParentNode)authorNode, n2);
        }
        return authorDocumentFragment;
    }

    private static void limitRowSpanInRowCells(AuthorParentNode authorParentNode, int n2) {
        List<AuthorNode> list = authorParentNode.getContentNodes();
        CALSTableCellInfoProvider cALSTableCellInfoProvider = new CALSTableCellInfoProvider();
        for (AuthorNode authorNode : list) {
            AuthorElement authorElement;
            Integer n3;
            if (!(authorNode instanceof AuthorElement) || (n3 = cALSTableCellInfoProvider.getRowSpan(authorElement = (AuthorElement)authorNode)) == null || n3 <= n2) continue;
            if (n2 > 0) {
                authorElement.setAttribute("morerows", new AttrValue(String.valueOf(n2)));
                continue;
            }
            authorElement.removeAttribute("morerows");
        }
    }
}

