/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.ecss.extensions.commons.table.operations;

import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import javax.swing.SpinnerModel;
import javax.swing.SpinnerNumberModel;
import ro.sync.annotations.api.API;
import ro.sync.annotations.api.APIType;
import ro.sync.annotations.api.SourceType;
import ro.sync.ecss.extensions.api.AuthorResourceBundle;
import ro.sync.ecss.extensions.commons.table.operations.TableCustomizerConstants;
import ro.sync.ecss.extensions.commons.table.operations.TableInfo;
import ro.sync.ecss.extensions.commons.ui.OKCancelDialog;

@API(type=APIType.INTERNAL, src=SourceType.PUBLIC)
public abstract class SATableCustomizerDialog
extends OKCancelDialog
implements TableCustomizerConstants {
    private static final int DEFAULT_NO_OF_COLS_FOR_PROPERTIES_TABLE = 3;
    protected JCheckBox titleCheckbox;
    protected JTextField titleTextField;
    protected JSpinner rowsSpinner;
    protected JSpinner columnsSpinner;
    protected JComboBox colWidthsCombobox;
    protected JCheckBox headerCheckbox;
    protected JCheckBox footerCheckbox;
    protected JComboBox frameCombo;
    protected JComboBox rowsepCombo;
    protected JComboBox colsepCombo;
    protected JComboBox alignCombo;
    private final boolean hasFooter;
    private final boolean hasFrameAttribute;
    private final boolean hasRowsepAttribute;
    private final boolean hasColsepAttribute;
    private final boolean hasAlignAttribute;
    private boolean showModelChooser;
    protected JRadioButton calsModelRadio;
    protected JRadioButton simpleOrHtmlModelRadio;
    protected JRadioButton propertiesModelRadio;
    protected final AuthorResourceBundle authorResourceBundle;
    private final int predefinedColumnsCount;
    private final int predefinedRowsCount;
    private final boolean choiceTableModel;
    private boolean isCalsTable;
    private final boolean isSimpleTableNotHtml;
    private boolean isPropertiesTable;
    private final SpinnerModel propertiesTableColSpinnerModel = new SpinnerNumberModel(3, 2, 3, 1);
    private final SpinnerModel defaultColSpinnerModel = new SpinnerNumberModel(2, 1, 100, 1);
    private boolean isSimpleOrHtmlTable;

    public SATableCustomizerDialog(Frame frame, boolean bl, boolean bl2, boolean bl3, AuthorResourceBundle authorResourceBundle, int n2, int n3) {
        this(frame, bl, bl2, bl3, false, false, false, false, false, authorResourceBundle, n2, n3);
    }

    public SATableCustomizerDialog(Frame frame, boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5, boolean bl6, boolean bl7, boolean bl8, AuthorResourceBundle authorResourceBundle, int n2, int n3) {
        this(frame, bl, bl2, bl3, bl4, false, bl5, bl6, bl7, bl8, authorResourceBundle, n2, n3);
    }

    public SATableCustomizerDialog(Frame frame, boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5, boolean bl6, boolean bl7, boolean bl8, boolean bl9, AuthorResourceBundle authorResourceBundle, int n2, int n3) {
        this(frame, bl, bl2, bl3, bl4, bl5, true, bl6, bl7, bl8, bl9, authorResourceBundle, n2, n3);
    }

    public SATableCustomizerDialog(Frame frame, boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5, boolean bl6, boolean bl7, boolean bl8, boolean bl9, boolean bl10, AuthorResourceBundle authorResourceBundle, int n2, int n3) {
        this(frame, bl, bl2, bl3, bl4, bl5, bl6, false, false, false, bl7, bl8, bl9, bl10, authorResourceBundle, n2, n3);
    }

    public SATableCustomizerDialog(Frame frame, boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5, boolean bl6, boolean bl7, boolean bl8, boolean bl9, boolean bl10, boolean bl11, boolean bl12, boolean bl13, AuthorResourceBundle authorResourceBundle, int n2, int n3) {
        super(frame, authorResourceBundle.getMessage(bl5 ? "Insert_choice_table" : "Insert_table"), true);
        JLabel jLabel;
        TableCustomizerConstants.ColumnWidthsType[] columnWidthsTypeArray;
        int n4;
        this.hasFooter = bl;
        this.hasFrameAttribute = bl2;
        this.showModelChooser = bl3;
        this.isSimpleTableNotHtml = bl4;
        this.choiceTableModel = bl5;
        this.isCalsTable = bl6;
        this.isSimpleOrHtmlTable = bl7;
        this.isPropertiesTable = bl9;
        this.hasRowsepAttribute = bl11;
        this.hasColsepAttribute = bl12;
        this.hasAlignAttribute = bl13;
        this.authorResourceBundle = authorResourceBundle;
        this.predefinedRowsCount = n2;
        this.predefinedColumnsCount = n3;
        this.setOkButtonText(authorResourceBundle.getMessage("Insert"));
        JPanel jPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        JPanel jPanel2 = new JPanel(new FlowLayout(0, 3, 2));
        jPanel2.setBorder(BorderFactory.createTitledBorder(authorResourceBundle.getMessage("Model")));
        ButtonGroup buttonGroup = new ButtonGroup();
        this.calsModelRadio = new JRadioButton("CALS");
        this.calsModelRadio.setName("CALS model");
        this.calsModelRadio.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                if (itemEvent.getStateChange() == 1) {
                    SATableCustomizerDialog.this.addValuesToFrameCombo(1);
                    SATableCustomizerDialog.this.updateColumnsWidthsCombo(SATableCustomizerDialog.this.getColumnWidthsSpecifications(1));
                    SATableCustomizerDialog.this.colWidthsCombobox.setEnabled(true);
                    SATableCustomizerDialog.this.updateTitleState(true);
                    SATableCustomizerDialog.this.updateElementsState(true);
                    SATableCustomizerDialog.this.updateAlignState(true);
                }
            }
        });
        jPanel2.add(this.calsModelRadio);
        buttonGroup.add(this.calsModelRadio);
        if (!bl5) {
            if (bl4) {
                this.simpleOrHtmlModelRadio = new JRadioButton(authorResourceBundle.getMessage("Simple"));
                this.simpleOrHtmlModelRadio.setName("Simple table model");
                this.simpleOrHtmlModelRadio.addItemListener(new ItemListener(){

                    @Override
                    public void itemStateChanged(ItemEvent itemEvent) {
                        if (itemEvent.getStateChange() == 1) {
                            SATableCustomizerDialog.this.updateColumnsWidthsCombo(SATableCustomizerDialog.this.getColumnWidthsSpecifications(3));
                            SATableCustomizerDialog.this.addValuesToFrameCombo(3);
                            SATableCustomizerDialog.this.colWidthsCombobox.setEnabled(true);
                            SATableCustomizerDialog.this.updateTitleState(false);
                            SATableCustomizerDialog.this.updateElementsState(false);
                            SATableCustomizerDialog.this.updateAlignState(false);
                        }
                    }
                });
                jPanel2.add(this.simpleOrHtmlModelRadio);
                buttonGroup.add(this.simpleOrHtmlModelRadio);
            } else {
                this.simpleOrHtmlModelRadio = new JRadioButton("HTML");
                this.simpleOrHtmlModelRadio.setName("HTML model");
                this.simpleOrHtmlModelRadio.addItemListener(new ItemListener(){

                    @Override
                    public void itemStateChanged(ItemEvent itemEvent) {
                        if (itemEvent.getStateChange() == 1) {
                            SATableCustomizerDialog.this.updateColumnsWidthsCombo(SATableCustomizerDialog.this.getColumnWidthsSpecifications(0));
                            SATableCustomizerDialog.this.addValuesToFrameCombo(0);
                            SATableCustomizerDialog.this.updateElementsState(false);
                            SATableCustomizerDialog.this.updateAlignState(true);
                        }
                    }
                });
                jPanel2.add(this.simpleOrHtmlModelRadio);
                buttonGroup.add(this.simpleOrHtmlModelRadio);
            }
            if (bl8) {
                this.propertiesModelRadio = new JRadioButton(authorResourceBundle.getMessage("Properties"));
                this.propertiesModelRadio.setName("Properties");
                this.propertiesModelRadio.addItemListener(new ItemListener(){

                    @Override
                    public void itemStateChanged(ItemEvent itemEvent) {
                        if (itemEvent.getStateChange() == 1) {
                            SATableCustomizerDialog.this.addValuesToFrameCombo(3);
                            SATableCustomizerDialog.this.colWidthsCombobox.setEnabled(false);
                            SATableCustomizerDialog.this.updateTitleState(false);
                            SATableCustomizerDialog.this.updateElementsState(false);
                            SATableCustomizerDialog.this.updateAlignState(false);
                            Integer n2 = (Integer)SATableCustomizerDialog.this.columnsSpinner.getValue();
                            SATableCustomizerDialog.this.columnsSpinner.setModel(SATableCustomizerDialog.this.propertiesTableColSpinnerModel);
                            if (n2 < 2 || n2 > 3) {
                                n2 = 3;
                            }
                            SATableCustomizerDialog.this.columnsSpinner.setValue(n2);
                        } else if (itemEvent.getStateChange() == 2) {
                            Object object = SATableCustomizerDialog.this.columnsSpinner.getValue();
                            SATableCustomizerDialog.this.columnsSpinner.setModel(SATableCustomizerDialog.this.defaultColSpinnerModel);
                            SATableCustomizerDialog.this.columnsSpinner.setValue(object);
                        }
                    }
                });
                jPanel2.add(this.propertiesModelRadio);
                buttonGroup.add(this.propertiesModelRadio);
            }
        } else {
            this.showModelChooser = false;
            jPanel2.setVisible(false);
        }
        int n5 = n4 = bl10 ? 1 : 2;
        if (bl3) {
            jPanel.add((Component)jPanel2, gridBagConstraints);
            n4 = 1;
        }
        if (!bl10 && !bl5) {
            this.titleCheckbox = this.createTitleCheckbox();
            this.titleCheckbox.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent itemEvent) {
                    SATableCustomizerDialog.this.titleTextField.setEditable(SATableCustomizerDialog.this.titleCheckbox.isSelected());
                }
            });
            this.titleCheckbox.setBorder(BorderFactory.createEmptyBorder());
            this.titleCheckbox.getAccessibleContext().setAccessibleName("Create a title element for the table");
            ++gridBagConstraints.gridy;
            gridBagConstraints.gridx = 0;
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.insets = new Insets(7, 0, 0, 0);
            gridBagConstraints.fill = 0;
            jPanel.add((Component)this.titleCheckbox, gridBagConstraints);
            this.titleTextField = new JTextField();
            this.titleTextField.setName("Title text field");
            this.titleTextField.getAccessibleContext().setAccessibleName("Table Title");
            ++gridBagConstraints.gridx;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.fill = 2;
            gridBagConstraints.insets = new Insets(7, 5, 0, 0);
            jPanel.add((Component)this.titleTextField, gridBagConstraints);
        }
        JPanel jPanel3 = new JPanel(new GridLayout(1, 2));
        jPanel3.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(authorResourceBundle.getMessage("Table_size")), BorderFactory.createEmptyBorder(3, 3, 3, 3)));
        ++gridBagConstraints.gridy;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.insets = new Insets(7, 0, 0, 0);
        jPanel.add((Component)jPanel3, gridBagConstraints);
        JPanel jPanel4 = new JPanel(new GridBagLayout());
        jPanel3.add(jPanel4);
        JLabel jLabel2 = new JLabel(authorResourceBundle.getMessage("Rows") + ":");
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.gridx = 0;
        gridBagConstraints2.gridy = 0;
        gridBagConstraints2.gridwidth = 1;
        gridBagConstraints2.gridheight = 1;
        gridBagConstraints2.weightx = 0.0;
        gridBagConstraints2.weighty = 0.0;
        gridBagConstraints2.anchor = 17;
        gridBagConstraints2.fill = 0;
        gridBagConstraints2.insets = new Insets(0, 0, 0, 0);
        jPanel4.add((Component)jLabel2, gridBagConstraints2);
        this.rowsSpinner = new JSpinner();
        jLabel2.setLabelFor(this.rowsSpinner);
        this.rowsSpinner.setName("Rows spinner");
        this.rowsSpinner.setModel(new SpinnerNumberModel(2, 1, 1000, 1));
        if (n3 >= 0) {
            this.rowsSpinner.setValue(n2);
        } else {
            this.rowsSpinner.setValue(3);
        }
        ++gridBagConstraints2.gridx;
        gridBagConstraints2.weightx = 1.0;
        gridBagConstraints2.fill = 2;
        gridBagConstraints2.insets.left = 5;
        gridBagConstraints2.insets.right = 8;
        jPanel4.add((Component)this.rowsSpinner, gridBagConstraints2);
        JPanel jPanel5 = new JPanel(new GridBagLayout());
        jPanel3.add(jPanel5);
        JLabel jLabel3 = new JLabel(authorResourceBundle.getMessage("Columns") + ":");
        gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.gridx = 0;
        gridBagConstraints2.gridy = 0;
        gridBagConstraints2.gridwidth = 1;
        gridBagConstraints2.gridheight = 1;
        gridBagConstraints2.weightx = 0.0;
        gridBagConstraints2.weighty = 0.0;
        gridBagConstraints2.fill = 0;
        gridBagConstraints2.insets = new Insets(0, 8, 0, 0);
        jPanel5.add((Component)jLabel3, gridBagConstraints2);
        this.columnsSpinner = new JSpinner();
        jLabel3.setLabelFor(this.columnsSpinner);
        this.columnsSpinner.setName("Columns spinner");
        this.columnsSpinner.setModel(this.defaultColSpinnerModel);
        if (n3 >= 0) {
            this.columnsSpinner.setValue(n3);
        } else {
            this.columnsSpinner.setValue(2);
        }
        ++gridBagConstraints2.gridx;
        gridBagConstraints2.weightx = 1.0;
        gridBagConstraints2.fill = 2;
        gridBagConstraints2.insets.left = 5;
        jPanel5.add((Component)this.columnsSpinner, gridBagConstraints2);
        if (bl5) {
            this.columnsSpinner.setEnabled(false);
            this.columnsSpinner.setValue(2);
        }
        JPanel jPanel6 = new JPanel(new FlowLayout(0, 0, 0));
        gridBagConstraints.gridx = 0;
        ++gridBagConstraints.gridy;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(7, 0, 0, 0);
        jPanel.add((Component)jPanel6, gridBagConstraints);
        this.headerCheckbox = new JCheckBox(authorResourceBundle.getMessage("Generate_table_header"));
        this.headerCheckbox.setName("Header checkbox");
        this.headerCheckbox.setBorder(BorderFactory.createEmptyBorder());
        jPanel6.add(this.headerCheckbox);
        if (bl) {
            jPanel6.add(Box.createHorizontalStrut(16));
            this.footerCheckbox = new JCheckBox(authorResourceBundle.getMessage("Generate_table_footer"));
            this.footerCheckbox.setName("Footer checkbox");
            this.footerCheckbox.setBorder(BorderFactory.createEmptyBorder());
            jPanel6.add(this.footerCheckbox);
        }
        if ((columnWidthsTypeArray = this.getColumnWidthsSpecifications(n4)) != null) {
            jLabel = new JLabel(authorResourceBundle.getMessage("Column_widths") + ":");
            gridBagConstraints.gridx = 0;
            ++gridBagConstraints.gridy;
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.fill = 0;
            gridBagConstraints.insets = new Insets(7, 0, 0, 0);
            jPanel.add((Component)jLabel, gridBagConstraints);
            this.colWidthsCombobox = new JComboBox();
            jLabel.setLabelFor(this.colWidthsCombobox);
            this.colWidthsCombobox.setName("Column Widths combo");
            final ListCellRenderer listCellRenderer = this.colWidthsCombobox.getRenderer();
            this.colWidthsCombobox.setRenderer(new ListCellRenderer(){

                public Component getListCellRendererComponent(JList jList, Object object, int n2, boolean bl, boolean bl2) {
                    String string = null;
                    if (TableCustomizerConstants.ColumnWidthsType.DYNAMIC_COL_WIDTHS == object) {
                        string = "dynamic";
                    } else if (TableCustomizerConstants.ColumnWidthsType.PROPORTIONAL_COL_WIDTHS == object) {
                        string = "proportional";
                    }
                    if (TableCustomizerConstants.ColumnWidthsType.FIXED_COL_WIDTHS == object) {
                        string = "fixed";
                    }
                    return listCellRenderer.getListCellRendererComponent(jList, string, n2, bl, bl2);
                }
            });
            this.updateColumnsWidthsCombo(columnWidthsTypeArray);
            ++gridBagConstraints.gridx;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.insets = new Insets(7, 5, 0, 0);
            gridBagConstraints.fill = 2;
            jPanel.add((Component)this.colWidthsCombobox, gridBagConstraints);
        }
        if (bl2) {
            jLabel = new JLabel(authorResourceBundle.getMessage("Frame") + ":");
            gridBagConstraints.gridx = 0;
            ++gridBagConstraints.gridy;
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.insets = new Insets(7, 0, 0, 0);
            gridBagConstraints.fill = 0;
            jPanel.add((Component)jLabel, gridBagConstraints);
            this.frameCombo = new JComboBox();
            jLabel.setLabelFor(this.frameCombo);
            this.frameCombo.setName("Frame combo");
            this.addValuesToFrameCombo(n4);
            ++gridBagConstraints.gridx;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.insets.left = 5;
            gridBagConstraints.fill = 2;
            jPanel.add((Component)this.frameCombo, gridBagConstraints);
        }
        if (bl11) {
            jLabel = new JLabel(authorResourceBundle.getMessage("Row_separator") + ":");
            gridBagConstraints.gridx = 0;
            ++gridBagConstraints.gridy;
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.insets = new Insets(7, 0, 0, 0);
            gridBagConstraints.fill = 0;
            jPanel.add((Component)jLabel, gridBagConstraints);
            this.rowsepCombo = new JComboBox();
            jLabel.setLabelFor(this.rowsepCombo);
            this.rowsepCombo.setName("Rowsep combo");
            this.addValuesToRowsepCombo(n4);
            ++gridBagConstraints.gridx;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.insets.left = 5;
            gridBagConstraints.fill = 2;
            jPanel.add((Component)this.rowsepCombo, gridBagConstraints);
        }
        if (bl12) {
            jLabel = new JLabel(authorResourceBundle.getMessage("Column_separator") + ":");
            gridBagConstraints.gridx = 0;
            ++gridBagConstraints.gridy;
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.insets = new Insets(7, 0, 0, 0);
            gridBagConstraints.fill = 0;
            jPanel.add((Component)jLabel, gridBagConstraints);
            this.colsepCombo = new JComboBox();
            jLabel.setLabelFor(this.colsepCombo);
            this.colsepCombo.setName("Colsep combo");
            this.addValuesToColsepCombo(n4);
            ++gridBagConstraints.gridx;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.insets.left = 5;
            gridBagConstraints.fill = 2;
            jPanel.add((Component)this.colsepCombo, gridBagConstraints);
        }
        if (bl13) {
            jLabel = new JLabel(authorResourceBundle.getMessage("Alignment") + ":");
            gridBagConstraints.gridx = 0;
            ++gridBagConstraints.gridy;
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.insets = new Insets(7, 0, 0, 0);
            gridBagConstraints.fill = 0;
            jPanel.add((Component)jLabel, gridBagConstraints);
            this.alignCombo = new JComboBox();
            jLabel.setLabelFor(this.alignCombo);
            this.alignCombo.setName("Align combo");
            this.addValuesToAlignCombo(n4);
            ++gridBagConstraints.gridx;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.insets.left = 5;
            gridBagConstraints.fill = 2;
            jPanel.add((Component)this.alignCombo, gridBagConstraints);
        }
        jPanel.setBorder(BorderFactory.createEmptyBorder(0, 0, 5, 0));
        this.getContentPane().add((Component)jPanel, "Center");
        this.pack();
        this.setSize(340, this.getSize().height);
        this.setResizable(false);
    }

    protected void updateColumnsWidthsCombo(TableCustomizerConstants.ColumnWidthsType[] columnWidthsTypeArray) {
        if (this.colWidthsCombobox != null) {
            Object object = this.colWidthsCombobox.getSelectedItem();
            this.colWidthsCombobox.removeAllItems();
            int n2 = -1;
            for (int i2 = 0; i2 < columnWidthsTypeArray.length; ++i2) {
                this.colWidthsCombobox.addItem(columnWidthsTypeArray[i2]);
                if (!columnWidthsTypeArray[i2].equals(object)) continue;
                n2 = i2;
            }
            if (n2 != -1) {
                this.colWidthsCombobox.setSelectedIndex(n2);
            }
        }
    }

    private void updateTitleState(boolean bl) {
        if (this.titleCheckbox != null) {
            this.titleCheckbox.setEnabled(bl);
            this.titleCheckbox.setSelected(bl);
            this.titleTextField.setEditable(bl && this.titleCheckbox.isSelected());
        }
    }

    private void updateElementsState(boolean bl) {
        if (this.rowsepCombo != null) {
            this.rowsepCombo.setEnabled(bl);
        }
        if (this.colsepCombo != null) {
            this.colsepCombo.setEnabled(bl);
        }
    }

    private void updateAlignState(boolean bl) {
        if (this.alignCombo != null) {
            this.alignCombo.setEnabled(bl);
        }
    }

    protected abstract String[] getFrameValues(int var1);

    protected abstract String getDefaultFrameValue(int var1);

    protected abstract String[] getRowsepValues(int var1);

    protected abstract String getDefaultRowsepValue(int var1);

    protected abstract String[] getColsepValues(int var1);

    protected abstract String[] getAlignValues(int var1);

    protected abstract String getDefaultColsepValue(int var1);

    protected abstract String getDefaultAlignValue(int var1);

    protected abstract TableCustomizerConstants.ColumnWidthsType[] getColumnWidthsSpecifications(int var1);

    protected abstract JCheckBox createTitleCheckbox();

    private void addValuesToFrameCombo(int n2) {
        Object object = this.frameCombo.getSelectedItem();
        String[] stringArray = this.getFrameValues(n2);
        this.frameCombo.removeAllItems();
        int n3 = -1;
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            this.frameCombo.addItem(stringArray[i2]);
            if (stringArray[i2] == null || !stringArray[i2].equals(object)) continue;
            n3 = i2;
        }
        if (n3 != -1) {
            this.frameCombo.setSelectedIndex(n3);
        } else {
            this.frameCombo.setSelectedItem(this.getDefaultFrameValue(n2));
        }
    }

    private void addValuesToRowsepCombo(int n2) {
        String[] stringArray = this.getRowsepValues(n2);
        this.rowsepCombo.removeAllItems();
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            this.rowsepCombo.addItem(stringArray[i2]);
        }
        this.rowsepCombo.setSelectedItem(this.getDefaultRowsepValue(n2));
    }

    private void addValuesToColsepCombo(int n2) {
        String[] stringArray = this.getColsepValues(n2);
        this.colsepCombo.removeAllItems();
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            this.colsepCombo.addItem(stringArray[i2]);
        }
        this.colsepCombo.setSelectedItem(this.getDefaultColsepValue(n2));
    }

    private void addValuesToAlignCombo(int n2) {
        String[] stringArray = this.getAlignValues(n2);
        this.alignCombo.removeAllItems();
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            this.alignCombo.addItem(stringArray[i2]);
        }
        this.alignCombo.setSelectedItem(this.getDefaultAlignValue(n2));
    }

    public TableInfo showDialog(TableInfo tableInfo) {
        this.initialize(tableInfo);
        super.setVisible(true);
        TableInfo tableInfo2 = null;
        if (this.getResult() == 1) {
            String string = null;
            if (this.titleCheckbox != null && this.titleCheckbox.isSelected()) {
                string = this.titleTextField.getText();
            }
            int n2 = (Integer)this.rowsSpinner.getValue();
            int n3 = (Integer)this.columnsSpinner.getValue();
            int n4 = this.getTableModelType();
            tableInfo2 = new TableInfo(string, n2, n3, this.headerCheckbox.isSelected(), this.hasFooter ? this.footerCheckbox.isSelected() : false, this.hasFrameAttribute ? (!"<unspecified>".equals(this.frameCombo.getSelectedItem()) ? (String)this.frameCombo.getSelectedItem() : null) : null, n4, this.colWidthsCombobox != null ? (TableCustomizerConstants.ColumnWidthsType)((Object)this.colWidthsCombobox.getSelectedItem()) : null, this.hasRowsepAttribute ? (!"<unspecified>".equals(this.rowsepCombo.getSelectedItem()) ? (String)this.rowsepCombo.getSelectedItem() : null) : null, this.hasColsepAttribute ? (!"<unspecified>".equals(this.colsepCombo.getSelectedItem()) ? (String)this.colsepCombo.getSelectedItem() : null) : null, this.hasAlignAttribute ? (!"<unspecified>".equals(this.alignCombo.getSelectedItem()) ? (String)this.alignCombo.getSelectedItem() : null) : null);
        }
        return tableInfo2;
    }

    protected int getTableModelType() {
        int n2 = 2;
        if (this.showModelChooser) {
            n2 = this.calsModelRadio.isSelected() ? 1 : (this.propertiesModelRadio != null && this.propertiesModelRadio.isSelected() ? 5 : (this.isSimpleTableNotHtml ? 3 : 0));
        } else if (this.choiceTableModel) {
            n2 = 4;
        }
        return n2;
    }

    private void initialize(TableInfo tableInfo) {
        if (this.titleCheckbox != null) {
            this.titleTextField.setEditable(true);
            this.titleTextField.setText("");
        }
        if (this.choiceTableModel) {
            this.updateColumnsWidthsCombo(this.getColumnWidthsSpecifications(4));
            this.addValuesToFrameCombo(4);
        }
        if (tableInfo != null) {
            if (this.showModelChooser) {
                if (this.isCalsTable || tableInfo.getTableModel() == 1 && !this.isPropertiesTable && !this.isSimpleOrHtmlTable) {
                    this.calsModelRadio.setSelected(true);
                } else if (this.isSimpleOrHtmlTable || tableInfo.getTableModel() != 1 && tableInfo.getTableModel() != 5 && !this.isCalsTable && !this.isPropertiesTable) {
                    this.simpleOrHtmlModelRadio.setSelected(true);
                } else if (this.propertiesModelRadio != null && (this.isPropertiesTable || tableInfo.getTableModel() == 5 && !this.isCalsTable && !this.isSimpleOrHtmlTable)) {
                    this.propertiesModelRadio.setSelected(true);
                } else {
                    this.calsModelRadio.setSelected(true);
                }
            }
            if (this.titleCheckbox != null) {
                if (tableInfo.getTitle() != null) {
                    this.titleCheckbox.setSelected(true);
                } else {
                    this.titleCheckbox.setSelected(false);
                    this.titleTextField.setEditable(false);
                }
            }
            if (this.predefinedColumnsCount < 0 || this.predefinedRowsCount < 0) {
                this.rowsSpinner.setValue(tableInfo.getRowsNumber());
                int n2 = tableInfo.getColumnsNumber();
                if (!this.choiceTableModel) {
                    if (!(this.propertiesModelRadio == null || !this.isPropertiesTable && (tableInfo.getTableModel() != 5 || this.isCalsTable || this.isSimpleOrHtmlTable) || n2 >= 2 && n2 <= 3)) {
                        n2 = 3;
                    }
                    this.columnsSpinner.setValue(n2);
                }
            }
            this.headerCheckbox.setSelected(tableInfo.isGenerateHeader());
            if (this.hasFooter) {
                this.footerCheckbox.setSelected(tableInfo.isGenerateFooter());
            }
            if (this.colWidthsCombobox != null) {
                this.colWidthsCombobox.setSelectedItem((Object)tableInfo.getColumnsWidthsType());
            }
            if (this.frameCombo != null) {
                if (tableInfo.getFrame() != null) {
                    this.frameCombo.setSelectedItem(tableInfo.getFrame());
                } else {
                    this.frameCombo.setSelectedItem("<unspecified>");
                }
            }
            if (this.rowsepCombo != null) {
                if (tableInfo.getRowsep() != null) {
                    this.rowsepCombo.setSelectedItem(tableInfo.getRowsep());
                } else {
                    this.rowsepCombo.setSelectedItem("<unspecified>");
                }
            }
            if (this.colsepCombo != null) {
                if (tableInfo.getColsep() != null) {
                    this.colsepCombo.setSelectedItem(tableInfo.getColsep());
                } else {
                    this.colsepCombo.setSelectedItem("<unspecified>");
                }
            }
            if (this.alignCombo != null) {
                if (tableInfo.getAlign() != null) {
                    this.alignCombo.setSelectedItem(tableInfo.getAlign());
                } else {
                    this.alignCombo.setSelectedItem("<unspecified>");
                }
            }
        } else {
            if (this.titleCheckbox != null) {
                this.titleCheckbox.setSelected(true);
            }
            if (this.showModelChooser) {
                if (this.isCalsTable) {
                    this.calsModelRadio.setSelected(true);
                } else if (this.isSimpleOrHtmlTable) {
                    this.simpleOrHtmlModelRadio.setSelected(true);
                } else if (this.isPropertiesTable) {
                    this.propertiesModelRadio.setSelected(true);
                } else {
                    this.calsModelRadio.setSelected(true);
                }
            }
            if (this.predefinedColumnsCount < 0 || this.predefinedRowsCount < 0) {
                this.rowsSpinner.setValue(3);
                if (this.isPropertiesTable) {
                    this.columnsSpinner.setValue(3);
                } else {
                    this.columnsSpinner.setValue(2);
                }
            }
            this.headerCheckbox.setSelected(true);
            if (this.hasFooter) {
                this.footerCheckbox.setSelected(false);
            }
        }
        if (this.titleCheckbox != null) {
            this.titleTextField.requestFocus();
        }
    }

    public JRadioButton getPropertiesModelRadio() {
        return this.propertiesModelRadio;
    }

    public JSpinner getColumnsSpinner() {
        return this.columnsSpinner;
    }

    public JCheckBox getHeaderCheckbox() {
        return this.headerCheckbox;
    }

    public JComboBox getColWidthsCombobox() {
        return this.colWidthsCombobox;
    }

    public JComboBox getFrameCombo() {
        return this.frameCombo;
    }

    public JComboBox getColsepCombo() {
        return this.colsepCombo;
    }

    public JComboBox getRowsepCombo() {
        return this.rowsepCombo;
    }

    public JComboBox getAlignCombo() {
        return this.alignCombo;
    }

    public JCheckBox getTitleCheckbox() {
        return this.titleCheckbox;
    }

    public JTextField getTitleTextField() {
        return this.titleTextField;
    }

    public JSpinner getRowsSpinner() {
        return this.rowsSpinner;
    }

    public JRadioButton getCalsModelRadio() {
        return this.calsModelRadio;
    }

    public JRadioButton getSimpleOrHtmlModelRadio() {
        return this.simpleOrHtmlModelRadio;
    }

    public JCheckBox getFooterCheckbox() {
        return this.footerCheckbox;
    }
}

