/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.ecss.extensions.commons.table.operations;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.swing.text.BadLocationException;
import ro.sync.annotations.api.API;
import ro.sync.annotations.api.APIType;
import ro.sync.annotations.api.SourceType;
import ro.sync.ecss.extensions.api.ArgumentDescriptor;
import ro.sync.ecss.extensions.api.ArgumentsMap;
import ro.sync.ecss.extensions.api.AuthorAccess;
import ro.sync.ecss.extensions.api.AuthorDocumentController;
import ro.sync.ecss.extensions.api.AuthorOperationException;
import ro.sync.ecss.extensions.api.AuthorOperationStoppedByUserException;
import ro.sync.ecss.extensions.api.AuthorTableCellSpanProvider;
import ro.sync.ecss.extensions.api.node.AttrValue;
import ro.sync.ecss.extensions.api.node.AuthorElement;
import ro.sync.ecss.extensions.api.node.AuthorNode;
import ro.sync.ecss.extensions.commons.AbstractDocumentTypeHelper;
import ro.sync.ecss.extensions.commons.table.operations.AbstractTableOperation;
import ro.sync.ecss.extensions.commons.table.operations.AuthorTableHelper;
import ro.sync.ecss.extensions.commons.table.operations.ECTableRowInsertionCustomizerInvoker;
import ro.sync.ecss.extensions.commons.table.operations.SATableRowInsertionCustomizerInvoker;
import ro.sync.ecss.extensions.commons.table.operations.TableRowsInfo;
import ro.sync.exml.workspace.api.Platform;

@API(type=APIType.INTERNAL, src=SourceType.PUBLIC)
public abstract class InsertRowOperationBase
extends AbstractTableOperation {
    private static final String XPATH_LOCATION_ARGUMENT = "insertLocation";
    private static final String RELATIVE_POSITION_ARGUMENT = "insertPosition";
    private static final String CUSTOM_ROW_INSERTION_ARGUMENT = "customRowInsertion";
    protected static final ArgumentDescriptor CUSTOM_INSERTION_ARGUMENT_DESCRIPTOR = new ArgumentDescriptor("customRowInsertion", 3, "A boolean specifying if the custom row insertion has been requested or not. A custom insertion allows the user to choose the number of rows to be inserted and the position of insertion (above or below the current row).", new String[]{"true", "false"}, "false");
    private ArgumentDescriptor[] arguments = this.getOperationArguments();

    protected ArgumentDescriptor[] getOperationArguments() {
        ArgumentDescriptor argumentDescriptor = new ArgumentDescriptor(XPATH_LOCATION_ARGUMENT, 2, "An XPath expression indicating the insert location for the new table row.\nNote: If it is not defined then the insert location will be at the caret.");
        argumentDescriptor = new ArgumentDescriptor(RELATIVE_POSITION_ARGUMENT, 3, "The insert position relative to the node determined by the XPath expression.\nCan be: Before, Inside as first child, Inside as last child or After.\nNote: If the XPath expression is not defined this argument is ignored.", new String[]{"Before", "Inside as first child", "Inside as last child", "After"}, "Inside as first child");
        argumentDescriptor = CUSTOM_INSERTION_ARGUMENT_DESCRIPTOR;
        ArgumentDescriptor[] argumentDescriptorArray = new ArgumentDescriptor[]{argumentDescriptor, argumentDescriptor, NAMESPACE_ARGUMENT_DESCRIPTOR, argumentDescriptor};
        return argumentDescriptorArray;
    }

    public InsertRowOperationBase(AuthorTableHelper authorTableHelper) {
        super(authorTableHelper, true);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected void doOperationInternal(AuthorAccess authorAccess, ArgumentsMap argumentsMap) throws AuthorOperationException {
        try {
            AuthorNode authorNode = authorAccess.getDocumentController().getNodeAtOffset(authorAccess.getEditorAccess().getCaretOffset());
            AuthorElement authorElement = this.getElementAncestor(authorNode, 2);
            if (authorElement == null) return;
            int n2 = 0;
            String string = "";
            TableRowsInfo tableRowsInfo = null;
            if ("true".equals(argumentsMap.getArgumentValue(CUSTOM_ROW_INSERTION_ARGUMENT))) {
                Platform platform = authorAccess.getWorkspaceAccess().getPlatform();
                if (Platform.STANDALONE == platform) {
                    tableRowsInfo = SATableRowInsertionCustomizerInvoker.getInstance().customizeTableRowInsertion(authorAccess);
                } else if (Platform.ECLIPSE == platform) {
                    tableRowsInfo = ECTableRowInsertionCustomizerInvoker.getInstance().customizeTableRowInsertion(authorAccess);
                }
                if (tableRowsInfo == null) throw new AuthorOperationStoppedByUserException("Cancelled by user");
                n2 = tableRowsInfo.getRowsNumber();
                string = tableRowsInfo.isInsertBelow() ? "After" : "Before";
            } else {
                n2 = 1;
                string = argumentsMap.getArgumentValue(RELATIVE_POSITION_ARGUMENT).toString();
            }
            this.insertRows(authorAccess, (String)argumentsMap.getArgumentValue(XPATH_LOCATION_ARGUMENT), (String)argumentsMap.getArgumentValue("namespace"), authorNode, authorElement, n2, string);
            return;
        }
        catch (BadLocationException badLocationException) {
            throw new AuthorOperationException("The operation cannot be performed due to: " + badLocationException.getMessage(), badLocationException);
        }
    }

    public void insertRows(AuthorAccess authorAccess, String string, String string2, AuthorNode authorNode, AuthorElement authorElement, int n2, String string3) throws BadLocationException, AuthorOperationException {
        AuthorNode authorNode2;
        Object object;
        AuthorElement authorElement2 = null;
        AuthorDocumentController authorDocumentController = authorAccess.getDocumentController();
        authorElement2 = this.getElementAncestor(authorNode, 1);
        if (authorElement2 == null && (object = this.getElementAncestor(authorNode, 2)) != null) {
            AuthorNode authorNode3;
            if ("Before".equals(string3)) {
                authorNode3 = authorAccess.getEditorAccess().getFullySelectedNode();
                if (authorNode3 != null && this.tableHelper.isTableRow(authorNode3)) {
                    authorElement2 = (AuthorElement)authorNode3;
                    string = authorDocumentController.getXPathExpression(authorElement2.getStartOffset() + 1);
                } else {
                    authorNode2 = authorDocumentController.getNodeAtOffset(authorAccess.getEditorAccess().getCaretOffset() + 1);
                    authorElement2 = this.getElementAncestor(authorNode2, 1);
                }
            } else if ("After".equals(string3)) {
                authorNode3 = authorDocumentController.getNodeAtOffset(authorAccess.getEditorAccess().getCaretOffset() - 1);
                authorElement2 = this.getElementAncestor(authorNode3, 1);
            }
        }
        object = new StringBuilder();
        for (int i2 = 0; i2 < n2; ++i2) {
            ((StringBuilder)object).append(this.getRowXMLFragment(authorAccess, authorElement, authorElement2, this.useCurrentRowTemplateOnInsert(), string2, "Before".equals(string3)));
        }
        String string4 = ((StringBuilder)object).toString();
        if (!string4.isEmpty()) {
            authorDocumentController.insertXMLFragmentSchemaAware(string4, string, string3);
            if (authorElement2 != null) {
                authorNode2 = authorElement2;
                if ("Before".equals(string3)) {
                    AuthorNode authorNode4 = authorDocumentController.getNodeAtOffset(authorElement2.getStartOffset() - 1);
                    authorNode2 = authorNode4.getType() == 0 && this.tableHelper.isTableRow(authorNode4) ? (AuthorElement)authorNode4 : null;
                }
                if (authorNode2 != null) {
                    this.incrementRowSpans(authorElement, (AuthorElement)authorNode2, authorAccess, 1, n2, string3);
                }
            }
        }
    }

    public String getRowXMLFragment(AuthorAccess authorAccess, AuthorElement authorElement, String string, String string2, int n2, int n3) throws BadLocationException {
        String string3;
        StringBuilder stringBuilder = null;
        if (string2 != null && n2 <= n3 && (string3 = this.getRowElementName(authorElement)) != null) {
            String string4;
            int n4;
            stringBuilder = new StringBuilder("<").append(string3);
            if (string != null) {
                n4 = string3.indexOf(58);
                string4 = null;
                if (n4 > 0) {
                    string4 = string3.substring(0, n4);
                }
                stringBuilder.append(" xmlns");
                if (string4 != null) {
                    stringBuilder.append(":").append(string4);
                }
                stringBuilder.append("=\"").append(string).append("\"");
            }
            stringBuilder.append(">");
            for (n4 = 0; n4 < n3; ++n4) {
                string4 = this.getCellElementName(authorElement, n4);
                if (n4 == n2) {
                    stringBuilder.append(string2);
                }
                if (string4 == null) continue;
                String string5 = this.getDefaultContentForEmptyCells();
                if (string5 != null) {
                    stringBuilder.append("<").append(string4).append(">");
                    stringBuilder.append(string5);
                    stringBuilder.append("</").append(string4).append(">");
                    continue;
                }
                stringBuilder.append("<").append(string4).append("/>");
            }
            if (n2 == n3) {
                stringBuilder.append(string2);
            }
            stringBuilder.append("</").append(string3).append(">");
        }
        return stringBuilder == null ? null : stringBuilder.toString();
    }

    private String getRowXMLFragment(AuthorAccess authorAccess, AuthorElement authorElement, AuthorElement authorElement2, boolean bl, String string, boolean bl2) throws BadLocationException {
        String string2;
        StringBuilder stringBuilder = null;
        String string3 = string2 = this.getRowElementName(authorElement);
        if (string2 == null) {
            if (authorElement2 != null) {
                string3 = authorElement2.getName();
            }
        } else if (bl) {
            string3 = authorElement2 != null ? authorElement2.getName() : string2;
        }
        String string4 = string = bl && authorElement2 != null ? authorElement2.getNamespace() : string;
        if (string3 != null) {
            Object object;
            int n2;
            stringBuilder = new StringBuilder("<").append(string3);
            if (string != null) {
                n2 = string3.indexOf(58);
                object = null;
                if (n2 > 0) {
                    object = string3.substring(0, n2);
                }
                stringBuilder.append(" xmlns");
                if (object != null) {
                    stringBuilder.append(":").append((String)object);
                }
                stringBuilder.append("=\"").append(string).append("\"");
            }
            stringBuilder.append(">");
            n2 = bl ? 1 : 0;
            if (n2 == 0 && this.getCellElementName(authorElement, 0) == null) {
                n2 = 1;
            }
            if (authorElement2 != null && n2 != 0) {
                object = this.tableHelper.getTableCellSpanProvider(authorElement);
                List<AuthorNode> list = authorElement2.getContentNodes();
                String[] stringArray = InsertRowOperationBase.mergeArrays(this.tableHelper.getIgnoredRowAttributes(), this.tableHelper.getIgnoredCellIDAttributes());
                ArrayList<String> arrayList = new ArrayList<String>();
                arrayList.addAll(Arrays.asList(stringArray));
                String[] stringArray2 = this.tableHelper instanceof AbstractDocumentTypeHelper ? ((AbstractDocumentTypeHelper)this.tableHelper).getAllowedCellAttributesToCopy() : null;
                for (AuthorNode authorNode : list) {
                    Integer n3;
                    if (authorNode.getType() != 0 || (n3 = object.getRowSpan((AuthorElement)authorNode)) != null && n3 >= 2 && !bl2) continue;
                    String string5 = this.createCellXMLFragment((AuthorElement)authorNode, stringArray, stringArray2, this.getDefaultContentForEmptyCells());
                    stringBuilder.append(string5);
                }
            } else {
                int n4 = authorAccess.getTableAccess().getTableNumberOfColumns(authorElement);
                if (n4 > 0) {
                    for (int i2 = 0; i2 < n4; ++i2) {
                        this.createCell(authorElement, stringBuilder, i2);
                    }
                } else if (n4 <= 0) {
                    this.createCell(authorElement, stringBuilder, 0);
                }
            }
            stringBuilder.append("</").append(string3).append(">");
        }
        return stringBuilder == null ? null : stringBuilder.toString();
    }

    private void createCell(AuthorElement authorElement, StringBuilder stringBuilder, int n2) {
        String string = this.getCellElementName(authorElement, n2);
        if (string != null) {
            String string2 = this.getDefaultContentForEmptyCells();
            if (string2 != null) {
                stringBuilder.append("<").append(string).append(">");
                stringBuilder.append(string2);
                stringBuilder.append("</").append(string).append(">");
            } else {
                stringBuilder.append("<").append(string).append("/>");
            }
        }
    }

    private static String[] mergeArrays(String[] stringArray, String[] stringArray2) {
        String[] stringArray3;
        if (stringArray == null) {
            stringArray3 = stringArray2;
        } else if (stringArray2 == null) {
            stringArray3 = stringArray;
        } else {
            String[] stringArray4 = new String[stringArray.length + stringArray2.length];
            System.arraycopy(stringArray, 0, stringArray4, 0, stringArray.length);
            System.arraycopy(stringArray2, 0, stringArray4, stringArray.length, stringArray2.length);
            stringArray3 = stringArray4;
        }
        return stringArray3;
    }

    protected String createCellXMLFragment(AuthorElement authorElement, String[] stringArray, String[] stringArray2, String string) throws BadLocationException {
        StringBuilder stringBuilder = new StringBuilder();
        if (authorElement != null) {
            stringBuilder.append("<").append(authorElement.getName());
            int n2 = authorElement.getAttributesCount();
            for (int i2 = 0; i2 < n2; ++i2) {
                String string2 = authorElement.getAttributeAtIndex(i2);
                AttrValue attrValue = authorElement.getAttribute(string2);
                if (!attrValue.isSpecified()) continue;
                boolean bl = false;
                for (String string3 : stringArray) {
                    if (!string2.equals(string3)) continue;
                    bl = true;
                    break;
                }
                if (stringArray2 != null) {
                    bl = true;
                    for (String string3 : stringArray2) {
                        if (!string2.equals(string3)) continue;
                        bl = false;
                        break;
                    }
                }
                if (bl) continue;
                stringBuilder.append(" ").append(string2).append("=\"").append(attrValue.getRawValue()).append("\"");
            }
            if (string != null && string.length() > 0) {
                stringBuilder.append(">");
                stringBuilder.append(string);
                stringBuilder.append("</").append(authorElement.getName()).append(">");
            } else {
                stringBuilder.append("/>");
            }
        }
        return stringBuilder.toString();
    }

    private void incrementRowSpans(AuthorElement authorElement, AuthorElement authorElement2, AuthorAccess authorAccess, int n2, int n3, String string) throws BadLocationException {
        int n4 = authorAccess.getTableAccess().getTableNumberOfColumns(authorElement);
        AuthorTableCellSpanProvider authorTableCellSpanProvider = null;
        List<AuthorNode> list = authorElement2.getContentNodes();
        int n5 = list.size();
        for (AuthorNode authorNode : list) {
            Integer n6;
            if (authorNode.getType() != 0 || !this.tableHelper.isTableCell(authorNode)) continue;
            AuthorElement authorElement3 = (AuthorElement)authorNode;
            if (authorTableCellSpanProvider == null) {
                authorTableCellSpanProvider = this.tableHelper.getTableCellSpanProvider(authorElement);
            }
            if ((n6 = authorTableCellSpanProvider.getRowSpan(authorElement3)) == null || n6 <= 1 || n6 < n2 && (!"Before".equals(string) || n6 + n3 <= n2)) continue;
            this.tableHelper.updateTableRowSpan(authorAccess, authorElement3, n6 + n3);
        }
        if (n4 != n5) {
            AuthorNode authorNode = authorAccess.getDocumentController().getNodeAtOffset(authorElement2.getStartOffset() - 1);
            ++n2;
            if (authorNode.getType() == 0 && this.tableHelper.isTableRow(authorNode)) {
                this.incrementRowSpans(authorElement, (AuthorElement)authorNode, authorAccess, n2, n3, string);
            }
        }
    }

    @Override
    public ArgumentDescriptor[] getArguments() {
        return this.arguments;
    }

    @Override
    public String getDescription() {
        return "Insert a table row.";
    }

    protected abstract String getCellElementName(AuthorElement var1, int var2);

    protected abstract String getRowElementName(AuthorElement var1);

    protected boolean useCurrentRowTemplateOnInsert() {
        return false;
    }

    protected String getDefaultContentForEmptyCells() {
        return null;
    }

    protected static ArgumentDescriptor[] removeCustomInsertionDescriptor(ArgumentDescriptor[] argumentDescriptorArray) {
        ArrayList arrayList = new ArrayList(argumentDescriptorArray.length);
        Collections.addAll(arrayList, argumentDescriptorArray);
        arrayList.remove(CUSTOM_INSERTION_ARGUMENT_DESCRIPTOR);
        return arrayList.toArray(new ArgumentDescriptor[0]);
    }
}

