/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.ecss.extensions.commons.operations;

import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.sync.annotations.api.API;
import ro.sync.annotations.api.APIType;
import ro.sync.annotations.api.SourceType;
import ro.sync.ecss.dom.wrappers.mutable.AuthorSource;
import ro.sync.ecss.extensions.api.ArgumentDescriptor;
import ro.sync.ecss.extensions.api.ArgumentsMap;
import ro.sync.ecss.extensions.api.AuthorAccess;
import ro.sync.ecss.extensions.api.AuthorOperation;
import ro.sync.ecss.extensions.api.AuthorOperationException;
import ro.sync.ecss.extensions.api.WebappCompatible;
import ro.sync.ecss.extensions.commons.operations.CommonsOperationsUtil;
import ro.sync.exml.workspace.api.util.InternalTransformerAccess;

@API(type=APIType.INTERNAL, src=SourceType.PUBLIC)
@WebappCompatible(value=false)
public class XQueryUpdateOperation
implements AuthorOperation {
    private static final Logger logger = LoggerFactory.getLogger((String)XQueryUpdateOperation.class.getName());
    public static final String ARGUMENT_SCRIPT = "script";
    public static final String ARGUMENT_SCRIPT_PARAMETERS = "externalParams";
    public static final String ARGUMENT_EXPAND_XINCLUDE_REFERENCES = "expandXincludeReferences";
    private static final String TOKEN_COMMA_END_LINE = ",\n";
    private static final String TOKEN_EQUALS = "=";
    private ArgumentDescriptor[] arguments = new ArgumentDescriptor[3];
    private Map<String, String> externalArguments = null;

    public XQueryUpdateOperation() {
        ArgumentDescriptor argumentDescriptor;
        this.arguments[0] = argumentDescriptor = new ArgumentDescriptor(ARGUMENT_SCRIPT, 0, "A path to the script or the script itself.\nWhen using a path the following apply:\n- a relative path is resolved to the framework directory. \n- the ${framework} editor variable can also be used to refer resources from the framework directory. \n- the path is passed through the catalog mappings.\nIf you provide the actual script, the base system ID for this will be the framework file, so any include/import reference will be resolved relative to the \".framework\" file that contains this action definition");
        this.arguments[1] = argumentDescriptor = new ArgumentDescriptor(ARGUMENT_SCRIPT_PARAMETERS, 0, "Provide external parameters to the xquery script.\nShould be inserted as name=value pairs separated by comma or line break.");
        this.arguments[2] = argumentDescriptor = new ArgumentDescriptor(ARGUMENT_EXPAND_XINCLUDE_REFERENCES, 3, "Add the elements referred through XInclude to the document model.", new String[]{"true", "false"}, "false");
    }

    @Override
    public void doOperation(AuthorAccess authorAccess, ArgumentsMap argumentsMap) throws AuthorOperationException {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        Object object5 = argumentsMap.getArgumentValue(ARGUMENT_SCRIPT_PARAMETERS);
        if (object5 instanceof String && !((String)object5).trim().isEmpty()) {
            this.externalArguments = new HashMap<String, String>();
            object4 = new StringTokenizer((String)object5, TOKEN_COMMA_END_LINE);
            while (((StringTokenizer)object4).hasMoreElements()) {
                object3 = (String)((StringTokenizer)object4).nextElement();
                int n2 = ((String)object3).indexOf(TOKEN_EQUALS);
                if (n2 != -1) {
                    object2 = ((String)object3).substring(0, n2);
                    object = ((String)object3).substring(n2 + 1, ((String)object3).length());
                    this.externalArguments.put(((String)object2).trim(), (String)object);
                    continue;
                }
                throw new IllegalArgumentException("The arguments should be defined as key=value pairs.");
            }
        }
        if ((object4 = argumentsMap.getArgumentValue(ARGUMENT_SCRIPT)) instanceof String) {
            object3 = null;
            URL uRL = CommonsOperationsUtil.expandAndResolvePath(authorAccess, (String)object4);
            if (uRL != null) {
                object3 = new StreamSource(uRL.toExternalForm());
            } else {
                object2 = (String)object4;
                if (logger.isDebugEnabled()) {
                    logger.debug("Execute " + (String)object2);
                }
                object3 = new StreamSource(new StringReader((String)object2));
            }
            object2 = authorAccess.getDocumentController();
            object2.beginCompoundEdit();
            try {
                Object object6;
                Object object7;
                Object object8;
                object = ((InternalTransformerAccess)((Object)authorAccess.getXMLUtilAccess())).internalCreateXQueryUpdateTransformer((Source)object3, null);
                if (this.externalArguments != null) {
                    object8 = this.externalArguments.entrySet();
                    object7 = object8.iterator();
                    while (object7.hasNext()) {
                        object6 = (Map.Entry)object7.next();
                        ((Transformer)object).setParameter((String)object6.getKey(), object6.getValue());
                    }
                }
                if ((object8 = argumentsMap.getArgumentValue(ARGUMENT_EXPAND_XINCLUDE_REFERENCES)) == null) {
                    object8 = false;
                }
                object7 = new AuthorSource(authorAccess, Boolean.valueOf(object8.toString()));
                object6 = new StringWriter();
                StreamResult streamResult = new StreamResult((Writer)object6);
                ((Transformer)object).transform((Source)object7, streamResult);
            }
            catch (IllegalArgumentException | TransformerException exception) {
                logger.error((Object)exception, (Throwable)exception);
                throw new AuthorOperationException("Execution failed: " + exception.getMessage(), exception);
            }
            finally {
                object2.endCompoundEdit();
            }
        } else {
            throw new IllegalArgumentException("The argument value was not defined, it is " + object4);
        }
    }

    @Override
    public ArgumentDescriptor[] getArguments() {
        return this.arguments;
    }

    @Override
    public String getDescription() {
        return "Executes an XQuery Update script.";
    }
}

