/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.ecss.extensions.commons.operations;

import javax.swing.text.BadLocationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.sync.annotations.api.API;
import ro.sync.annotations.api.APIType;
import ro.sync.annotations.api.SourceType;
import ro.sync.ecss.extensions.api.ArgumentDescriptor;
import ro.sync.ecss.extensions.api.ArgumentsMap;
import ro.sync.ecss.extensions.api.AuthorAccess;
import ro.sync.ecss.extensions.api.AuthorDocumentController;
import ro.sync.ecss.extensions.api.AuthorOperation;
import ro.sync.ecss.extensions.api.AuthorOperationException;
import ro.sync.ecss.extensions.api.WebappCompatible;
import ro.sync.ecss.extensions.api.XPathVersion;
import ro.sync.ecss.extensions.api.node.AuthorDocumentFragment;
import ro.sync.ecss.extensions.api.node.AuthorNode;
import ro.sync.ecss.extensions.api.node.AuthorNodeUtil;

@API(type=APIType.INTERNAL, src=SourceType.PUBLIC)
@WebappCompatible
public class MoveElementOperation
implements AuthorOperation {
    private static final Logger logger = LoggerFactory.getLogger((String)MoveElementOperation.class.getName());
    private static final String ARGUMENT_SOURCE_LOCATION = "sourceLocation";
    private static final String ARGUMENT_DELETE_LOCATION = "deleteLocation";
    private static final String ARGUMENT_SURROUND_FRAGMENT = "surroundFragment";
    private static final String ARGUMENT_TARGET_LOCATION = "targetLocation";
    private static final String ARGUMENT_RELATIVE_LOCATION = "insertPosition";
    private static final String ARGUMENT_MOVE_ONLY_CONTENT = "moveOnlySourceContentNodes";
    private static final String ARGUMENT_PROCESS_CHANGE_MARKERS = "processTrackedChangesForXPathLocations";
    private static final String ARGUMENT_ALWAYS_PRESERVE_TRACKED_CHANGES_IN_MOVED_CONTENT = "alwaysPreserveTrackedChangesInMovedContent";
    private ArgumentDescriptor[] arguments = new ArgumentDescriptor[8];

    public MoveElementOperation() {
        ArgumentDescriptor argumentDescriptor;
        this.arguments[0] = argumentDescriptor = new ArgumentDescriptor(ARGUMENT_SOURCE_LOCATION, 2, "An XPath expression that identifies the node to be moved. If missing, the node at caret will be moved.");
        this.arguments[1] = argumentDescriptor = new ArgumentDescriptor(ARGUMENT_MOVE_ONLY_CONTENT, 3, "Controls whether the source element is moved entirely or just its content (the content of a node consists in text, other nodes or both). If true, the copied fragment consists in just the content of the node identified by the argument 'sourceLocation'. If false, the entire node will be copied.", new String[]{"true", "false"}, "false");
        this.arguments[2] = argumentDescriptor = new ArgumentDescriptor(ARGUMENT_DELETE_LOCATION, 2, "An XPath expression that identifies the node to be removed. Optional. If missing, the node identified by 'sourceLocation' as being moved will be removed.");
        this.arguments[3] = argumentDescriptor = new ArgumentDescriptor(ARGUMENT_SURROUND_FRAGMENT, 1, "A string representation of an XML fragment. The moved node will be inserted in the first leaf will be this fragment and this fragment containing the moved node will be placed at the destination.");
        this.arguments[4] = argumentDescriptor = new ArgumentDescriptor(ARGUMENT_TARGET_LOCATION, 2, "An XPath expression that identifies the location where the node must be moved to.");
        this.arguments[5] = argumentDescriptor = new ArgumentDescriptor(ARGUMENT_RELATIVE_LOCATION, 3, "The insert position relative to the node determined by the \"targetLocation\" XPath expression.\nCan be: Before, Inside as first child, Inside as last child or After.\nNote: If the XPath expression is not defined this argument is ignored", new String[]{"Before", "Inside as first child", "Inside as last child", "After"}, "Inside as first child");
        this.arguments[6] = argumentDescriptor = new ArgumentDescriptor(ARGUMENT_PROCESS_CHANGE_MARKERS, 3, "When nodes are located via XPath, if you have nodes deleted with change tracking in the document they are considered as being present by default.\nBut if you set this argument to 'true', the nodes deleted with track changes will be ignored when the xpath locations are computed. ", new String[]{"true", "false"}, "false");
        this.arguments[7] = argumentDescriptor = new ArgumentDescriptor(ARGUMENT_ALWAYS_PRESERVE_TRACKED_CHANGES_IN_MOVED_CONTENT, 3, "Always preserve track changes in the moved content, regardless of the track changes state", new String[]{"true", "false"}, "false");
    }

    @Override
    public String getDescription() {
        return "Moves an element to a different location. The element to move as well as the destination are provided through XPath expressions.";
    }

    @Override
    public void doOperation(AuthorAccess authorAccess, ArgumentsMap argumentsMap) throws AuthorOperationException {
        boolean bl = false;
        String string = (String)argumentsMap.getArgumentValue(ARGUMENT_SOURCE_LOCATION);
        AuthorNode authorNode = null;
        boolean bl2 = "true".equals(argumentsMap.getArgumentValue(ARGUMENT_PROCESS_CHANGE_MARKERS));
        if (string != null && string.trim().length() > 0) {
            authorNode = MoveElementOperation.executeLocationXPath(authorAccess, string, bl2);
        } else {
            int n2 = authorAccess.getEditorAccess().getCaretOffset();
            try {
                authorNode = authorAccess.getDocumentController().getNodeAtOffset(n2);
            }
            catch (BadLocationException badLocationException) {
                logger.error((Object)badLocationException, (Throwable)badLocationException);
            }
        }
        if (logger.isDebugEnabled()) {
            logger.debug("To move " + authorNode);
        }
        if (authorAccess.getEditorAccess().getFullySelectedNode() == authorNode) {
            bl = true;
        }
        if (authorNode != null) {
            AuthorNode authorNode2 = authorNode;
            String string2 = (String)argumentsMap.getArgumentValue(ARGUMENT_DELETE_LOCATION);
            if (string2 != null && !string2.isEmpty()) {
                authorNode2 = MoveElementOperation.executeLocationXPath(authorAccess, string2, bl2);
            }
            if (logger.isDebugEnabled()) {
                logger.debug("To delete " + authorNode2);
            }
            MoveElementOperation.moveNode(authorNode, authorNode2, bl, authorAccess, argumentsMap);
        }
    }

    private static void moveNode(AuthorNode authorNode, AuthorNode authorNode2, boolean bl, AuthorAccess authorAccess, ArgumentsMap argumentsMap) throws AuthorOperationException {
        block9: {
            String string = (String)argumentsMap.getArgumentValue(ARGUMENT_TARGET_LOCATION);
            if (string != null) {
                String string2 = (String)argumentsMap.getArgumentValue(ARGUMENT_RELATIVE_LOCATION);
                AuthorDocumentController authorDocumentController = authorAccess.getDocumentController();
                try {
                    authorDocumentController.beginCompoundEdit();
                    boolean bl2 = "true".equals(argumentsMap.getArgumentValue(ARGUMENT_MOVE_ONLY_CONTENT));
                    boolean bl3 = MoveElementOperation.isAlwaysPreserveTrackChangesTrue(argumentsMap);
                    bl = bl2 ? false : bl;
                    AuthorDocumentFragment authorDocumentFragment = MoveElementOperation.getFragmentToMove(authorNode, authorDocumentController, bl3, bl2);
                    boolean bl4 = "true".equals(argumentsMap.getArgumentValue(ARGUMENT_PROCESS_CHANGE_MARKERS));
                    int n2 = authorDocumentController.getXPathLocationOffset(string, string2, bl4);
                    if (logger.isDebugEnabled()) {
                        logger.debug("Insert location for fragment: " + n2);
                    }
                    if (n2 != -1) {
                        if (authorNode2.getStartOffset() < n2 && n2 <= authorNode2.getEndOffset()) {
                            throw new AuthorOperationException("Trying to move inside the node that will be removed. Node to remove: " + authorNode2 + ". Computed insertion offset " + n2);
                        }
                        MoveElementOperation.moveFragment(authorDocumentFragment, n2, bl, authorNode2, authorAccess, argumentsMap);
                        break block9;
                    }
                    throw new AuthorOperationException("The XPath expression: " + string + " - doesn't identify any node");
                }
                catch (BadLocationException badLocationException) {
                    throw new AuthorOperationException("Unable to move the element because of: ", badLocationException);
                }
                finally {
                    authorDocumentController.endCompoundEdit();
                }
            }
            throw new AuthorOperationException("The argument 'targetLocation' was not specified.");
        }
    }

    private static AuthorDocumentFragment getFragmentToMove(AuthorNode authorNode, AuthorDocumentController authorDocumentController, boolean bl, boolean bl2) throws BadLocationException {
        AuthorDocumentFragment authorDocumentFragment = null;
        int n2 = authorNode.getStartOffset();
        int n3 = authorNode.getEndOffset();
        if (bl2) {
            if (n2 + 1 != n3) {
                authorDocumentFragment = bl ? authorDocumentController.createDocumentFragment(n2 + 1, n3 - 1, true) : authorDocumentController.createDocumentFragment(n2 + 1, n3 - 1);
            }
        } else {
            authorDocumentFragment = bl ? authorDocumentController.createDocumentFragment(n2, n3, true) : authorDocumentController.createDocumentFragment(authorNode, true);
        }
        return authorDocumentFragment;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void moveFragment(AuthorDocumentFragment authorDocumentFragment, int n2, boolean bl, AuthorNode authorNode, AuthorAccess authorAccess, ArgumentsMap argumentsMap) throws AuthorOperationException, BadLocationException {
        Object object;
        Object object2;
        AuthorDocumentController authorDocumentController = authorAccess.getDocumentController();
        boolean bl2 = false;
        if (MoveElementOperation.isAlwaysPreserveTrackChangesTrue(argumentsMap) && authorAccess.getReviewController().isTrackingChanges()) {
            authorAccess.getReviewController().toggleTrackChanges();
            bl2 = true;
        }
        try {
            object2 = (String)argumentsMap.getArgumentValue(ARGUMENT_SURROUND_FRAGMENT);
            if (object2 != null) {
                bl = false;
                object = authorDocumentController.createNewDocumentFragmentInContext((String)object2, n2);
                authorDocumentController.insertFragment(n2, (AuthorDocumentFragment)object);
                AuthorNode authorNode2 = AuthorNodeUtil.getFirstLeaf((AuthorDocumentFragment)object);
                if (authorNode2 != null) {
                    n2 += authorNode2.getStartOffset() + 1;
                }
                if (logger.isDebugEnabled()) {
                    logger.debug("Insert location for moved: " + n2);
                }
            }
            if (authorDocumentFragment != null) {
                authorDocumentController.insertFragment(n2, authorDocumentFragment);
            }
        }
        finally {
            if (bl2) {
                authorAccess.getReviewController().toggleTrackChanges();
            }
        }
        object2 = authorDocumentController.createPositionInContent(n2 + 1);
        authorDocumentController.deleteNode(authorNode);
        if (bl) {
            object = authorDocumentController.getNodeAtOffset(object2.getOffset());
            if (object != null) {
                authorAccess.getEditorAccess().select(object.getStartOffset(), object.getEndOffset() + 1);
            }
        } else {
            authorAccess.getEditorAccess().setCaretPosition(object2.getOffset());
        }
    }

    private static boolean isAlwaysPreserveTrackChangesTrue(ArgumentsMap argumentsMap) {
        return "true".equals(argumentsMap.getArgumentValue(ARGUMENT_ALWAYS_PRESERVE_TRACKED_CHANGES_IN_MOVED_CONTENT));
    }

    private static AuthorNode executeLocationXPath(AuthorAccess authorAccess, String string, boolean bl) throws AuthorOperationException {
        AuthorNode authorNode = null;
        AuthorNode[] authorNodeArray = authorAccess.getDocumentController().findNodesByXPath(string, null, true, true, true, bl, XPathVersion.XPATH_3_0, true);
        if (authorNodeArray.length > 0) {
            if (authorNodeArray.length > 1) {
                logger.warn("More than one nodes identified by: " + string + ". Only the first node will be processed");
            }
        } else {
            throw new AuthorOperationException("The XPath expression: " + string + " - doesn't identify any node");
        }
        authorNode = authorNodeArray[0];
        return authorNode;
    }

    @Override
    public ArgumentDescriptor[] getArguments() {
        return this.arguments;
    }
}

