/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.ecss.extensions.commons.operations;

import ro.sync.annotations.api.API;
import ro.sync.annotations.api.APIType;
import ro.sync.annotations.api.SourceType;
import ro.sync.ecss.extensions.api.ArgumentDescriptor;
import ro.sync.ecss.extensions.api.ArgumentsMap;
import ro.sync.ecss.extensions.api.AuthorAccess;
import ro.sync.ecss.extensions.api.AuthorOperation;
import ro.sync.ecss.extensions.api.AuthorOperationException;
import ro.sync.ecss.extensions.api.WebappCompatible;
import ro.sync.exml.workspace.api.editor.transformation.TransformationScenarioNotFoundException;

@API(type=APIType.INTERNAL, src=SourceType.PUBLIC)
@WebappCompatible(value=false)
public class ExecuteTransformationScenariosOperation
implements AuthorOperation {
    private ArgumentDescriptor[] arguments = new ArgumentDescriptor[1];
    private static final String SCENARIO_NAMES = "scenarioNames";

    public ExecuteTransformationScenariosOperation() {
        ArgumentDescriptor argumentDescriptor;
        this.arguments[0] = argumentDescriptor = new ArgumentDescriptor(SCENARIO_NAMES, 0, "The names of the transformation scenario which will be executed, separated by new lines.");
    }

    @Override
    public String getDescription() {
        return "Run a named transformation scenario defined in the associated document type.";
    }

    @Override
    public void doOperation(AuthorAccess authorAccess, ArgumentsMap argumentsMap) throws AuthorOperationException {
        Object object = argumentsMap.getArgumentValue(SCENARIO_NAMES);
        if (object != null) {
            String string = (String)object;
            try {
                String[] stringArray = string.split("\n");
                authorAccess.getEditorAccess().runTransformationScenarios(stringArray, null);
            }
            catch (TransformationScenarioNotFoundException transformationScenarioNotFoundException) {
                throw new AuthorOperationException(transformationScenarioNotFoundException.getMessage(), transformationScenarioNotFoundException);
            }
        } else {
            throw new AuthorOperationException("The scenario name was not specified as a parameter.");
        }
    }

    @Override
    public ArgumentDescriptor[] getArguments() {
        return this.arguments;
    }
}

