/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.ecss.extensions.commons.id;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import ro.sync.annotations.api.API;
import ro.sync.annotations.api.APIType;
import ro.sync.annotations.api.SourceType;
import ro.sync.ecss.extensions.api.AuthorResourceBundle;
import ro.sync.ecss.extensions.commons.id.GenerateIDElementsInfo;
import ro.sync.ecss.extensions.commons.ui.OKCancelDialog;

@API(type=APIType.INTERNAL, src=SourceType.PUBLIC)
public class SAIDElementsCustomizerDialog
extends OKCancelDialog {
    private final DefaultListModel listModel = new DefaultListModel();
    private final JList listOfElements = new JList(this.listModel);
    private JCheckBox autoAssignElementIDs;
    private final JPanel listPanel;
    private final JButton addButton;
    private final JButton editButton;
    private final JButton removeButton;
    private final String listMessage;
    private final JTextField idGenerationPatternField = new JTextField();
    private JCheckBox filterIDsOnCopy;
    private final AuthorResourceBundle authorResourceBundle;

    public SAIDElementsCustomizerDialog(Frame frame, String string, AuthorResourceBundle authorResourceBundle) {
        this(frame, string, authorResourceBundle, false);
    }

    public SAIDElementsCustomizerDialog(Frame frame, String string, AuthorResourceBundle authorResourceBundle, boolean bl) {
        super(frame, authorResourceBundle.getMessage("ID_options"), true);
        this.listMessage = string;
        this.authorResourceBundle = authorResourceBundle;
        JPanel jPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 7, 5);
        JLabel jLabel = new JLabel("ID Pattern:");
        jPanel.add((Component)jLabel, gridBagConstraints);
        ++gridBagConstraints.gridx;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 0, 7, 0);
        jLabel.setLabelFor(this.idGenerationPatternField);
        jPanel.add((Component)this.idGenerationPatternField, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        ++gridBagConstraints.gridy;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(0, 0, 7, 0);
        this.listPanel = new JPanel(new GridBagLayout());
        jPanel.add((Component)this.listPanel, gridBagConstraints);
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.gridx = 0;
        gridBagConstraints2.gridy = 0;
        gridBagConstraints2.gridwidth = 3;
        gridBagConstraints2.gridheight = 1;
        gridBagConstraints2.weightx = 1.0;
        gridBagConstraints2.weighty = 0.0;
        gridBagConstraints2.fill = 0;
        gridBagConstraints2.anchor = 17;
        gridBagConstraints2.insets = new Insets(0, 0, 5, 0);
        JLabel jLabel2 = new JLabel(string + ":");
        this.listPanel.add((Component)jLabel2, gridBagConstraints2);
        gridBagConstraints2.gridx = 0;
        ++gridBagConstraints2.gridy;
        gridBagConstraints2.weightx = 1.0;
        gridBagConstraints2.weighty = 1.0;
        gridBagConstraints2.fill = 1;
        gridBagConstraints2.insets = new Insets(0, 0, 5, 0);
        JScrollPane jScrollPane = new JScrollPane(this.listOfElements);
        jScrollPane.setPreferredSize(new Dimension(300, 150));
        this.listPanel.add((Component)jScrollPane, gridBagConstraints2);
        jLabel2.setLabelFor(this.listOfElements);
        this.addButton = new JButton(new AbstractAction(authorResourceBundle.getMessage("Add")){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SAIDElementsCustomizerDialog.this.addNewElement();
            }
        });
        gridBagConstraints2.gridx = 0;
        ++gridBagConstraints2.gridy;
        gridBagConstraints2.gridwidth = 1;
        gridBagConstraints2.weightx = 1.0;
        gridBagConstraints2.weighty = 0.0;
        gridBagConstraints2.fill = 0;
        gridBagConstraints2.anchor = 13;
        gridBagConstraints2.insets = new Insets(0, 0, 5, 5);
        this.listPanel.add((Component)this.addButton, gridBagConstraints2);
        this.editButton = new JButton(new AbstractAction(authorResourceBundle.getMessage("Edit")){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SAIDElementsCustomizerDialog.this.editElement();
            }
        });
        ++gridBagConstraints2.gridx;
        gridBagConstraints2.weightx = 0.0;
        this.listPanel.add((Component)this.editButton, gridBagConstraints2);
        this.removeButton = new JButton(new AbstractAction(authorResourceBundle.getMessage("Remove")){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SAIDElementsCustomizerDialog.this.removeElement();
            }
        });
        ++gridBagConstraints2.gridx;
        gridBagConstraints2.insets.right = 0;
        this.listPanel.add((Component)this.removeButton, gridBagConstraints2);
        gridBagConstraints.gridx = 0;
        ++gridBagConstraints.gridy;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(0, 0, 7, 0);
        this.autoAssignElementIDs = new JCheckBox(authorResourceBundle.getMessage("Autogenerate_ids_for_elements"));
        this.autoAssignElementIDs.setBorder(BorderFactory.createEmptyBorder());
        jPanel.add((Component)this.autoAssignElementIDs, gridBagConstraints);
        ++gridBagConstraints.gridy;
        String string2 = bl ? authorResourceBundle.getMessage("Remove_ids_on_copy") : authorResourceBundle.getMessage("Remove_ids_on_copy_in_same_doc");
        this.filterIDsOnCopy = new JCheckBox(string2);
        this.filterIDsOnCopy.setBorder(BorderFactory.createEmptyBorder());
        jPanel.add((Component)this.filterIDsOnCopy, gridBagConstraints);
        this.add(jPanel);
        this.setMinimumSize(new Dimension(400, 400));
        this.setResizable(true);
        this.listOfElements.setSelectionMode(0);
        this.listOfElements.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                if (listSelectionEvent.getValueIsAdjusting()) {
                    return;
                }
                SAIDElementsCustomizerDialog.this.updateButtonState();
            }
        });
        this.updateButtonState();
    }

    private void updateButtonState() {
        int n2 = this.listOfElements.getSelectedIndex();
        boolean bl = n2 != -1;
        this.editButton.setEnabled(bl);
        this.removeButton.setEnabled(bl);
    }

    private void addNewElement() {
        String string = JOptionPane.showInputDialog(this, this.listMessage + ": ", this.authorResourceBundle.getMessage("Add"), -1);
        if (string != null) {
            this.listModel.addElement(string);
            this.listOfElements.setSelectedIndex(this.listModel.getSize() - 1);
        }
    }

    private void editElement() {
        String string;
        int n2 = this.listOfElements.getSelectedIndex();
        if (n2 != -1 && (string = (String)JOptionPane.showInputDialog(this, this.listMessage + ": ", this.authorResourceBundle.getMessage("Edit"), -1, null, null, this.listModel.get(n2))) != null) {
            this.listModel.set(n2, string);
        }
    }

    private void removeElement() {
        int n2 = this.listOfElements.getSelectedIndex();
        if (n2 != -1) {
            this.listModel.remove(n2);
            int n3 = this.listModel.getSize();
            if (n3 > 0) {
                if (n2 < n3) {
                    this.listOfElements.setSelectedIndex(n2);
                } else {
                    this.listOfElements.setSelectedIndex(n3 - 1);
                }
            }
        }
    }

    public GenerateIDElementsInfo showDialog(GenerateIDElementsInfo generateIDElementsInfo) {
        this.autoAssignElementIDs.setSelected(generateIDElementsInfo.isAutoGenerateIDs());
        this.idGenerationPatternField.setText(generateIDElementsInfo.getIdGenerationPattern());
        this.listModel.clear();
        String[] stringArray = generateIDElementsInfo.getElementsWithIDGeneration();
        if (stringArray != null) {
            for (int i2 = 0; i2 < stringArray.length; ++i2) {
                this.listModel.addElement(stringArray[i2]);
            }
        }
        this.filterIDsOnCopy.setSelected(generateIDElementsInfo.isFilterIDsOnCopy());
        this.updateButtonState();
        this.idGenerationPatternField.setToolTipText(generateIDElementsInfo.getPatternTooltip());
        this.setVisible(true);
        if (this.getResult() == 1) {
            Object[] objectArray = new String[this.listModel.getSize()];
            this.listModel.copyInto(objectArray);
            return new GenerateIDElementsInfo(this.autoAssignElementIDs.isSelected(), this.idGenerationPatternField.getText(), (String[])objectArray, this.filterIDsOnCopy.isSelected());
        }
        return null;
    }
}

