/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.ecss.extensions.api.webapp.plugin;

import java.net.HttpCookie;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import ro.sync.annotations.api.API;
import ro.sync.annotations.api.APIType;
import ro.sync.annotations.api.SourceType;

@API(src=SourceType.PUBLIC, type=APIType.NOT_EXTENDABLE)
public class UserContext {
    private final Map<String, String> headersMap;
    private final String sessionId;

    public UserContext(Map<String, String> map, String string) {
        this.headersMap = map;
        this.sessionId = string;
    }

    public Map<String, String> getCookies() {
        String string = this.headersMap.get("cookie");
        if (string == null) {
            return new HashMap<String, String>();
        }
        String[] stringArray = string.split("; ");
        HashMap<String, String> hashMap = new HashMap<String, String>(stringArray.length);
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            try {
                HttpCookie httpCookie = HttpCookie.parse(stringArray[i2]).get(0);
                hashMap.put(httpCookie.getName(), httpCookie.getValue());
                continue;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        return hashMap;
    }

    public Map<String, String> getHeaders() {
        return Collections.unmodifiableMap(this.headersMap);
    }

    public String getSessionId() {
        return this.sessionId;
    }

    public boolean isServiceAccount() {
        return false;
    }
}

