/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.ecss.extensions.api.webapp.plugin;

import java.lang.reflect.Field;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.sync.annotations.api.API;
import ro.sync.annotations.api.APIType;
import ro.sync.annotations.api.SourceType;
import ro.sync.ecss.extensions.api.webapp.plugin.URLStreamHandlerWithContext;
import ro.sync.ecss.extensions.api.webapp.plugin.UserContext;

@API(src=SourceType.PUBLIC, type=APIType.EXTENDABLE)
public class URLStreamHandlerWithContextUtil {
    private static final Logger logger = LoggerFactory.getLogger((String)URLStreamHandlerWithContextUtil.class.getName());
    private static final URLStreamHandlerWithContextUtil instance = new URLStreamHandlerWithContextUtil();
    private Field field;
    private final Map<String, URLStreamHandlerWithContext> handlersCache = new HashMap<String, URLStreamHandlerWithContext>();

    public static URLStreamHandlerWithContextUtil getInstance() {
        return instance;
    }

    public URLStreamHandlerWithContextUtil() {
        try {
            this.field = URL.class.getDeclaredField("handler");
            this.field.setAccessible(true);
        }
        catch (SecurityException securityException) {
            logger.error("Cannot get the handler associated with an URL.");
        }
        catch (NoSuchFieldException noSuchFieldException) {
            logger.error("Unsupported Java version: URL handler could not be found.");
        }
    }

    public void setUserContext(UserContext userContext, URL uRL) throws MalformedURLException {
        URLStreamHandlerWithContext uRLStreamHandlerWithContext = this.getUrlHandler(uRL);
        if (uRLStreamHandlerWithContext != null) {
            uRLStreamHandlerWithContext.setUserContext(userContext, uRL);
        }
    }

    public void copyContextId(URL uRL, URL uRL2) {
        URLStreamHandlerWithContext uRLStreamHandlerWithContext;
        if (uRL.getProtocol().equals(uRL2.getProtocol()) && (uRLStreamHandlerWithContext = this.getUrlHandler(uRL)) != null) {
            uRLStreamHandlerWithContext.setContextId(uRL2, uRLStreamHandlerWithContext.getUrlContextId(uRL));
        }
    }

    public String toStrippedExternalForm(URL uRL) {
        URLStreamHandlerWithContext uRLStreamHandlerWithContext = this.getUrlHandler(uRL);
        if (uRLStreamHandlerWithContext != null) {
            uRL = uRLStreamHandlerWithContext.stripUrlContextId(uRL);
        }
        return uRL.toExternalForm();
    }

    String getUrlContextId(URL uRL) {
        String string = null;
        URLStreamHandlerWithContext uRLStreamHandlerWithContext = this.getUrlHandler(uRL);
        if (uRLStreamHandlerWithContext != null) {
            string = uRLStreamHandlerWithContext.getUrlContextId(uRL);
        }
        return string;
    }

    private synchronized URLStreamHandlerWithContext getUrlHandler(URL uRL) {
        URLStreamHandlerWithContext uRLStreamHandlerWithContext = null;
        if (this.handlersCache.containsKey(uRL.getProtocol())) {
            uRLStreamHandlerWithContext = this.handlersCache.get(uRL.getProtocol());
        } else if (this.field != null) {
            try {
                Object object = this.field.get(uRL);
                if (object instanceof URLStreamHandlerWithContext) {
                    uRLStreamHandlerWithContext = (URLStreamHandlerWithContext)object;
                    this.handlersCache.put(uRL.getProtocol(), uRLStreamHandlerWithContext);
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new AssertionError((Object)"Cannot get the URL stream handler.");
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new AssertionError((Object)"Cannot get the URL stream handler.");
            }
        }
        return uRLStreamHandlerWithContext;
    }

    public void clearCacheForTC() {
        this.handlersCache.clear();
    }
}

