/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.ecss.extensions.api.webapp;

import com.sun.jna.Native;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.imageio.ImageIO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.SAXException;
import ro.sync.annotations.api.API;
import ro.sync.annotations.api.APIType;
import ro.sync.annotations.api.SourceType;
import ro.sync.basic.statics.StaticComponentsRegistry;
import ro.sync.basic.util.EncryptionKey;
import ro.sync.basic.util.URLInfo;
import ro.sync.basic.util.URLUtil;
import ro.sync.basic.util.java.JavaVersion;
import ro.sync.document.DocumentPositionedInfo;
import ro.sync.ecss.dita.DITAAccess;
import ro.sync.ecss.docbook.DocbookAccess;
import ro.sync.ecss.extensions.api.webapp.AuthorDocumentModel;
import ro.sync.ecss.extensions.api.webapp.InternalAuthorDocumentBuilder;
import ro.sync.ecss.extensions.api.webapp.InternalDocumentBuilderBase;
import ro.sync.ecss.extensions.api.webapp.WebappAuthorDocumentFactoryConstants;
import ro.sync.ecss.extensions.api.webapp.plugin.RedirectFollowingURLConnection;
import ro.sync.ecss.extensions.api.webapp.references.WebappReferenceCollectorFactory;
import ro.sync.ecss.strictediting.j;
import ro.sync.ecss.webapp.access.f;
import ro.sync.ecss.webapp.bb;
import ro.sync.ecss.webapp.ditamap.DITAMapDocumentModel;
import ro.sync.ecss.webapp.ditamap.InternalDITAMapDocumentBuilder;
import ro.sync.ecss.webapp.e;
import ro.sync.ecss.webapp.k.b;
import ro.sync.ecss.webapp.k.c;
import ro.sync.ecss.webapp.plugin.h;
import ro.sync.ecss.webapp.v;
import ro.sync.exml.dd;
import ro.sync.exml.editor.DocumentTypeRepository;
import ro.sync.exml.editor.lf;
import ro.sync.exml.editor.lg;
import ro.sync.exml.editor.results.ib;
import ro.sync.exml.editor.s;
import ro.sync.exml.editor.xmleditor.ub;
import ro.sync.exml.options.Options;
import ro.sync.exml.plugin.PluginAdditionalFrameworksProvider;
import ro.sync.exml.plugin.PluginManager;
import ro.sync.exml.wc;
import ro.sync.exml.workspace.api.editor.ReadOnlyReason;
import ro.sync.exml.zip.p;
import ro.sync.i18n.r;
import ro.sync.io.TemporaryFilesFactory;
import ro.sync.net.protocol.Installer;
import ro.sync.net.protocol.http.b.o;
import ro.sync.options.d;
import ro.sync.security.ISecurityChecker;
import ro.sync.security.SecurityChecker;
import ro.sync.security.manager.JreNotSupportingSecurityManagerException;
import ro.sync.security.manager.SandboxSecurityManagerInstaller;
import ro.sync.security.manager.SystemPropertyPermissionChecker;
import ro.sync.ui.application.hd;
import ro.sync.util.editorvars.EditorVariables;
import ro.sync.util.editorvars.g;
import ro.sync.util.jb;
import ro.sync.xml.catalogresolver.CatalogResolverFactory;
import ro.sync.xml.encoding.EncodingDetector;

@API(type=APIType.NOT_EXTENDABLE, src=SourceType.PRIVATE)
public final class WebappAuthorDocumentFactory
implements WebappAuthorDocumentFactoryConstants {
    static final Logger logger = LoggerFactory.getLogger((String)WebappAuthorDocumentFactory.class.getName());
    private static ArrayList<d> optionsListeners;
    private static boolean initialized;
    private static String initializationFatalError;

    private WebappAuthorDocumentFactory() {
    }

    public static DITAMapDocumentModel createDITAMapDocumentInfo(URL uRL, Reader reader, List list, Map<String, ?> map) throws IOException, SAXException {
        return (DITAMapDocumentModel)WebappAuthorDocumentFactory.createAuthorDocumentInfoInternal(uRL, reader, list, map, new InternalDITAMapDocumentBuilder());
    }

    public static AuthorDocumentModel createAuthorDocumentInfo(URL uRL, Reader reader, List list, Map<String, ?> map) throws IOException, SAXException {
        return WebappAuthorDocumentFactory.createAuthorDocumentInfoInternal(uRL, reader, list, map, new InternalAuthorDocumentBuilder());
    }

    private static AuthorDocumentModel createAuthorDocumentInfoInternal(URL uRL, Reader reader, List list, Map<String, ?> map, InternalDocumentBuilderBase internalDocumentBuilderBase) throws IOException, SAXException {
        WebappAuthorDocumentFactory.init();
        return internalDocumentBuilderBase.setSystemId(uRL).setSessionAttributes(map).setContent(reader, list).build();
    }

    public static AuthorDocumentModel createAuthorDocumentInfo(String string, Map<String, ?> map) throws IOException, SAXException {
        return WebappAuthorDocumentFactory.createAuthorDocumentInfoInternal(string, map, new InternalAuthorDocumentBuilder());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static AuthorDocumentModel createAuthorDocumentInfoInternal(String string, Map<String, ?> map, InternalDocumentBuilderBase internalDocumentBuilderBase) throws IOException, SAXException {
        URL uRL = URLUtil.removeAnchor((URL)new URL(string));
        URL uRL2 = WebappAuthorDocumentFactory.getCmsUrl(uRL);
        URLConnection uRLConnection = uRL2.openConnection();
        uRLConnection.connect();
        InputStream inputStream = uRLConnection.getInputStream();
        String string2 = uRLConnection.getHeaderField("oxygen_read_only");
        String string3 = uRLConnection.getHeaderField("oxygen_read_only_reason");
        String string4 = uRLConnection.getHeaderField("oxygen_read_only_reason_code");
        ReadOnlyReason readOnlyReason = new ReadOnlyReason(string3, string4);
        ArrayList arrayList = new ArrayList();
        InputStreamReader inputStreamReader = EncodingDetector.getInstance().createReader(inputStream, URLUtil.getDescription((URL)uRL), null, "UTF8", arrayList);
        URL uRL3 = uRL;
        if (uRLConnection instanceof RedirectFollowingURLConnection) {
            uRL3 = URLUtil.addAuthenticationInfo((URL)uRL, (URL)uRLConnection.getURL());
        }
        AuthorDocumentModel authorDocumentModel = null;
        try {
            authorDocumentModel = WebappAuthorDocumentFactory.createAuthorDocumentInfoInternal(uRL3, inputStreamReader, arrayList, map, internalDocumentBuilderBase);
        }
        finally {
            ((Reader)inputStreamReader).close();
        }
        WebappAuthorDocumentFactory.applyReadOnlyStatus(string2, readOnlyReason, authorDocumentModel);
        return authorDocumentModel;
    }

    private static URL getCmsUrl(URL uRL) throws MalformedURLException {
        URLInfo uRLInfo = new URLInfo(uRL);
        return uRLInfo.getURL(false, false, true);
    }

    private static void applyReadOnlyStatus(String string, ReadOnlyReason readOnlyReason, AuthorDocumentModel authorDocumentModel) {
        if (string != null) {
            authorDocumentModel.getAuthorAccess().getEditorAccess().setReadOnly(readOnlyReason);
        }
    }

    public static AuthorDocumentModel createAuthorDocumentInfo(String string, Reader reader, Map<String, ?> map) throws IOException, SAXException {
        URL uRL = new URL(string);
        return WebappAuthorDocumentFactory.createAuthorDocumentInfo(uRL, reader, Collections.emptyList(), map);
    }

    public static void setOptions(File file, String string) throws MalformedURLException {
        String string2 = URLUtil.correct((File)file).toExternalForm();
        System.setProperty("com.oxygenxml.editor.home.url", string2);
        jb.f(file.getAbsolutePath());
        Options.setFixedOptionsFileName(string);
        WebappAuthorDocumentFactory.init();
        WebappAuthorDocumentFactory.setOverrideOptions();
        hd.b();
        ro.sync.exml.v.c.m();
        List<d> list = WebappAuthorDocumentFactory.getOptionsListeners();
        for (d d2 : list) {
            Options.getInstance().addPropertyListener(d2);
        }
    }

    private static List<d> getOptionsListeners() {
        if (optionsListeners == null) {
            optionsListeners = new ArrayList();
            optionsListeners.add(new d(new String[]{"automatically.accept.certificates"}){

                @Override
                public void update() {
                    o.m().n();
                }
            });
        }
        return optionsListeners;
    }

    public static void setFrameworks(File file) throws MalformedURLException {
        WebappAuthorDocumentFactory.init();
        Options.getInstance().setBooleanProperty("use.custom.frameworks.directory.url", true);
        Options.getInstance().setStringProperty("frameworks.directory.url.with.editor.variables", URLUtil.correct((File)file).toString());
        EditorVariables.setAdditionalFrameworksProvider(new PluginAdditionalFrameworksProvider());
    }

    public static void setUserFrameworks(File file) throws MalformedURLException {
        WebappAuthorDocumentFactory.init();
        EditorVariables.setUserUploadedFrameworks(file);
    }

    @Deprecated
    public static void setPlugins(File file) {
        WebappAuthorDocumentFactory.init();
        if (file != null) {
            PluginManager.cc = null;
            PluginManager.setPluginsDir(file.getAbsolutePath());
        }
        new v().f();
    }

    public static void setPlugins(File file, File file2) {
        WebappAuthorDocumentFactory.init();
        if (file != null) {
            PluginManager.cc = null;
            if (file2 != null) {
                PluginManager.setUserPluginsDir(file2.getAbsolutePath());
            } else {
                PluginManager.setUserPluginsDir(null);
            }
            PluginManager.setPluginsDir(file.getAbsolutePath());
        }
        new v().f();
    }

    public static Reader getPluginsJS() {
        return new h().j();
    }

    public static Reader getPluginsCSS() {
        return new h().f();
    }

    private static void setOverrideOptions() {
        Options.getInstance().setIntegerProperty("ask.open.ditamap.in.dita.manager", 1);
    }

    public static synchronized void init() {
        if (!initialized) {
            try {
                initialized = true;
                WebappAuthorDocumentFactory.setBundleDescriptor();
                dd.j(true);
                System.setProperty("user.name", "User");
                c.b();
                SecurityChecker.setInstance((ISecurityChecker)new b(Options.getInstance(), new ro.sync.ui.application.security.g()));
                try {
                    SandboxSecurityManagerInstaller.installSecurityManagerStrict((SystemPropertyPermissionChecker)new e(), (boolean)true);
                }
                catch (JreNotSupportingSecurityManagerException jreNotSupportingSecurityManagerException) {
                    logger.error((Object)jreNotSupportingSecurityManagerException, (Throwable)jreNotSupportingSecurityManagerException);
                    initializationFatalError = JavaVersion.V_24.isCurrentVersionOrNewer() ? "SecurityManager initialization failed because the current JRE doesn't support it. Note that starting from java 24 SecurityManager isn't supported. Please ensure that the application is running with a supported JRE version." : "SecurityManager initialization failed because the current JRE doesn't support it. Please ensure that the application is running with a supported JRE version.";
                }
                catch (IOException iOException) {
                    logger.error((Object)iOException, (Throwable)iOException);
                    initializationFatalError = "SecurityManager initialization failed because of an IO error. Please see server logs for more details.";
                }
                TemporaryFilesFactory.storeConfidentialFilesAsEncrypted();
                System.setProperty("jna.platform.library.path", "");
                Installer.inhibitInstallProtocols();
                lf.h(new ro.sync.net.protocol.d());
                wc.d();
                ro.sync.exml.v.setInstance(new bb());
                WebappAuthorDocumentFactory.initFrameworksSupport();
                WebappAuthorDocumentFactory.initCatalogDebugging();
                p.b().initTrueZIPLibrary();
                WebappAuthorDocumentFactory.initEditorVariables();
                new ro.sync.ecss.webapp.plugin.b().b();
                new v().h();
                j.b(new f());
                ImageIO.setUseCache(false);
                ((ro.sync.i18n.c)r.m()).c();
                ro.sync.net.protocol.http.f.i();
                EncryptionKey.getInstance();
                WebappAuthorDocumentFactory.forceJnaLoading();
                ro.sync.util.c.f.h(new ro.sync.util.c.d());
                ub.n(new ro.sync.ecss.webapp.m.c());
                WebappAuthorDocumentFactory.registerReferenceCollectorFactory();
            }
            finally {
                StaticComponentsRegistry.close();
            }
        }
    }

    public static Optional<String> getInitializationFatalError() {
        return Optional.ofNullable(initializationFatalError);
    }

    private static void initFrameworksSupport() {
        DocbookAccess.setDocbookAccessCustomizer(null);
        DITAAccess.setDitaAccessCustomizer(null);
        ro.sync.ecss.dita.f.c();
    }

    private static void registerReferenceCollectorFactory() {
        WebappReferenceCollectorFactory webappReferenceCollectorFactory = new WebappReferenceCollectorFactory();
        StaticComponentsRegistry.register((String)"REFERENCE_COLLECTOR_FACTORY", (Object)webappReferenceCollectorFactory);
    }

    private static void forceJnaLoading() {
        try {
            Native.isProtected();
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            logger.error("Could not load JNA - some features will be disabled", (Throwable)unsatisfiedLinkError);
        }
    }

    private static void initCatalogDebugging() {
        ib ib2 = new ib();
        CatalogResolverFactory.setListener(ib2);
        ib2.eh(new s(){

            @Override
            public void addMessageResult(String string, DocumentPositionedInfo documentPositionedInfo, lg lg2, boolean bl, boolean bl2) {
                logger.info("CATALOG: [{}][{}] - ", (Object)lg2, (Object)documentPositionedInfo.getMessage());
            }
        });
    }

    private static void setBundleDescriptor() {
        String string = System.getProperty("com.oxygenxml.bundle.descriptor");
        if (!("web-author".equals(string) || "webapp".equals(string) || "content-fusion".equals(string))) {
            System.setProperty("com.oxygenxml.bundle.descriptor", "webapp");
        }
    }

    public static void dispose() {
        new v().c();
        SandboxSecurityManagerInstaller.restoreSecurityManager();
        List<d> list = WebappAuthorDocumentFactory.getOptionsListeners();
        for (d d2 : list) {
            Options.getInstance().removePropertyListener(d2);
        }
    }

    private static void initEditorVariables() {
        EditorVariables.setArchiveExtensionsRecognizer(new ro.sync.exml.zip.j());
        EditorVariables.setXpathEvaluator(g.d(new ro.sync.ecss.webapp.g()));
        EditorVariables.setFrameworkLocationResolver(string -> DocumentTypeRepository.getInstance().getDocumentTypeLocation(string));
        EditorVariables.setRootMapResolver(DITAAccess::getRootMapURL);
        EditorVariables.setPluginLocationResolver(string -> PluginManager.getInstance().getPluginFolderLocation(string));
    }

    public static DITAMapDocumentModel createDITAMapDocumentInfo(String string, Reader reader, Map<String, ?> map) throws IOException, SAXException {
        URL uRL = new URL(string);
        return WebappAuthorDocumentFactory.createDITAMapDocumentInfo(uRL, reader, Collections.emptyList(), map);
    }

    public static DITAMapDocumentModel createDITAMapDocumentInfo(String string, Map<String, ?> map) throws IOException, SAXException {
        return (DITAMapDocumentModel)WebappAuthorDocumentFactory.createAuthorDocumentInfoInternal(string, map, new InternalDITAMapDocumentBuilder());
    }

    static {
        initialized = false;
        initializationFatalError = null;
    }
}

