/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.ecss.extensions.api.node;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.sync.annotations.api.API;
import ro.sync.annotations.api.APIType;
import ro.sync.annotations.api.SourceType;

@API(type=APIType.EXTENDABLE, src=SourceType.PUBLIC)
public class AttrValue {
    private static final Logger logger = LoggerFactory.getLogger((String)AttrValue.class.getName());
    public static final AttrValue EMPTY_VALUE = new AttrValue("");
    private final String normalizedValue;
    private final String rawValue;
    private final boolean isSpecified;

    public AttrValue(String string) {
        this(string, string, true);
    }

    public AttrValue(String string, String string2, boolean bl) {
        if (string2 != null && string2.indexOf(34) != -1) {
            string2 = string2.replace("\"", "&quot;");
        }
        if (string == null) {
            logger.warn("NULL value set to Normalized AttrValue", (Throwable)new Exception());
            string = "";
        }
        if (string2 == null) {
            logger.warn("NULL value set to Raw AttrValue", (Throwable)new Exception());
            string2 = "";
        }
        this.normalizedValue = string;
        this.rawValue = string2;
        this.isSpecified = bl;
    }

    public String getValue() {
        return this.normalizedValue;
    }

    public String getRawValue() {
        return this.rawValue;
    }

    public boolean isSpecified() {
        return this.isSpecified;
    }

    public String toString() {
        return "Attribute value: " + this.getValue();
    }

    public boolean equals(Object object) {
        if (object instanceof AttrValue) {
            return ((AttrValue)object).getValue().equals(this.getValue());
        }
        return super.equals(object);
    }

    public int hashCode() {
        return this.normalizedValue.hashCode() + (this.isSpecified ? 1 : 0);
    }
}

