/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.ecss.dom.wrappers.mutable;

import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Properties;
import javax.xml.transform.Result;
import javax.xml.transform.stream.StreamResult;
import net.sf.saxon.Configuration;
import net.sf.saxon.event.Builder;
import net.sf.saxon.event.PipelineConfiguration;
import net.sf.saxon.event.Receiver;
import net.sf.saxon.expr.parser.Loc;
import net.sf.saxon.lib.SerializerFactory;
import net.sf.saxon.om.AttributeInfo;
import net.sf.saxon.om.AttributeMap;
import net.sf.saxon.om.MutableNodeInfo;
import net.sf.saxon.om.NameOfNode;
import net.sf.saxon.om.NamespaceBinding;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.NodeName;
import net.sf.saxon.s9api.Location;
import net.sf.saxon.serialize.SerializationProperties;
import net.sf.saxon.str.UnicodeString;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.linked.LinkedTreeBuilder;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.SchemaType;
import net.sf.saxon.type.SimpleType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Attr;
import org.w3c.dom.Node;
import org.w3c.dom.ProcessingInstruction;
import ro.sync.basic.util.Equaler;
import ro.sync.basic.xml.BasicXmlUtil;
import ro.sync.basic.xml.UnescapeWriter;
import ro.sync.ecss.dom.wrappers.AuthorAttrDomWrapper;
import ro.sync.ecss.dom.wrappers.AuthorDocumentDomWrapper;
import ro.sync.ecss.dom.wrappers.AuthorNodeDomWrapper;
import ro.sync.ecss.dom.wrappers.AuthorTextNodeDomWrapper;
import ro.sync.ecss.dom.wrappers.mutable.DOMNodeWrapper;
import ro.sync.ecss.dom.wrappers.mutable.DocumentWrapper;
import ro.sync.ecss.dom.wrappers.mutable.MutableNodeModelBuilder;
import ro.sync.ecss.extensions.api.AuthorDocumentController;
import ro.sync.ecss.extensions.api.AuthorOperationException;
import ro.sync.ecss.extensions.api.node.AttrValue;
import ro.sync.ecss.extensions.api.node.AuthorElement;
import ro.sync.ecss.extensions.api.node.AuthorNode;
import ro.sync.ecss.extensions.api.node.NamespaceContext;

public class MutableDOMNodeWrapper
extends DOMNodeWrapper
implements MutableNodeInfo {
    private static final Logger logger = LoggerFactory.getLogger((String)MutableDOMNodeWrapper.class.getName());
    private Boolean deleted;
    String newAttrName = null;

    protected MutableDOMNodeWrapper(Node node, DocumentWrapper documentWrapper, DOMNodeWrapper dOMNodeWrapper, int n2) {
        super(node, documentWrapper, dOMNodeWrapper, n2);
    }

    @Override
    protected DOMNodeWrapper makeWrapper(Node node, DocumentWrapper documentWrapper, DOMNodeWrapper dOMNodeWrapper, int n2) {
        return MutableNodeModelBuilder.makeWrapper(node, documentWrapper, dOMNodeWrapper, n2);
    }

    public void setNodeKind(short s2) {
        this.nodeKind = s2;
    }

    public void removeTypeAnnotation() {
    }

    public void insertChildren(NodeInfo[] nodeInfoArray, boolean bl, boolean bl2) {
        if (logger.isDebugEnabled()) {
            logger.debug("insertChildren  " + Arrays.asList(nodeInfoArray));
        }
        if (this.node.getNodeType() == 1 || this.node.getNodeType() == 9) {
            try {
                String string = this.serializeAsXML(nodeInfoArray);
                AuthorDocumentController authorDocumentController = this.getController();
                int[] nArray = this.getNodeOffsets();
                int n2 = nArray[0] + 1;
                if (!bl) {
                    n2 = nArray[1];
                }
                authorDocumentController.insertXMLFragment(string, n2);
            }
            catch (XPathException | AuthorOperationException throwable) {
                throw new IllegalStateException("Failed", throwable);
            }
        }
    }

    public void insertSiblings(NodeInfo[] nodeInfoArray, boolean bl, boolean bl2) {
        if (logger.isDebugEnabled()) {
            logger.debug("insertSiblings " + Arrays.asList(nodeInfoArray));
        }
        if ((this.node.getNodeType() == 1 || this.node.getNodeType() == 3 || this.node.getNodeType() == 8 || this.node.getNodeType() == 7) && this.node.getParentNode() != null) {
            int[] nArray = this.getNodeOffsets();
            try {
                String string = this.serializeAsXML(nodeInfoArray);
                AuthorDocumentController authorDocumentController = this.getController();
                int n2 = nArray[0];
                if (!bl) {
                    n2 = nArray[1] + 1;
                }
                authorDocumentController.insertXMLFragment(string, n2);
            }
            catch (XPathException | AuthorOperationException throwable) {
                throw new IllegalStateException("Failed: " + throwable.getMessage(), throwable);
            }
        }
    }

    public void removeAttribute(NodeInfo nodeInfo) {
        if (logger.isDebugEnabled()) {
            logger.debug("remove @" + nodeInfo);
        }
        if (this.node.getNodeType() == 1) {
            AuthorDocumentController authorDocumentController = this.getController();
            AuthorElement authorElement = (AuthorElement)this.getAuthorNode();
            int n2 = MutableDOMNodeWrapper.getAttributeIndex(nodeInfo, authorElement);
            authorDocumentController.removeAttribute(authorElement.getAttributeAtIndex(n2), authorElement);
        } else {
            logger.warn("Unexpected remove attribute " + nodeInfo + " on " + this);
        }
    }

    private static int getAttributeIndex(NodeInfo nodeInfo, AuthorElement authorElement) {
        String string = nodeInfo.getLocalPart();
        String string2 = nodeInfo.getURI();
        int n2 = authorElement.getAttributesCount();
        int n3 = -1;
        for (int i2 = 0; i2 < n2; ++i2) {
            String string3 = authorElement.getAttributeAtIndex(i2);
            String string4 = BasicXmlUtil.getProxy((String)string3);
            String string5 = BasicXmlUtil.getLocalName((String)string3);
            String string6 = authorElement.getAttributeNamespace(string4);
            if (!Equaler.verifyEquals((Object)string5, (Object)string) || !Equaler.verifyEquals((Object)string2, (Object)string6)) continue;
            n3 = i2;
            break;
        }
        return n3;
    }

    public void setAttributes(AttributeMap attributeMap) {
        int n2;
        AuthorDocumentController authorDocumentController = this.getController();
        AuthorElement authorElement = (AuthorElement)this.getAuthorNode();
        int n3 = authorElement.getAttributesCount();
        ArrayList<String> arrayList = new ArrayList<String>();
        for (n2 = 0; n2 < n3; ++n2) {
            String string = authorElement.getAttributeAtIndex(n2);
            arrayList.add(string);
        }
        for (n2 = 0; n2 < arrayList.size(); ++n2) {
            authorDocumentController.removeAttribute((String)arrayList.get(n2), authorElement);
        }
        if (attributeMap != null) {
            n2 = attributeMap.size();
            for (int i2 = 0; i2 < n2; ++i2) {
                AttributeInfo attributeInfo = attributeMap.itemAt(i2);
                this.addAttribute(attributeInfo.getNodeName(), null, attributeInfo.getValue(), 0, true);
            }
        }
    }

    public void addAttribute(NodeName nodeName, SimpleType simpleType, String string, int n2, boolean bl) {
        if (logger.isDebugEnabled()) {
            logger.debug("add @" + nodeName.getLocalPart() + " in " + this);
        }
        this.defineNamespace(nodeName, true);
        AuthorDocumentController authorDocumentController = this.getController();
        String string2 = MutableDOMNodeWrapper.getQName(nodeName);
        authorDocumentController.setAttribute(string2, new AttrValue(String.valueOf(string)), (AuthorElement)((AuthorNodeDomWrapper)this.node).getWrappedAuthorNode());
    }

    public void delete() {
        if (logger.isDebugEnabled()) {
            logger.debug("delete " + this);
        }
        this.deleted = true;
        if (this.nodeKind == 2) {
            MutableDOMNodeWrapper mutableDOMNodeWrapper = (MutableDOMNodeWrapper)this.getParent();
            AuthorDocumentController authorDocumentController = this.getController();
            authorDocumentController.removeAttribute(this.node.getNodeName(), (AuthorElement)((AuthorNodeDomWrapper)mutableDOMNodeWrapper.node).getWrappedAuthorNode());
        } else {
            AuthorDocumentController authorDocumentController = this.getController();
            int[] nArray = this.getNodeOffsets();
            authorDocumentController.delete(nArray[0], nArray[1]);
        }
    }

    private AuthorDocumentController getController() {
        AuthorNodeDomWrapper authorNodeDomWrapper = (AuthorNodeDomWrapper)this.node;
        if (this.nodeKind == 2) {
            authorNodeDomWrapper = (AuthorNodeDomWrapper)((MutableDOMNodeWrapper)this.getParent()).node;
        }
        AuthorDocumentDomWrapper authorDocumentDomWrapper = (AuthorDocumentDomWrapper)authorNodeDomWrapper.getOwnerDocument();
        return authorDocumentDomWrapper.getController();
    }

    public boolean isDeleted() {
        if (this.deleted == null) {
            if (this.getNodeKind() == 2) {
                String string;
                AuthorElement authorElement = (AuthorElement)this.getAuthorNode();
                this.deleted = authorElement.getAttribute(string = this.getRenameAwareAttributeName((Attr)this.node)) != null;
            } else {
                AuthorNode authorNode = this.getAuthorNode();
                boolean bl = authorNode.getStartOffset() == authorNode.getEndOffset() || authorNode.getOwnerDocument() == null;
                this.deleted = bl;
            }
        }
        if (logger.isDebugEnabled()) {
            logger.debug("Is deleted " + this + " ? " + this.deleted);
        }
        return this.deleted;
    }

    public void replace(NodeInfo[] nodeInfoArray, boolean bl) {
        if (this.isDeleted()) {
            throw new IllegalStateException("Cannot replace a deleted node");
        }
        if (this.node.getNodeType() == 2) {
            MutableNodeInfo mutableNodeInfo = (MutableNodeInfo)this.getParent();
            this.delete();
            for (NodeInfo nodeInfo : nodeInfoArray) {
                if (nodeInfo.getNodeKind() != 2) {
                    throw new IllegalArgumentException("Replacement nodes must be attributes");
                }
                mutableNodeInfo.addAttribute(NameOfNode.makeName((NodeInfo)nodeInfo), (SimpleType)BuiltInAtomicType.UNTYPED_ATOMIC, nodeInfo.getStringValue(), 0, true);
            }
        } else {
            if (this.isDeleted()) {
                throw new IllegalStateException("Cannot replace a deleted node");
            }
            AuthorDocumentController authorDocumentController = this.getController();
            int[] nArray = this.getNodeOffsets();
            try {
                String string = this.serializeAsXML(nodeInfoArray);
                int n2 = nArray[0];
                int n3 = nArray[1];
                if (logger.isDebugEnabled()) {
                    logger.debug("replace " + this + " with " + string);
                    logger.debug("replace, step 1: Delete " + n2 + " , " + n3);
                }
                authorDocumentController.delete(n2, n3);
                this.deleted = true;
                if (logger.isDebugEnabled()) {
                    logger.debug("replace, step 2: Insert at " + n2);
                }
                authorDocumentController.insertXMLFragment(string, n2);
            }
            catch (XPathException | AuthorOperationException throwable) {
                throw new IllegalStateException("Failed: " + throwable.getMessage(), throwable);
            }
        }
    }

    public void replaceStringValue(UnicodeString unicodeString) {
        if (logger.isDebugEnabled()) {
            logger.debug("string replace " + unicodeString + " in " + this);
        }
        AuthorDocumentController authorDocumentController = this.getController();
        if (this.getNodeKind() == 1 || this.getNodeKind() == 8 || this.getNodeKind() == 4 || this.getNodeKind() == 7 || this.getNodeKind() == 3) {
            int[] nArray = this.getNodeOffsets();
            int n2 = nArray[0];
            int n3 = nArray[1];
            if (this.getNodeKind() == 3 || n2 + 1 < n3) {
                if (this.getNodeKind() == 3) {
                    authorDocumentController.delete(n2, n3);
                } else {
                    authorDocumentController.delete(n2 + 1, n3 - 1);
                }
            }
            Object object = "";
            if (this.getNodeKind() == 7) {
                ProcessingInstruction processingInstruction = (ProcessingInstruction)this.node;
                object = processingInstruction.getTarget() + " " + unicodeString;
            } else {
                object = MutableDOMNodeWrapper.unescapeAMP(unicodeString.toString());
            }
            if (((String)object).length() > 0) {
                if (this.getNodeKind() == 3) {
                    authorDocumentController.insertText(nArray[0], (String)object);
                } else {
                    authorDocumentController.insertText(nArray[0] + 1, (String)object);
                }
            }
        } else if (this.getNodeKind() == 2) {
            authorDocumentController.setAttribute(this.node.getNodeName(), new AttrValue(MutableDOMNodeWrapper.unescapeAMP(unicodeString.toString())), (AuthorElement)this.getAuthorNode());
        } else {
            logger.warn("Unexpected node type for replace string value: " + this);
        }
    }

    private static String unescapeAMP(CharSequence charSequence) {
        String string = String.valueOf(charSequence);
        StringWriter stringWriter = new StringWriter();
        try {
            new UnescapeWriter((Writer)stringWriter).write(string);
            string = stringWriter.toString();
        }
        catch (IOException iOException) {
            logger.error((Object)iOException, (Throwable)iOException);
        }
        return string;
    }

    public void rename(NodeName nodeName, boolean bl) {
        if (logger.isDebugEnabled()) {
            logger.debug("rename " + this + " to " + nodeName);
        }
        AuthorDocumentController authorDocumentController = this.getController();
        if (this.nodeKind == 2) {
            this.defineNamespace(nodeName, true);
            MutableDOMNodeWrapper mutableDOMNodeWrapper = (MutableDOMNodeWrapper)this.getParent();
            AuthorElement authorElement = (AuthorElement)((AuthorNodeDomWrapper)mutableDOMNodeWrapper.node).getWrappedAuthorNode();
            if (logger.isDebugEnabled()) {
                logger.debug("Parent node: " + authorElement + " to remove " + this.getLocalPart());
            }
            AuthorAttrDomWrapper authorAttrDomWrapper = (AuthorAttrDomWrapper)this.node;
            authorDocumentController.removeAttribute(this.getRenameAwareAttributeName(authorAttrDomWrapper), authorElement);
            authorDocumentController.setAttribute(MutableDOMNodeWrapper.getQName(nodeName), new AttrValue(this.getStringValue()), authorElement);
            this.newAttrName = MutableDOMNodeWrapper.getQName(nodeName);
        } else if (this.nodeKind == 1) {
            this.defineNamespace(nodeName, false);
            Object object = nodeName.getLocalPart();
            String string = nodeName.getURI();
            if (string != null && string.length() > 0) {
                object = nodeName.getDisplayName() + "#" + string;
            }
            authorDocumentController.renameElement((AuthorElement)this.getAuthorNode(), (String)object);
        } else if (this.nodeKind == 7) {
            int n2;
            ProcessingInstruction processingInstruction = (ProcessingInstruction)this.node;
            String string = processingInstruction.getData();
            int[] nArray = this.getNodeOffsets();
            int n3 = nArray[0];
            if (n3 + 1 < (n2 = nArray[1])) {
                authorDocumentController.delete(nArray[0] + 1, nArray[1] - 1);
            }
            authorDocumentController.insertText(n3 + 1, nodeName.getLocalPart() + " " + string);
        } else {
            logger.warn("Unexpected node type in rename: " + this);
        }
    }

    private String getRenameAwareAttributeName(Attr attr) {
        return this.newAttrName != null ? this.newAttrName : attr.getName();
    }

    private static String getQName(NodeName nodeName) {
        Object object = nodeName.getLocalPart();
        String string = nodeName.getPrefix();
        if (string != null && string.length() > 0) {
            object = string + ":" + (String)object;
        }
        return object;
    }

    private void defineNamespace(NodeName nodeName, boolean bl) {
        String string = nodeName.getPrefix();
        String string2 = nodeName.getURI();
        this.defineNamespace(bl, string, string2);
    }

    private void defineNamespace(boolean bl, String string, String string2) {
        String string3 = this.getNamespaceForPrefix(string, bl);
        if (string3 == null || !string3.equals(string2)) {
            if (string3 == null || string3.length() == 0) {
                this.addNamespaceMapping(string, string2);
            } else {
                throw new IllegalArgumentException("Namespace binding of new name conflicts with existing namespace binding, new NS " + string2 + " old " + string3);
            }
        }
    }

    public void addNamespace(NamespaceBinding namespaceBinding, boolean bl) {
        this.defineNamespace(false, namespaceBinding.getPrefix(), namespaceBinding.getNamespaceUri().toString());
    }

    public Builder newBuilder() {
        LinkedTreeBuilder linkedTreeBuilder = new LinkedTreeBuilder(this.getRoot().getConfiguration().makePipelineConfiguration());
        linkedTreeBuilder.setAllocateSequenceNumbers(false);
        return linkedTreeBuilder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String serializeAsXML(NodeInfo[] nodeInfoArray) throws XPathException {
        Configuration configuration = this.getRoot().getConfiguration();
        PipelineConfiguration pipelineConfiguration = configuration.makePipelineConfiguration();
        SerializerFactory serializerFactory = configuration.getSerializerFactory();
        StringWriter stringWriter = new StringWriter();
        Properties properties = new Properties();
        properties.setProperty("indent", "no");
        properties.setProperty("omit-xml-declaration", "yes");
        try (Receiver receiver = serializerFactory.getReceiver((Result)new StreamResult((Writer)new UnescapeWriter((Writer)stringWriter)), new SerializationProperties(properties), pipelineConfiguration);){
            for (int i2 = 0; i2 < nodeInfoArray.length; ++i2) {
                nodeInfoArray[i2].copy(receiver, 2, (Location)Loc.NONE);
            }
        }
        return stringWriter.toString();
    }

    protected AuthorNode getAuthorNode() {
        Node node = this.node;
        if (this.nodeKind == 2) {
            MutableDOMNodeWrapper mutableDOMNodeWrapper = (MutableDOMNodeWrapper)this.getParent();
            node = mutableDOMNodeWrapper.node;
        }
        return ((AuthorNodeDomWrapper)node).getWrappedAuthorNode();
    }

    private int[] getNodeOffsets() {
        AuthorNode authorNode = this.getAuthorNode();
        int n2 = authorNode.getStartOffset();
        int n3 = authorNode.getEndOffset();
        if (this.node.getNodeType() == 3) {
            n2 = ((AuthorTextNodeDomWrapper)this.node).getStart();
            n3 = ((AuthorTextNodeDomWrapper)this.node).getEnd();
        }
        return new int[]{n2, n3};
    }

    private String getNamespaceForPrefix(String string, boolean bl) {
        AuthorNode authorNode = this.getAuthorNode();
        NamespaceContext namespaceContext = authorNode.getNamespaceContext();
        if (string == null) {
            string = "";
        }
        String string2 = "";
        if (!bl || string.length() > 0) {
            string2 = namespaceContext.getNamespaceForPrefix(string);
        }
        if (string.length() == 0 && string2 == null) {
            string2 = "";
        }
        return string2;
    }

    private void addNamespaceMapping(String string, String string2) {
        AuthorNode authorNode = this.getAuthorNode();
        if (authorNode.getType() == 0) {
            AuthorDocumentController authorDocumentController = this.getController();
            Object object = "xmlns";
            if (string != null && string.length() > 0) {
                object = "xmlns:" + string;
            }
            authorDocumentController.setAttribute((String)object, new AttrValue(string2), (AuthorElement)authorNode);
        }
    }

    public String toString() {
        AuthorNodeDomWrapper authorNodeDomWrapper = (AuthorNodeDomWrapper)this.node;
        AuthorNode authorNode = authorNodeDomWrapper.getWrappedAuthorNode();
        StringBuilder stringBuilder = new StringBuilder();
        if (this.nodeKind == 2) {
            stringBuilder.append("@").append(this.getLocalPart());
        } else {
            stringBuilder.append("'").append(authorNode.toString().replace('\u0000', 'X')).append("'");
            stringBuilder.append(" ").append(authorNode.getClass());
        }
        return stringBuilder.toString();
    }

    public void setTypeAnnotation(SchemaType schemaType) {
    }

    public void setTreeInfo(DocumentWrapper documentWrapper) {
        this.treeInfo = documentWrapper;
    }
}

