/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.ecss.dita.reference.keyref;

import java.net.URL;
import java.util.LinkedHashMap;
import java.util.Map;
import ro.sync.annotations.api.API;
import ro.sync.annotations.api.APIType;
import ro.sync.annotations.api.SourceType;
import ro.sync.annotations.obfuscate.SkipLevel;
import ro.sync.annotations.obfuscate.SkipObfuscate;
import ro.sync.basic.util.Equaler;
import ro.sync.basic.util.URLUtil;
import ro.sync.basic.xml.BasicXmlUtil;
import ro.sync.basic.xml.UnescapeParseException;
import ro.sync.exml.workspace.api.editor.page.ditamap.keys.MetaContentProvider;

@API(type=APIType.INTERNAL, src=SourceType.PRIVATE)
@SkipObfuscate(classes=SkipLevel.PRIVATE, fields=SkipLevel.PRIVATE, methods=SkipLevel.PRIVATE)
public class KeyInfo
implements Comparable<KeyInfo> {
    private final String keyName;
    private String hrefValue;
    private final String keyrefValue;
    private URL hrefLocation;
    private String navTitle;
    private URL definitionLocation;
    private MetaContentProvider metaContentProvider;
    private LinkedHashMap<String, String> attributes;
    private Boolean locktitle;
    private boolean isDefinedInPeerMap;
    private boolean isRelative = false;
    private String originalKeyName;
    private String originalQualifiedKeyName;
    private static final BasicXmlUtil.UnescapeSelectionOptions DESCRIPTION_UNESCAPE_OPTS = new BasicXmlUtil.UnescapeSelectionOptions(true, true, true, true, true, false);

    public KeyInfo(String string, String string2, String string3, URL uRL, URL uRL2, String string4, Boolean bl) {
        this.keyName = string;
        this.hrefValue = string2;
        this.keyrefValue = string3;
        this.hrefLocation = uRL;
        this.navTitle = string4;
        this.definitionLocation = uRL2;
        this.locktitle = bl;
    }

    public Boolean getLocktitle() {
        return this.locktitle;
    }

    public void setLocktitle(Boolean bl) {
        this.locktitle = bl;
    }

    public int hashCode() {
        return this.keyName.hashCode();
    }

    public boolean equals(Object object) {
        if (object instanceof KeyInfo) {
            return this.keyName.equals(((KeyInfo)object).keyName);
        }
        return false;
    }

    public URL getHrefLocation() {
        return this.hrefLocation;
    }

    public URL getDefinitionLocation() {
        return this.definitionLocation;
    }

    public String getHrefValue() {
        return this.hrefValue;
    }

    public String getKeyName() {
        return this.keyName;
    }

    public String getNavTitle() {
        return this.navTitle;
    }

    public String getKeyrefValue() {
        return this.keyrefValue;
    }

    public void setHrefLocation(URL uRL) {
        this.hrefLocation = uRL;
    }

    public void setHrefValue(String string) {
        this.hrefValue = string;
    }

    public void setNavTitle(String string) {
        this.navTitle = string;
    }

    public String toString() {
        return "Key: '" + this.keyName + "', Href: '" + URLUtil.filterPasswords((String)this.hrefValue) + "', URL: '" + URLUtil.filterPasswords((String)String.valueOf(this.hrefLocation)) + "'";
    }

    public void setMetaContentProvider(MetaContentProvider metaContentProvider) {
        this.metaContentProvider = metaContentProvider;
    }

    public MetaContentProvider getMetaContentProvider() {
        return this.metaContentProvider;
    }

    public void setAttribute(String string, String string2) {
        if (this.attributes == null) {
            this.attributes = new LinkedHashMap();
        }
        this.attributes.put(string, string2);
    }

    public Map<String, String> getAttributes() {
        return this.attributes;
    }

    public void setDefinedInPeerMap(boolean bl) {
        this.isDefinedInPeerMap = bl;
    }

    public boolean isDefinedInPeerMap() {
        return this.isDefinedInPeerMap;
    }

    public String getDescription() {
        Object object = this.getNavTitle();
        if ((object == null || ((String)object).isEmpty()) && this.metaContentProvider != null) {
            object = this.metaContentProvider.getContent(" topic/keyword ");
        }
        if (object != null) {
            try {
                object = BasicXmlUtil.unescape((String)object, (BasicXmlUtil.UnescapeSelectionOptions)DESCRIPTION_UNESCAPE_OPTS);
            }
            catch (UnescapeParseException unescapeParseException) {
                // empty catch block
            }
        }
        if (this.isDefinedInPeerMap) {
            if (object == null) {
                object = "";
            }
            object = "[Peer] " + (String)object;
        }
        return object;
    }

    protected KeyInfo getRelativeKey(String string) {
        KeyInfo keyInfo = new KeyInfo(string, this.hrefValue, this.keyrefValue, this.hrefLocation, this.definitionLocation, this.navTitle, this.locktitle);
        keyInfo.setMetaContentProvider(this.metaContentProvider);
        keyInfo.setDefinedInPeerMap(this.isDefinedInPeerMap);
        keyInfo.setIsRelative(true);
        return keyInfo;
    }

    private void setIsRelative(boolean bl) {
        this.isRelative = bl;
    }

    public boolean isRelative() {
        return this.isRelative;
    }

    @Override
    public int compareTo(KeyInfo keyInfo) {
        String string;
        String string2 = string = keyInfo != null ? keyInfo.getKeyName() : null;
        if (this.keyName != null) {
            int n2 = this.keyName.compareToIgnoreCase(string);
            if (n2 == 0) {
                n2 = this.keyName.compareTo(string);
            }
            return n2;
        }
        if (string != null) {
            return -1;
        }
        return 0;
    }

    public boolean perfectlyEquals(KeyInfo keyInfo) {
        boolean bl = this.equals(keyInfo);
        if (bl) {
            bl = Equaler.verifyEquals((Object)this.getDescription(), (Object)keyInfo.getDescription()) && Equaler.verifyEquals((Object)this.getHrefValue(), (Object)keyInfo.getHrefValue()) && Equaler.verifyEquals((Object)this.getDefinitionLocation(), (Object)keyInfo.getDefinitionLocation()) && Equaler.verifyMapEquals(this.getAttributes(), keyInfo.getAttributes()) && Equaler.verifyEquals((Object)this.getMetaContentProvider(), (Object)keyInfo.getMetaContentProvider());
        }
        return bl;
    }

    public void setOriginalNotKeyScopedKeyName(String string) {
        this.originalKeyName = string;
    }

    public String getOriginalNotKeyScopedKeyName() {
        return this.originalKeyName;
    }

    public void setOriginalQualifiedKeyName(String string) {
        this.originalQualifiedKeyName = string;
    }

    public String getOriginalQualifiedKeyName() {
        return this.originalQualifiedKeyName;
    }
}

