/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.ecss.component;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.sync.annotations.obfuscate.SkipLevel;
import ro.sync.annotations.obfuscate.SkipObfuscate;
import ro.sync.options.InvalidPersistentObjException;
import ro.sync.options.PersistentObject;

@SkipObfuscate(classes=SkipLevel.PRIVATE, fields=SkipLevel.PRIVATE, methods=SkipLevel.PRIVATE)
public class AuthorSchemaAwareOptions
implements PersistentObject {
    private static final Logger logger = LoggerFactory.getLogger((String)AuthorSchemaAwareOptions.class.getName());
    public static final String SCHEMA_AWARE_EDITING_ON = "schema_aware_editing_on";
    public static final String SCHEMA_AWARE_EDITING_OFF = "schema_aware_editing_off";
    public static final String SCHEMA_AWARE_EDITING_CUSTOM = "schema_aware_editing_custom";
    public static final PersistentObject DEFAULT = AuthorSchemaAwareOptions.createDefault();
    public static final PersistentObject OFF_SCHEMA_AWARE_EDITING_CUSTOM = new AuthorSchemaAwareOptions("schema_aware_editing_off");
    private boolean isVerifyDeleteElementTagsAction = true;
    private boolean enableSmartDelete = true;
    private boolean isVerifyPasteAndDNDAction = true;
    private boolean enableSmartPaste = true;
    private boolean isVerifyTypingAction = true;
    private boolean enableSmartTyping = true;
    private boolean insertOnlyElemensFromCCList = true;
    private boolean insertOnlyAttributeValuesFromCCList = true;
    private boolean showAllPossibleElementsInCCList = true;
    private boolean isVerifyJoinAction = true;
    private String schemaAwareEditingMode = "schema_aware_editing_on";
    private boolean isVerifyUnwrapAction = true;
    private boolean showAvailableCCItemsOnEnter = true;

    public AuthorSchemaAwareOptions() {
    }

    private static PersistentObject createDefault() {
        AuthorSchemaAwareOptions authorSchemaAwareOptions = new AuthorSchemaAwareOptions(SCHEMA_AWARE_EDITING_CUSTOM);
        authorSchemaAwareOptions.setEnableSmartDelete(true);
        authorSchemaAwareOptions.setEnableSmartPaste(true);
        authorSchemaAwareOptions.setEnableSmartTyping(true);
        authorSchemaAwareOptions.setInsertOnlyElemensFromCCList(true);
        authorSchemaAwareOptions.setInsertOnlyAttrValuesFromCCList(true);
        authorSchemaAwareOptions.setShowAllPossibleElementsInCCList(true);
        authorSchemaAwareOptions.setVerifyDeleteTagsAction(true);
        authorSchemaAwareOptions.setVerifyJoinAction(true);
        authorSchemaAwareOptions.setVerifyTypingAction(true);
        authorSchemaAwareOptions.setVerifyUnwrapAction(true);
        authorSchemaAwareOptions.setVerifyPasteAndDNDAction(false);
        return authorSchemaAwareOptions;
    }

    private AuthorSchemaAwareOptions(String string) {
        this.schemaAwareEditingMode = string;
    }

    public String getSchemaAwareEditingMode() {
        return this.schemaAwareEditingMode;
    }

    public void setSchemaAwareEditingMode(String string) {
        this.schemaAwareEditingMode = string;
    }

    public void setVerifyDeleteTagsAction(boolean bl) {
        this.isVerifyDeleteElementTagsAction = bl;
    }

    public boolean isVerifyDeleteElementTagsAction() {
        return SCHEMA_AWARE_EDITING_ON.equals(this.schemaAwareEditingMode) || SCHEMA_AWARE_EDITING_CUSTOM.equals(this.schemaAwareEditingMode) && this.isVerifyDeleteElementTagsAction;
    }

    public void setEnableSmartDelete(boolean bl) {
        this.enableSmartDelete = bl;
    }

    public boolean isEnableSmartDelete() {
        return SCHEMA_AWARE_EDITING_ON.equals(this.schemaAwareEditingMode) || SCHEMA_AWARE_EDITING_CUSTOM.equals(this.schemaAwareEditingMode) && this.enableSmartDelete;
    }

    public void setVerifyPasteAndDNDAction(boolean bl) {
        this.isVerifyPasteAndDNDAction = bl;
    }

    public boolean isVerifyPasteAndDNDAction() {
        return SCHEMA_AWARE_EDITING_ON.equals(this.schemaAwareEditingMode) || SCHEMA_AWARE_EDITING_CUSTOM.equals(this.schemaAwareEditingMode) && this.isVerifyPasteAndDNDAction;
    }

    public void setEnableSmartPaste(boolean bl) {
        this.enableSmartPaste = bl;
    }

    public boolean isEnableSmartPaste() {
        return SCHEMA_AWARE_EDITING_ON.equals(this.schemaAwareEditingMode) || SCHEMA_AWARE_EDITING_CUSTOM.equals(this.schemaAwareEditingMode) && this.enableSmartPaste;
    }

    public void setVerifyTypingAction(boolean bl) {
        this.isVerifyTypingAction = bl;
    }

    public boolean isVerifyTypingAction() {
        return SCHEMA_AWARE_EDITING_ON.equals(this.schemaAwareEditingMode) || SCHEMA_AWARE_EDITING_CUSTOM.equals(this.schemaAwareEditingMode) && this.isVerifyTypingAction;
    }

    public void setEnableSmartTyping(boolean bl) {
        this.enableSmartTyping = bl;
    }

    public boolean isEnableSmartTyping() {
        return SCHEMA_AWARE_EDITING_ON.equals(this.schemaAwareEditingMode) || SCHEMA_AWARE_EDITING_CUSTOM.equals(this.schemaAwareEditingMode) && this.enableSmartTyping;
    }

    public void setInsertOnlyElemensFromCCList(boolean bl) {
        this.insertOnlyElemensFromCCList = bl;
    }

    public boolean isInsertOnlyElemensFromCCList() {
        return SCHEMA_AWARE_EDITING_ON.equals(this.schemaAwareEditingMode) || SCHEMA_AWARE_EDITING_CUSTOM.equals(this.schemaAwareEditingMode) && this.insertOnlyElemensFromCCList;
    }

    public boolean isVerifyJoinAction() {
        return SCHEMA_AWARE_EDITING_ON.equals(this.schemaAwareEditingMode) || SCHEMA_AWARE_EDITING_CUSTOM.equals(this.schemaAwareEditingMode) && this.isVerifyJoinAction;
    }

    public void setVerifyJoinAction(boolean bl) {
        this.isVerifyJoinAction = bl;
    }

    public void setVerifyUnwrapAction(boolean bl) {
        this.isVerifyUnwrapAction = bl;
    }

    public boolean isVerifyUnwrapAction() {
        return SCHEMA_AWARE_EDITING_ON.equals(this.schemaAwareEditingMode) || SCHEMA_AWARE_EDITING_CUSTOM.equals(this.schemaAwareEditingMode) && this.isVerifyUnwrapAction;
    }

    @Override
    public void checkValid() throws InvalidPersistentObjException {
    }

    @Override
    public String[] getNotPersistentFieldNames() {
        return null;
    }

    @Override
    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            logger.error((Object)cloneNotSupportedException, (Throwable)cloneNotSupportedException);
            return null;
        }
    }

    public String toString() {
        return "AuthorSchemaAwareOptions, mode: '" + this.schemaAwareEditingMode;
    }

    public boolean isShowAllPossibleElementsInCCList() {
        return SCHEMA_AWARE_EDITING_ON.equals(this.schemaAwareEditingMode) || SCHEMA_AWARE_EDITING_CUSTOM.equals(this.schemaAwareEditingMode) && this.showAllPossibleElementsInCCList;
    }

    public void setShowAllPossibleElementsInCCList(boolean bl) {
        this.showAllPossibleElementsInCCList = bl;
    }

    public void setInsertOnlyAttrValuesFromCCList(boolean bl) {
        this.insertOnlyAttributeValuesFromCCList = bl;
    }

    public boolean isInsertOnlyAttrValuesFromCCList() {
        return SCHEMA_AWARE_EDITING_ON.equals(this.schemaAwareEditingMode) || SCHEMA_AWARE_EDITING_CUSTOM.equals(this.schemaAwareEditingMode) && this.insertOnlyAttributeValuesFromCCList;
    }

    public boolean isShowAvailableCCItemsOnEnter() {
        return this.showAvailableCCItemsOnEnter;
    }

    public void setShowAvailableCCItemsOnEnter(boolean bl) {
        this.showAvailableCCItemsOnEnter = bl;
    }
}

