/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.diff.script;

import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import ro.sync.annotations.obfuscate.SkipLevel;
import ro.sync.annotations.obfuscate.SkipObfuscate;
import ro.sync.basic.util.PlatformDetector;
import ro.sync.basic.util.URLUtil;
import ro.sync.diff.api.DiffException;
import ro.sync.diff.api.DiffOptions;
import ro.sync.diff.api.DiffPerformerFactory;
import ro.sync.diff.api.Difference;
import ro.sync.diff.api.DifferencePerformer;
import ro.sync.diff.api.DifferenceType;
import ro.sync.diff.factory.CannotHandleException;
import ro.sync.diff.merge.g;
import ro.sync.diff.script.b;
import ro.sync.diff.script.c;
import ro.sync.exml.editor.og;
import ro.sync.util.fb;
import ro.sync.xml.encoding.EncodingDetector;

@SkipObfuscate(classes=SkipLevel.NOT_SPECIFIED, fields=SkipLevel.NOT_SPECIFIED, methods=SkipLevel.PUBLIC)
public class CompareFiles {
    protected static final String[] z = new String[]{"-f1", "firstFilePath", "Mandatory argument that specifies the 1st file path (it can also be provided as a URL).\n"};
    protected static final String[] x = new String[]{"-f2", "secondFilePath", "Mandatory argument that specifies the 2nd file path (it can also be provided as a URL).\n"};
    protected static final String[] o = new String[]{"-bs", "baseFilePath", "Optional argument that specifies the path of the base file that the other two files will be compared against (it can also be provided as a URL). If present, it must appear immediately after the first two mandatory arguments.\n"};
    protected static final String[] q = new String[]{"-ct", "contentType", "Specifies the content type of the files to be compared. Possible values (based on known extensions of some of the most common file types) = \"xml\", \"dtd\", \"css\", \"rnc\", \"xquery\", \"json\", \"yaml\", \"java\", \"js\", \"c\", \"cpp\", \"pl\", \"py\", \"php\", \"sql\", \"bat\", \"sh\", \"properties\", \"txt\". The option is used to force the file handling to the specific type of file. Otherwise, the file extention is auto-detected.\n"};
    protected static final String[] j = new String[]{"-alg", "comparisonAlg", "Specifies the comparison algorithm. Possible values = \"auto\", \"chars\", \"words\", \"lines\", \"syntax_aware\", \"xml_fast\", \"xml_accurate\". Default value = \"auto\".\n"};
    protected static final String[] ab = new String[]{"-als", "algStrength", "Specifies the algorithm strength. Possible values = \"low\", \"medium\", \"high\", \"very_high\". Default value = \"medium\".\n"};
    protected static final String[] i = new String[]{"-iws", "ignoreWS", "Set to \"true\" to ignore whitespaces if differences consist only of whitespaces. Default value = \"false\".\n"};
    protected static final String[] p = new String[]{"-ipi", "ignorePI", "Set to \"true\" to ignore processing instructions (only for XML aware algorithms). Default value = \"false\".\n"};
    protected static final String[] s = new String[]{"-icm", "ignoreComments", "Set to \"true\" if comments should be ignored (only for XML aware algorithms). Default value = \"false\".\n"};
    protected static final String[] u = new String[]{"-icd", "ignoreCDATA", "Set to \"true\" to ignore CDATA in the comparison (only for XML aware algorithms). Default value = \"false\".\n"};
    protected static final String[] y = new String[]{"-idt", "ignoreDocType", "Set to \"true\" if DOCTYPE sections should be ignored (only for XML aware algorithms). Default value = \"false\".\n"};
    protected static final String[] v = new String[]{"-itn", "ignoreText", "Set to \"true\" to ignore differences in text content (only for XML aware algorithms). Default value = \"false\".\n"};
    protected static final String[] h = new String[]{"-ins", "ignoreNS", "Set to \"true\" to ignore namespaces in the comparison (only for XML aware algorithms). Default value = \"false\".\n"};
    protected static final String[] b = new String[]{"-ind", "ignoreNSDecl", "Set to \"true\" to ignore namespace declarations (only for XML aware algorithms). Default value = \"false\".\n"};
    protected static final String[] g = new String[]{"-inp", "ignorePrefixes", "Set to \"true\" to ignore prefixes in the comparison (only for XML aware algorithms). Default value = \"false\".\n"};
    protected static final String[] k = new String[]{"-iao", "ignoreAttrOrder", "Set to \"true\" to ignore the attribute order (only for XML aware algorithms). Default value = \"false\".\n"};
    protected static final String[] e = new String[]{"-iee", "ignoreExpStateForEmptyElems", "Set to \"true\" to ignore expansion state for empty elements (only for XML aware algorithms), default value = \"false\".\n"};
    protected static final String[] l = new String[]{"-enx", "XPathExprToExcludeNodes", "Specifies an XPath expression to exclude certain nodes from the comparison.\n"};
    protected static final String[] t = new String[]{"-out", "outputFormat", "Specifies the output format. Possible values = \"yaml\", \"json\", \"xml\", \"html\", \"htm\", \"html/inlineCSS\", \"htm/inlineCSS\". Default value = \"yaml\". If you choose to save/redirect the console output to a file, this argument establishes the type of the output file and its content is formatted accordingly. If you choose any of \"html\", \"html/inlineCSS\", \"htm\", or \"htm/inlineCSS\" output formats, it is recommended that you also choose to save/redirect the console to the specified HTML file to view the comparison result in your preferred browser. The 'inlineCSS' qualifier for 'html' and 'htm' values implies that the CSS-based generated HTML code is more suitable to be directly inserted in emails, as most email clients only accept inline CSS styling for HTML emails. The 'html/htm' values (with or without the 'inlineCSS' qualifier) are not considered if the \"merge\" argument is present.\n"};
    protected static final String[] d = new String[]{"-outfile", "outputFile", "Specifies the path for the output file to save the comparison results, instead of presenting them in the console. The content of the ooutput file is formatted according to the \"-out\" argument. The output file path can also be provided as a URL.\n"};
    protected static final String[] w = new String[]{"-merge", "mergeOperation", "If set to \"true\", a merge operation is invoked after the comparison. Default value = \"false\". The argument is considered only for 3-way comparisons (i.e. only if the \"baseFilePath\" argument is provided). The merge operation is similar to the same process in any versioning system. Following the comparison between the first and second files (relative to the base file), all the differences of type \"incoming\" are considered and the content of the first file is updated accordingly. If conflicting changes are detected, the merge operation is aborted and the first file remains unchanged. After the comparison and merge, a report is created that provides some details about the changes that were made.\n"};
    protected static final String[] r = new String[]{"-mergeout", "outputDirPathForMerge", "Invokes a merge operation after the comparison and also allows you to specify the output directory path for the merged file. That is, instead of directly affecting the first file that takes part in comparison (which is what happens when using only the \"-merge\" argument), a new file with the same name as the first file is created as a result of the merge operation, and it is saved in the specified directory. The path of the output directory can also be provided as a URL. This argument and the \"-merge\" argument are not dependent on each other.\n"};
    protected static final String f = "-help | --help | -h | --h";
    protected static final String n = "\n In the case of Boolean arguments, it is not necessary to provide the \"true\" value, in addition.\n Their presence in the argument list is equivalent to setting their value to \"true\",\n just as their absence from the argument list means setting their value to \"false\".\n However, constructions of the form \"bool_option true|false\" are accepted and interpreted accordingly.";
    private static final String[] c = new String[]{"outgoings", "incomings", "conflicts"};
    private static final String[] m = new String[]{"deletions", "addings", "modifications"};

    private static void n() {
        String[] stringArray;
        int n2;
        System.out.println("Script for comparing files (2-way or 3-way) using the oXygen XML Editor Diff Files Comparator\n");
        char c2 = ' ';
        String string = " = ";
        StringBuilder stringBuilder = new StringBuilder(c2);
        stringBuilder.append(z[1]).append(c2).append(x[1]).append(c2).append('[');
        stringBuilder.append('[').append(o[1]).append("] ");
        List<String[]> list = CompareFiles.g();
        for (n2 = 0; n2 < list.size(); ++n2) {
            stringArray = list.get(n2);
            stringBuilder.append(n2 > 0 ? Character.valueOf(c2) : "").append('[').append(stringArray[0]).append(c2).append(stringArray[1]).append(']');
        }
        stringBuilder.append(']').append(c2).append('[').append(f).append(']');
        System.out.println((PlatformDetector.isWin() ? "compareFiles.bat " : "sh compareFiles.sh ") + stringBuilder.toString());
        stringBuilder = new StringBuilder("\nWhere:\n");
        stringBuilder.append(c2).append(z[1]).append(string).append(z[2]);
        stringBuilder.append(c2).append(x[1]).append(string).append(x[2]);
        stringBuilder.append(c2).append(o[1]).append(string).append(o[2]);
        for (n2 = 0; n2 < list.size(); ++n2) {
            stringArray = list.get(n2);
            stringBuilder.append(c2).append(stringArray[0]).append(c2).append(stringArray[1]).append(string).append(stringArray[2]);
        }
        stringBuilder.append(c2).append(f).append(string).append("shows this help text.");
        stringBuilder.append('\n').append("\nFurther note:").append(n);
        System.out.println(stringBuilder.toString());
    }

    protected static List<String[]> g() {
        return Arrays.asList(q, j, ab, i, p, s, u, y, v, h, b, g, k, e, l, t, d, w, r);
    }

    private static Map<String, String> p(String[] stringArray) {
        HashMap<String, String> hashMap = null;
        if (stringArray.length > 1) {
            hashMap = new HashMap<String, String>();
            hashMap.put(z[0], stringArray[0]);
            hashMap.put(x[0], stringArray[1]);
            if (stringArray.length > 2) {
                hashMap.putAll(ro.sync.diff.script.b.j(stringArray, o[0], CompareFiles.g()));
            }
        }
        return hashMap;
    }

    private static void u(Map<String, String> map, boolean bl) {
        if (map == null) {
            System.err.println("ERROR: Wrong argument list. At least the file paths must be provided.\n");
            System.exit(1);
        } else if (map.size() > 2) {
            ro.sync.diff.script.b.e(map);
            ro.sync.diff.script.b.g(map, bl);
            ro.sync.diff.script.b.d(map);
            ro.sync.diff.script.b.i(map);
            CompareFiles.e(map);
            ro.sync.diff.script.b.f(map, w[0], "Merge");
        }
    }

    private static void e(Map<String, String> map) {
        if (map.get(t[0]) != null) {
            String string = map.get(t[0]).toLowerCase();
            boolean bl = false;
            if (string.startsWith("html") || string.startsWith("htm")) {
                if ("html".equals(string) || "htm".equals(string) || "html/inlinecss".equals(string) || "htm/inlinecss".equals(string)) {
                    map.put(t[0], string);
                } else if (string.startsWith("html/") || string.startsWith("htm/")) {
                    System.err.println("Qualifier for 'html' output file format option wrongly specified and therefore not considered.\n");
                    map.put(t[0], "html");
                } else {
                    bl = true;
                }
            } else if ("yaml".equals(string) || "json".equals(string) || "xml".equals(string)) {
                map.put(t[0], string);
            } else {
                bl = true;
            }
            if (bl) {
                System.err.println("Output file format option wrongly specified.");
                System.err.println("Assumed 'yaml' format by default.\n");
                map.put(t[0], "yaml");
            }
        }
    }

    protected static Reader m(URL uRL) throws _b {
        InputStreamReader inputStreamReader = null;
        if (uRL != null) {
            try {
                inputStreamReader = EncodingDetector.getInstance().createReader(uRL, null, EncodingDetector.getInstance().getJavaEncodingFromContentType(og.p(uRL.toExternalForm())), new ArrayList());
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
                throw new _b("ERROR: Cannot create reader for: " + uRL);
            }
        }
        return inputStreamReader;
    }

    private static URL l(String string) throws _b {
        URL uRL = URLUtil.convertToURL((String)string);
        if (uRL == null) {
            throw new _b("ERROR: File not found: " + string);
        }
        String string2 = uRL.getProtocol();
        if ("file".equals(string2)) {
            File file = URLUtil.getCanonicalFileFromFileUrl((URL)uRL);
            String string3 = null;
            try {
                string3 = file.getCanonicalPath();
            }
            catch (IOException iOException) {
                string3 = string;
            }
            if (!file.exists()) {
                throw new _b("ERROR: File not found: " + string3);
            }
            if (file.isDirectory()) {
                throw new _b("ERROR: Directory path specified instead of file path: " + string3);
            }
        }
        return uRL;
    }

    private static String t(DifferenceType differenceType, int[] nArray, boolean bl) {
        String string;
        if (differenceType == DifferenceType.LEFT_CHANGED) {
            nArray[0] = nArray[0] + 1;
            string = bl ? "outgoing" : "deleted";
        } else if (differenceType == DifferenceType.RIGHT_CHANGED) {
            nArray[1] = nArray[1] + 1;
            string = bl ? "incoming" : "added";
        } else {
            nArray[2] = nArray[2] + 1;
            string = bl ? "conflict" : "modified";
        }
        return string;
    }

    private static String j(List list, boolean bl, boolean bl2) {
        StringBuilder stringBuilder = new StringBuilder();
        String string = "differences";
        String string2 = "      startOffset: ";
        String string3 = "      endOffset: ";
        String string4 = ": ";
        String string5 = "\n  ";
        int n2 = list.size();
        int[] nArray = new int[3];
        stringBuilder.append(string).append(":\n").append("  diffsNo: ").append(n2);
        if (n2 > 0) {
            StringBuilder stringBuilder2 = new StringBuilder("\n  diffs:");
            for (int i2 = 0; i2 < list.size(); ++i2) {
                Difference difference = (Difference)list.get(i2);
                stringBuilder2.append("\n  - firstFile:\n");
                stringBuilder2.append(string2).append(difference.getLeftIntervalStart()).append('\n');
                stringBuilder2.append(string3).append(difference.getLeftIntervalEnd()).append('\n');
                stringBuilder2.append("    secondFile:\n");
                stringBuilder2.append(string2).append(difference.getRightIntervalStart()).append('\n');
                stringBuilder2.append(string3).append(difference.getRightIntervalEnd());
                stringBuilder2.append("\n    diffType: ");
                stringBuilder2.append(CompareFiles.t(difference.getType(), nArray, bl2));
            }
            stringBuilder.append(string5);
            stringBuilder.append(bl2 ? c[0] : m[0]);
            stringBuilder.append(string4).append(nArray[0]).append(string5);
            stringBuilder.append(bl2 ? c[1] : m[1]);
            stringBuilder.append(string4).append(nArray[1]).append(string5);
            stringBuilder.append(bl2 ? c[2] : m[2]);
            stringBuilder.append(string4).append(nArray[2]);
            stringBuilder.append(stringBuilder2.toString());
        } else if (bl) {
            stringBuilder = new StringBuilder("No ").append(string).append('.');
        }
        return stringBuilder.toString();
    }

    private static String k(List list, boolean bl) {
        StringBuilder stringBuilder = new StringBuilder("{\n  \"differences\": {\n");
        String string = "          \"startOffset\": ";
        String string2 = "          \"endOffset\": ";
        String string3 = ",\n";
        String string4 = "\n        }";
        String string5 = "{\n";
        String string6 = "\n  }\n}";
        String string7 = "        ";
        String string8 = "\n      ";
        String string9 = "\": ";
        String string10 = "\n    \"";
        int n2 = list.size();
        int[] nArray = new int[3];
        stringBuilder.append("    \"diffsNo\": ").append(n2).append(',');
        if (n2 == 0) {
            stringBuilder.append(string6);
        } else {
            StringBuilder stringBuilder2 = new StringBuilder();
            stringBuilder2.append(string3).append("    \"diffs\": [");
            for (int i2 = 0; i2 < n2; ++i2) {
                Difference difference = (Difference)list.get(i2);
                stringBuilder2.append(string8).append(string5);
                stringBuilder2.append(string7).append("\"firstFile\": ").append(string5);
                stringBuilder2.append(string).append(difference.getLeftIntervalStart()).append(string3);
                stringBuilder2.append(string2).append(difference.getLeftIntervalEnd());
                stringBuilder2.append(string4).append(string3);
                stringBuilder2.append(string7).append("\"secondFile\": ").append(string5);
                stringBuilder2.append(string).append(difference.getRightIntervalStart()).append(string3);
                stringBuilder2.append(string2).append(difference.getRightIntervalEnd());
                stringBuilder2.append(string4).append(string3);
                stringBuilder2.append(string7).append("\"diffType\": \"");
                stringBuilder2.append(CompareFiles.t(difference.getType(), nArray, bl));
                stringBuilder2.append('\"').append(string8).append('}').append(i2 < n2 - 1 ? Character.valueOf(',') : "");
            }
            stringBuilder.append(string10);
            stringBuilder.append(bl ? c[0] : m[0]);
            stringBuilder.append(string9).append(nArray[0]).append(',').append(string10);
            stringBuilder.append(bl ? c[1] : m[1]);
            stringBuilder.append(string9).append(nArray[1]).append(',').append(string10);
            stringBuilder.append(bl ? c[2] : m[2]);
            stringBuilder.append(string9).append(nArray[2]);
            stringBuilder.append(stringBuilder2.toString());
            stringBuilder.append("\n    ]").append(string6);
        }
        return stringBuilder.toString();
    }

    private static String c(List list, boolean bl) {
        StringBuilder stringBuilder = new StringBuilder();
        String string = "differences";
        String string2 = "diff>\n";
        String string3 = "firstFile>\n";
        String string4 = "secondFile>\n";
        String string5 = "diffType>";
        String string6 = "startOffset>";
        String string7 = "endOffset>";
        String string8 = "  <";
        String string9 = "    <";
        String string10 = "    </";
        String string11 = "      <";
        String string12 = "</";
        String string13 = "=\"";
        String string14 = "\" ";
        int n2 = list.size();
        int[] nArray = new int[3];
        stringBuilder.append('<').append(string).append(" diffsNo=\"").append(n2).append("\"");
        if (n2 == 0) {
            stringBuilder.append("/>");
        } else {
            StringBuilder stringBuilder2 = new StringBuilder();
            for (int i2 = 0; i2 < list.size(); ++i2) {
                Difference difference = (Difference)list.get(i2);
                stringBuilder2.append(string8).append(string2);
                stringBuilder2.append(string9).append(string3);
                stringBuilder2.append(string11).append(string6).append('>');
                stringBuilder2.append(difference.getLeftIntervalStart()).append(string12).append(string6).append('\n');
                stringBuilder2.append(string11).append(string7).append('>');
                stringBuilder2.append(difference.getLeftIntervalEnd()).append(string12).append(string7).append('\n');
                stringBuilder2.append(string10).append(string3);
                stringBuilder2.append(string9).append(string4);
                stringBuilder2.append(string11).append(string6).append('>');
                stringBuilder2.append(difference.getRightIntervalStart()).append(string12).append(string6).append('\n');
                stringBuilder2.append(string11).append(string7).append('>');
                stringBuilder2.append(difference.getRightIntervalEnd()).append(string12).append(string7).append('\n');
                stringBuilder2.append(string10).append(string4);
                stringBuilder2.append(string9).append(string5);
                stringBuilder2.append(CompareFiles.t(difference.getType(), nArray, bl));
                stringBuilder2.append(string12).append(string5).append('\n');
                stringBuilder2.append(string8).append('/').append(string2);
            }
            stringBuilder.append(' ');
            stringBuilder.append(bl ? c[0] : m[0]);
            stringBuilder.append(string13).append(nArray[0]).append(string14);
            stringBuilder.append(bl ? c[1] : m[1]);
            stringBuilder.append(string13).append(nArray[1]).append(string14);
            stringBuilder.append(bl ? c[2] : m[2]);
            stringBuilder.append(string13).append(nArray[2]).append("\">\n");
            stringBuilder.append(stringBuilder2.toString());
            stringBuilder.append(string12).append(string).append('>');
        }
        return stringBuilder.toString();
    }

    protected static String b(String[] stringArray, URL[] uRLArray) {
        try {
            String string;
            String string2;
            Map<String, String> map = CompareFiles.p(stringArray);
            URL[] uRLArray2 = CompareFiles.o(map);
            URL uRL = uRLArray2[0];
            URL uRL2 = uRLArray2[1];
            URL uRL3 = uRLArray2[2];
            URL uRL4 = uRLArray2[3];
            if (uRLArray != null) {
                uRLArray[0] = uRLArray2[4];
            }
            if ((string2 = map.get(q[0])) == null && uRL3 == null) {
                string2 = og.p(uRL.toExternalForm());
            }
            List<Difference> list = null;
            DifferencePerformer differencePerformer = DiffPerformerFactory.createDiffPerformer();
            DiffOptions diffOptions = ro.sync.diff.script.b.b(map);
            String string3 = map.get(t[0]);
            boolean bl = "html".equalsIgnoreCase(string3) || "htm".equalsIgnoreCase(string3);
            boolean bl2 = "html/inlinecss".equalsIgnoreCase(string3) || "htm/inlinecss".equalsIgnoreCase(string3);
            diffOptions.setEnableHierarchicalDiff(bl || bl2);
            list = differencePerformer.performDiff(CompareFiles.m(uRL), CompareFiles.m(uRL2), CompareFiles.m(uRL3), uRL.toExternalForm(), uRL2.toExternalForm(), uRL3 != null ? uRL3.toExternalForm() : null, string2, diffOptions, null);
            if (list != null) {
                if (uRL3 != null && (map.get(w[0]) != null && "true".equalsIgnoreCase(map.get(w[0])) || uRL4 != null)) {
                    string = CompareFiles.s(uRL, uRL2, uRL3, list, string3);
                } else if (string3 != null) {
                    if (bl || bl2) {
                        URL[] uRLArray3;
                        if (uRLArray != null) {
                            URL[] uRLArray4 = new URL[4];
                            uRLArray4[0] = uRL;
                            uRLArray4[1] = uRL2;
                            uRLArray4[2] = uRL3;
                            uRLArray3 = uRLArray4;
                            uRLArray4[3] = uRLArray[0];
                        } else {
                            URL[] uRLArray5 = new URL[3];
                            uRLArray5[0] = uRL;
                            uRLArray5[1] = uRL2;
                            uRLArray3 = uRLArray5;
                            uRLArray5[2] = uRL3;
                        }
                        string = ro.sync.diff.script.c.l(list, uRLArray3, null, true, false, bl2);
                    } else {
                        string = "yaml".equals(string3) ? CompareFiles.j(list, false, uRL3 != null) : ("json".equals(string3) ? CompareFiles.k(list, uRL3 != null) : CompareFiles.c(list, uRL3 != null));
                    }
                } else {
                    string = CompareFiles.j(list, true, uRL3 != null);
                }
            } else {
                throw new _b("ERROR: Unable to perform the comparison");
            }
            return string;
        }
        catch (IOException | DiffException | CannotHandleException | _b exception) {
            return exception.getMessage();
        }
    }

    private static URL[] o(Map<String, String> map) throws _b {
        URL uRL;
        String string = null;
        String string2 = null;
        String string3 = null;
        if (map != null) {
            string = map.get(o[0]);
            string2 = map.get(r[0]);
            string3 = map.get(d[0]);
        }
        CompareFiles.u(map, string != null);
        URL uRL2 = CompareFiles.l(map.get(z[0]));
        URL uRL3 = CompareFiles.l(map.get(x[0]));
        URL uRL4 = string != null ? CompareFiles.l(string) : null;
        URL uRL5 = uRL = string2 != null ? ro.sync.diff.script.b.l(string2, false) : null;
        if (uRL != null) {
            uRL2 = CompareFiles.h(uRL2, uRL);
        }
        URL uRL6 = string3 != null ? ro.sync.diff.script.b.l(string3, false) : null;
        return new URL[]{uRL2, uRL3, uRL4, uRL, uRL6};
    }

    private static URL h(URL uRL, URL uRL2) throws _b {
        URL uRL3 = null;
        try {
            uRL3 = URLUtil.copyURL((URL)uRL, (URL)URLUtil.convertToURL((String)(uRL2.toString() + '/' + URLUtil.extractFileName((URL)uRL))));
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            throw new _b("ERROR: Failed to prepare the output for merge results");
        }
        return uRL3;
    }

    private static String s(URL uRL, URL uRL2, URL uRL3, List list, String string) {
        boolean bl = true;
        boolean bl2 = false;
        int n2 = list.size();
        if (n2 != 0) {
            bl2 = ro.sync.diff.merge.g.b(list);
            bl = bl2 ? false : ro.sync.diff.merge.g.f(uRL, uRL2, uRL3, false, list);
        }
        return CompareFiles.i(bl, bl2, n2, string);
    }

    private static String i(boolean bl, boolean bl2, int n2, String string) {
        String string2 = "json".equals(string) ? CompareFiles.f(bl, bl2, n2) : ("xml".equals(string) ? CompareFiles.q(bl, bl2, n2) : CompareFiles.r(bl, bl2, n2));
        return string2;
    }

    private static String r(boolean bl, boolean bl2, int n2) {
        StringBuilder stringBuilder = new StringBuilder("mergeReport:\n  operationStatus: \"");
        stringBuilder.append(bl ? "OPERATION COMPLETED\"" : "OPERATION COULD NOT BE COMPLETED\"");
        if (bl) {
            stringBuilder.append("\n  changesFound: ").append(n2);
            stringBuilder.append("\n  modificationsPerformed: ").append(bl2 ? 0 : n2);
        } else {
            stringBuilder.append("\n  errorMessage: \"");
            stringBuilder.append(bl2 ? "Conflicting changes found" : "Error occurred while performing modifications");
            stringBuilder.append('\"');
        }
        return stringBuilder.toString();
    }

    private static String f(boolean bl, boolean bl2, int n2) {
        StringBuilder stringBuilder = new StringBuilder("{\n  \"mergeReport\": {\n    \"operationStatus\": \"");
        stringBuilder.append(bl ? "OPERATION COMPLETED\"" : "OPERATION COULD NOT BE COMPLETED\"");
        if (bl) {
            stringBuilder.append(",\n    \"changesFound\": ").append(n2).append(',');
            stringBuilder.append("\n    \"modificationsPerformed\": ").append(bl2 ? 0 : n2);
        } else {
            stringBuilder.append(",\n    \"errorMessage\": \"");
            stringBuilder.append(bl2 ? "Conflicting changes found" : "Error occurred while performing modifications");
            stringBuilder.append('\"');
        }
        stringBuilder.append("\n  }\n}");
        return stringBuilder.toString();
    }

    private static String q(boolean bl, boolean bl2, int n2) {
        StringBuilder stringBuilder = new StringBuilder("<mergeReport>\n  <operationStatus>");
        stringBuilder.append(bl ? "OPERATION COMPLETED\"" : "OPERATION COULD NOT BE COMPLETED\"");
        stringBuilder.append("</operationStatus>");
        if (bl) {
            stringBuilder.append("\n  <changesFound>").append(n2).append("</changesFound>");
            stringBuilder.append("\n  <modificationsPerformed>").append(bl2 ? 0 : n2);
            stringBuilder.append("</modificationsPerformed>");
        } else {
            stringBuilder.append("\n  <errorMessage>");
            stringBuilder.append(bl2 ? "Conflicting changes found" : "Error occurred while performing modifications");
            stringBuilder.append("</errorMessage>");
        }
        stringBuilder.append("\n</mergeReport>");
        return stringBuilder.toString();
    }

    protected static boolean d(String[] stringArray) {
        URL[] uRLArray = new URL[]{null};
        String string = CompareFiles.b(stringArray, uRLArray);
        boolean bl = string.startsWith("ERROR: ");
        if (bl) {
            System.err.println(string);
        } else if (uRLArray[0] != null) {
            bl = !ro.sync.diff.script.b.n(string, uRLArray[0]);
        } else {
            System.out.println(string);
        }
        bl = bl || string.contains("OPERATION COULD NOT BE COMPLETED");
        return !bl;
    }

    public static void main(String[] stringArray) {
        ro.sync.diff.script.b.c("Compare files");
        if (stringArray.length == 1 && fb.b(stringArray[0])) {
            CompareFiles.n();
            System.exit(0);
        }
        System.exit(CompareFiles.d(stringArray) ? 0 : 1);
    }

    protected static class _b
    extends Exception {
        protected static final String i = "ERROR: ";
        protected static final String b = "ERROR: File not found: ";
        protected static final String e = "ERROR: Directory path specified instead of file path: ";
        protected static final String j = "ERROR: Cannot create reader for: ";
        protected static final String g = "ERROR: Unable to perform the comparison";
        protected static final String k = "ERROR: Wrongly specified output file: ";
        protected static final String d = "ERROR: The parent directory of the specified output file does not exist: ";
        protected static final String f = "Conflicting changes found";
        protected static final String c = "Error occurred while performing modifications";
        protected static final String h = "ERROR: Failed to prepare the output for merge results";
        protected static final String l = "ERROR: Failed to generate the HTML report";

        protected _b(String string) {
            super(string);
        }
    }
}

