/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.contentcompletion;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.sync.annotations.obfuscate.SkipLevel;
import ro.sync.annotations.obfuscate.SkipObfuscate;
import ro.sync.basic.util.Equaler;
import ro.sync.contentcompletion.bb;
import ro.sync.contentcompletion.db;
import ro.sync.options.InvalidPersistentObjException;
import ro.sync.options.PersistentObject;

@SkipObfuscate(classes=SkipLevel.PRIVATE, fields=SkipLevel.PRIVATE, methods=SkipLevel.PRIVATE)
public class CTItem
implements PersistentObject {
    private static final Logger logger = LoggerFactory.getLogger((String)CTItem.class.getName());
    private String contentType;
    private String unparsedInsertString;
    private String descriptionString;
    private String renderString;
    private boolean isBuiltinTemplate;
    private boolean enabled = true;
    private String accelerator = null;

    public CTItem(String string, String string2, String string3, String string4) {
        this(string, string2, string3, string4, true);
    }

    public CTItem(String string, String string2, String string3, String string4, boolean bl) {
        this.contentType = string;
        this.renderString = string2;
        this.unparsedInsertString = string3;
        this.descriptionString = string4;
        this.enabled = bl;
    }

    public CTItem(String string, String string2, String string3, String string4, String string5, boolean bl) {
        this.contentType = string;
        this.renderString = string2;
        this.unparsedInsertString = string3;
        this.descriptionString = string4;
        this.enabled = bl;
        this.accelerator = string5;
    }

    public CTItem() {
    }

    public String getContentType() {
        return this.contentType;
    }

    public String getUnparsedInsertString() {
        return this.unparsedInsertString;
    }

    public String getDescription() {
        return this.descriptionString;
    }

    public String getRenderString() {
        return this.renderString;
    }

    public boolean hasSameNameAndContentType(CTItem cTItem) {
        boolean bl = false;
        if (this.renderString.equals(cTItem.renderString) && this.getContentType().equals(cTItem.getContentType())) {
            bl = true;
        }
        return bl;
    }

    public boolean equals(Object object) {
        if (!(object instanceof CTItem)) {
            return false;
        }
        CTItem cTItem = (CTItem)object;
        return this.renderString.equals(cTItem.renderString) && this.contentType.equals(cTItem.contentType) && this.descriptionString.equals(cTItem.descriptionString) && this.unparsedInsertString.equals(cTItem.unparsedInsertString) && Equaler.verifyEquals((Object)cTItem.getAccelerator(), (Object)this.accelerator);
    }

    public int hashCode() {
        int n2 = 1;
        if (this.renderString != null) {
            n2 += this.renderString.hashCode();
        }
        if (this.contentType != null) {
            n2 += this.contentType.hashCode();
        }
        return n2;
    }

    public String toString() {
        return "[ContentType:" + this.contentType + ", RenderString:" + this.renderString + ", UnparsedString:" + this.unparsedInsertString + ", description:" + this.descriptionString + ", keystroke:" + this.accelerator + "]" + super.toString();
    }

    public db toCCItem() {
        String string = this.unparsedInsertString;
        return new bb(2, this.renderString, string, this.descriptionString + "\n\n" + string, -1, 14);
    }

    public void setContentType(String string) {
        this.contentType = string;
    }

    public void setUnparsedInsertString(String string) {
        this.unparsedInsertString = string;
    }

    public void setRenderString(String string) {
        this.renderString = string;
    }

    public void setDescription(String string) {
        this.descriptionString = string;
    }

    @Override
    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            logger.error((Object)cloneNotSupportedException, (Throwable)cloneNotSupportedException);
            return null;
        }
    }

    @Override
    public void checkValid() throws InvalidPersistentObjException {
        if (this.contentType == null) {
            throw new InvalidPersistentObjException("null contentType for CTItem");
        }
        if (this.descriptionString == null) {
            throw new InvalidPersistentObjException("null descriptionString for CTItem");
        }
        if (this.unparsedInsertString == null) {
            throw new InvalidPersistentObjException("null unparsedInsertString for CTItem");
        }
        if (this.renderString == null) {
            throw new InvalidPersistentObjException("null name for CTItem");
        }
    }

    @Override
    public String[] getNotPersistentFieldNames() {
        return new String[]{"isBuiltinTemplate"};
    }

    public void setBuiltinTemplate(boolean bl) {
        this.isBuiltinTemplate = bl;
    }

    public boolean isBuiltinTemplate() {
        return this.isBuiltinTemplate;
    }

    public void setEnabled(boolean bl) {
        this.enabled = bl;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public String getAccelerator() {
        return this.accelerator;
    }
}

