/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.serialize;

import java.io.IOException;
import net.sf.saxon.serialize.charcode.UTF16CharacterSet;
import net.sf.saxon.str.StringTool;
import net.sf.saxon.str.UnicodeString;
import net.sf.saxon.str.UnicodeWriter;

public class UnescapeUnicodeWriter
implements UnicodeWriter {
    private UnicodeWriter unicodeWriter;
    private int ignore;
    private static final char[] AMP = new char[]{'&', 'a', 'm', 'p', ';'};
    private StringBuilder buf = new StringBuilder();

    public UnescapeUnicodeWriter(UnicodeWriter unicodeWriter) {
        this.unicodeWriter = unicodeWriter;
    }

    public void write(int c) throws IOException {
        if (c == 38) {
            this.unicodeWriter.writeCodePoint(c);
            this.ignore = 5;
            this.buf.setLength(0);
        }
        if (this.ignore != 0) {
            this.buf.append((char)c);
            if (c == AMP[5 - this.ignore]) {
                --this.ignore;
            } else {
                this.ignore = 0;
                this.unicodeWriter.write(this.buf.toString().substring(1));
            }
        } else {
            this.unicodeWriter.writeCodePoint(c);
        }
    }

    @Override
    public void write(UnicodeString chars) throws IOException {
        this.write(chars.toString());
    }

    @Override
    public void writeAscii(byte[] content) throws IOException {
        char[] chars = new char[content.length];
        StringTool.copy8to16(content, 0, chars, 0, content.length);
        for (int i = 0; i < chars.length; ++i) {
            this.write(chars[i]);
        }
    }

    @Override
    public void write(String chars) throws IOException {
        char[] charArray = chars.toCharArray();
        for (int i = 0; i < charArray.length; ++i) {
            this.write(charArray[i]);
        }
    }

    @Override
    public void writeCodePoint(int codepoint) throws IOException {
        if (codepoint > 65535) {
            this.write(UTF16CharacterSet.highSurrogate(codepoint));
            this.write(UTF16CharacterSet.lowSurrogate(codepoint));
        } else {
            this.write((char)codepoint);
        }
    }

    @Override
    public void close() throws IOException {
        this.unicodeWriter.close();
    }

    @Override
    public void flush() throws IOException {
        this.unicodeWriter.flush();
    }
}

