/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.serialize;

import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.sf.saxon.serialize.starttag.AttributeDeclaration;
import org.apache.xerces.xni.QName;
import org.xml.sax.Attributes;
import ro.sync.basic.util.Equaler;
import ro.sync.basic.xml.BasicXmlUtil;

public class AnnotationAttributesUtil {
    public static final String ADDITIONAL_ATTRIBUTES_NAMESPACE_URI = "http://www.oxygenxml.com/ns/xmlRefactoring/additional_attributes";
    public static final String ADDITIONAL_ATTRIBUTES_PREFIX = "xra";
    private static final String ATTR_LOCAL_NAME_PREFIX = "_oxy_ln_";
    private static final String ORIGINAL_VALUE_PREFIX = "oxy_oValue_";
    private static final String ATTRIBUTE_QNAME_REG_EXP = "oxy_oValue_(.*)_oxy_ln_(.+)";
    private static final Pattern ATTRIBUTE_ORIG_VALUE_REG_EXP_PATTERN = Pattern.compile("oxy_oValue_(.*)_oxy_ln_(.+)");
    private static final String NON_NORMALIZED_VALUE_PREFIX = "oxy_nonNormValue_";
    private static final String ATTRIBUTE_NON_NORMALIZED_VALUE_REG_EXP = "oxy_nonNormValue_(.*)_oxy_ln_(.+)";
    private static final Pattern ATTRIBUTE_NON_NORMALIZED_VALUE_REG_EXP_PATTERN = Pattern.compile("oxy_nonNormValue_(.*)_oxy_ln_(.+)");
    private static final String ATTRIBUTE_WS_INFO_ATTR_NAME_PREFIX = "oxy_AttrWS_";
    private static final char ATTRIBUTE_WS_INFO_VALUE_SEPARATOR = '#';
    private static final String ATTRIBUTE_WS_INFO_QNAME_REG_EXP = "oxy_AttrWS_(.*)_oxy_ln_(.+)";
    private static final Pattern ATTRIBUTE_WS_INFO_QNAME_REG_EXP_PATTERN = Pattern.compile("oxy_AttrWS_(.*)_oxy_ln_(.+)");
    private static final String ATTRIBUTE_WS_INFO_VALUE_REG_EXP = "([^#]*)#([^#]*)#([^#]*)#(true|false)";
    private static final Pattern ATTRIBUTE_WS_INFO_VALUE_REG_EXP_PATTERN = Pattern.compile("([^#]*)#([^#]*)#([^#]*)#(true|false)");
    public static final String ELEMENT_START_TAG_INFO_ATTR_NAME = "oxy_StartTagInfo";
    public static final String ATTRIBUTES_ORDER_ATTRIBUTE_NAME = "oxy__attributes_order";

    public static String encodeAttributeName_NormalizedValue(String attrQName) {
        String attrLocalName = BasicXmlUtil.getLocalName((String)attrQName);
        String attrPrefix = BasicXmlUtil.getProxy((String)attrQName);
        StringBuilder attrName = new StringBuilder();
        attrName.append(ORIGINAL_VALUE_PREFIX);
        if (attrPrefix != null && !"".equals(attrPrefix)) {
            attrName.append(attrPrefix);
        }
        attrName.append(ATTR_LOCAL_NAME_PREFIX);
        attrName.append(attrLocalName);
        return attrName.toString();
    }

    public static String encodeAttributeName_NonNormalizedValue(String attrQName) {
        String attrLocalName = BasicXmlUtil.getLocalName((String)attrQName);
        String attrPrefix = BasicXmlUtil.getProxy((String)attrQName);
        StringBuilder attrName = new StringBuilder();
        attrName.append(NON_NORMALIZED_VALUE_PREFIX);
        if (attrPrefix != null && !"".equals(attrPrefix)) {
            attrName.append(attrPrefix);
        }
        attrName.append(ATTR_LOCAL_NAME_PREFIX);
        attrName.append(attrLocalName);
        return attrName.toString();
    }

    public static boolean isAdditionalAttribute_NormalizedValue(String attrQName) {
        return attrQName != null && BasicXmlUtil.getLocalName((String)attrQName).startsWith(ORIGINAL_VALUE_PREFIX);
    }

    public static boolean isAdditionalAttribute_NonNormalizedValue(String attrQName) {
        return attrQName != null && BasicXmlUtil.getLocalName((String)attrQName).startsWith(NON_NORMALIZED_VALUE_PREFIX);
    }

    public static boolean isAdditionalAttribute_WhitespaceInfo(String attrQName) {
        return attrQName != null && BasicXmlUtil.getLocalName((String)attrQName).startsWith(ATTRIBUTE_WS_INFO_ATTR_NAME_PREFIX);
    }

    public static boolean isAdditionalAttribute_ElementStartTagInfo(String attrQName) {
        return ELEMENT_START_TAG_INFO_ATTR_NAME.equals(BasicXmlUtil.getLocalName((String)attrQName));
    }

    public static String decodeAttributeName_NormalizedValue(String attributeQName) {
        Matcher matcher = ATTRIBUTE_ORIG_VALUE_REG_EXP_PATTERN.matcher(BasicXmlUtil.getLocalName((String)attributeQName));
        boolean findRes = matcher.find();
        if (findRes) {
            String prefix = matcher.group(1);
            String ln = matcher.group(2);
            if (prefix != null && !"".equals(prefix)) {
                return prefix + ":" + ln;
            }
            return ln;
        }
        return attributeQName;
    }

    public static String decodeAttributeName_NonNormalizedValue(String attributeQName) {
        Matcher matcher = ATTRIBUTE_NON_NORMALIZED_VALUE_REG_EXP_PATTERN.matcher(BasicXmlUtil.getLocalName((String)attributeQName));
        boolean findRes = matcher.find();
        if (findRes) {
            String prefix = matcher.group(1);
            String ln = matcher.group(2);
            if (prefix != null && !"".equals(prefix)) {
                return prefix + ":" + ln;
            }
            return ln;
        }
        return attributeQName;
    }

    public static String getAttributeOriginalValue(Attributes attributes, String attrQName) {
        String origValue = null;
        int attributesLength = attributes.getLength();
        for (int i = 0; i < attributesLength; ++i) {
            String attrName;
            String localName = attributes.getLocalName(i);
            if (!AnnotationAttributesUtil.isAdditionalAttribute_NormalizedValue(localName) || !Equaler.verifyEquals((Object)(attrName = AnnotationAttributesUtil.decodeAttributeName_NormalizedValue(localName)), (Object)attrQName)) continue;
            origValue = attributes.getValue(i);
            break;
        }
        return origValue;
    }

    public static String getAttributeNonNormalizedValue(Attributes attributes, String attrQName) {
        String nonNormalizedValue = null;
        int attributesLength = attributes.getLength();
        for (int i = 0; i < attributesLength; ++i) {
            String attrName;
            String localName = attributes.getLocalName(i);
            if (!AnnotationAttributesUtil.isAdditionalAttribute_NonNormalizedValue(localName) || !Equaler.verifyEquals((Object)(attrName = AnnotationAttributesUtil.decodeAttributeName_NonNormalizedValue(localName)), (Object)attrQName)) continue;
            nonNormalizedValue = attributes.getValue(i);
            break;
        }
        return nonNormalizedValue;
    }

    public static boolean isAdditionalAttribute(String attributeName) {
        return AnnotationAttributesUtil.isAdditionalAttribute_NormalizedValue(attributeName) || AnnotationAttributesUtil.isAdditionalAttribute_NonNormalizedValue(attributeName) || AnnotationAttributesUtil.isAdditionalAttribute_WhitespaceInfo(attributeName) || AnnotationAttributesUtil.isAdditionalAttribute_ElementStartTagInfo(attributeName) || AnnotationAttributesUtil.isAdditionalAttribute_AttributesOrder(attributeName);
    }

    public static boolean isAdditionalAttribute_AttributesOrder(String attributeName) {
        return ATTRIBUTES_ORDER_ATTRIBUTE_NAME.equals(BasicXmlUtil.getLocalName((String)attributeName));
    }

    public static String encodeAttributeWhitespaceInfoAttributeName(String qName) {
        boolean isQName;
        StringBuilder builder = new StringBuilder();
        builder.append(ATTRIBUTE_WS_INFO_ATTR_NAME_PREFIX);
        int colonIdx = qName.indexOf(58);
        boolean bl = isQName = colonIdx != -1;
        if (isQName) {
            builder.append(qName.substring(0, colonIdx));
        }
        builder.append(ATTR_LOCAL_NAME_PREFIX);
        builder.append(isQName ? qName.substring(colonIdx + 1) : qName);
        return builder.toString();
    }

    public static String encodeAttributeWhitespaceInfoAttributeValue(String wsBeforeName, String wsBeforeEqual, String wsBeforeValue, boolean isDoubleQuoted) {
        StringBuilder builder = new StringBuilder();
        if (wsBeforeName != null) {
            builder.append(wsBeforeName);
        }
        builder.append('#');
        if (wsBeforeEqual != null) {
            builder.append(wsBeforeEqual);
        }
        builder.append('#');
        if (wsBeforeValue != null) {
            builder.append(wsBeforeValue);
        }
        builder.append('#');
        builder.append(isDoubleQuoted);
        return builder.toString();
    }

    public static AttributeDeclaration decodeAttributeWhitespaceInfo(String encodedAttributeName, String encodedAttributeValue) {
        AttributeDeclaration attrDecl = null;
        String decodedName = AnnotationAttributesUtil.decodeAttributeWhitespaceInfo_AttributeName(encodedAttributeName);
        if (decodedName != null) {
            attrDecl = new AttributeDeclaration();
            attrDecl.setQName(decodedName);
            Matcher matcher = ATTRIBUTE_WS_INFO_VALUE_REG_EXP_PATTERN.matcher(encodedAttributeValue);
            boolean findRes = matcher.find();
            if (findRes) {
                attrDecl.setWsBeforeName(matcher.group(1));
                attrDecl.setWsBeforeEqual(matcher.group(2));
                attrDecl.setWsBeforeValue(matcher.group(3));
                attrDecl.setDoubleQuotedValue(Boolean.valueOf(matcher.group(4)));
            }
        }
        return attrDecl;
    }

    private static String decodeAttributeWhitespaceInfo_AttributeName(String attributeQName) {
        Matcher matcher = ATTRIBUTE_WS_INFO_QNAME_REG_EXP_PATTERN.matcher(BasicXmlUtil.getLocalName((String)attributeQName));
        boolean findRes = matcher.find();
        if (findRes) {
            String prefix = matcher.group(1);
            String ln = matcher.group(2);
            if (prefix != null && !"".equals(prefix)) {
                return prefix + ":" + ln;
            }
            return ln;
        }
        return attributeQName;
    }

    public static String encodeElementStartTagInfoAttributeValue(String whitespaceBeforeTagEnd, boolean isEmptyTag) {
        StringBuilder builder = new StringBuilder();
        if (whitespaceBeforeTagEnd != null) {
            builder.append(whitespaceBeforeTagEnd);
        }
        builder.append('#');
        builder.append(isEmptyTag);
        return builder.toString();
    }

    public static boolean isElementEmtyTag(String encodedElementStartTagInfo) {
        int index;
        boolean isEmptyTag = false;
        if (encodedElementStartTagInfo != null && (index = encodedElementStartTagInfo.indexOf(35)) != -1) {
            isEmptyTag = Boolean.valueOf(encodedElementStartTagInfo.substring(index + 1));
        }
        return isEmptyTag;
    }

    public static String getWhitespaceBeforeElementTagEnd(String encodedElementStartTagInfo) {
        int index;
        String wsBeforeTagEnd = null;
        if (encodedElementStartTagInfo != null && (index = encodedElementStartTagInfo.indexOf(35)) != -1) {
            wsBeforeTagEnd = encodedElementStartTagInfo.substring(0, index);
        }
        return wsBeforeTagEnd;
    }

    public static String getAttributesOrderAttributeValue(List<AttributeDeclaration> attrDeclarations) {
        StringBuilder value = new StringBuilder();
        if (attrDeclarations != null) {
            int size = attrDeclarations.size();
            for (int i = 0; i < size; ++i) {
                AttributeDeclaration declaration = attrDeclarations.get(i);
                value.append(declaration.getQName());
                if (i >= size - 1) continue;
                value.append(" ");
            }
        }
        return value.toString();
    }

    public static List<String> getOrderedAttributes(String encodedAttributesOrderAttrValue) {
        ArrayList<String> orderedAttributes = new ArrayList<String>();
        if (encodedAttributesOrderAttrValue != null) {
            StringTokenizer tokenizer = new StringTokenizer(encodedAttributesOrderAttrValue, " ", false);
            while (tokenizer.hasMoreTokens()) {
                String attrQName = tokenizer.nextToken();
                orderedAttributes.add(attrQName);
            }
        }
        return orderedAttributes;
    }

    public static String getOrderedAttributesAttributeName() {
        return ATTRIBUTES_ORDER_ATTRIBUTE_NAME;
    }

    public static QName getAdditionalAttributeQName(String localName) {
        return new QName(ADDITIONAL_ATTRIBUTES_PREFIX, localName, "xra:" + localName, ADDITIONAL_ATTRIBUTES_NAMESPACE_URI);
    }

    public static boolean isAdditionalAttributesNamespace(String prefix, String uri) {
        return ADDITIONAL_ATTRIBUTES_PREFIX.equals(prefix) && ADDITIONAL_ATTRIBUTES_NAMESPACE_URI.equals(uri);
    }
}

