/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.option.dom4j;

import java.util.HashMap;
import java.util.Stack;
import net.sf.saxon.event.Builder;
import net.sf.saxon.event.PipelineConfiguration;
import net.sf.saxon.om.AttributeInfo;
import net.sf.saxon.om.AttributeMap;
import net.sf.saxon.om.NamespaceBinding;
import net.sf.saxon.om.NamespaceMap;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.NodeName;
import net.sf.saxon.option.dom4j.DOM4JDocumentWrapper;
import net.sf.saxon.s9api.Location;
import net.sf.saxon.str.UnicodeString;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.SchemaType;
import net.sf.saxon.value.Whitespace;
import org.dom4j.Attribute;
import org.dom4j.Branch;
import org.dom4j.Comment;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.Namespace;
import org.dom4j.Node;
import org.dom4j.ProcessingInstruction;
import org.dom4j.QName;
import org.dom4j.tree.DefaultAttribute;
import org.dom4j.tree.DefaultComment;
import org.dom4j.tree.DefaultDocument;
import org.dom4j.tree.DefaultElement;
import org.dom4j.tree.DefaultProcessingInstruction;
import org.dom4j.tree.DefaultText;

public class DOM4JWriter
extends Builder {
    private Document document;
    private final Stack<Branch> ancestors = new Stack();
    private final Stack<NamespaceMap> nsStack = new Stack();
    private boolean implicitDocumentNode = false;
    private final StringBuilder textBuffer = new StringBuilder(256);
    private final HashMap<String, Element> idIndex = new HashMap();

    public DOM4JWriter(PipelineConfiguration pipe) {
        super(pipe);
        this.nsStack.push(NamespaceMap.emptyMap());
    }

    @Override
    public void setUnparsedEntity(String name, String systemID, String publicID) throws XPathException {
    }

    @Override
    public void open() {
    }

    @Override
    public void close() {
    }

    @Override
    public void startDocument(int properties) throws XPathException {
        this.document = new DefaultDocument();
        this.ancestors.push((Branch)this.document);
        this.textBuffer.setLength(0);
    }

    @Override
    public void endDocument() throws XPathException {
        this.ancestors.pop();
    }

    @Override
    public void startElement(NodeName elemName, SchemaType type, AttributeMap attributes, NamespaceMap namespaces, Location location, int properties) throws XPathException {
        DefaultElement element;
        this.flush();
        String local = elemName.getLocalPart();
        String uri = elemName.getNamespaceUri().toString();
        String prefix = elemName.getPrefix();
        if (this.ancestors.isEmpty()) {
            this.startDocument(0);
            this.implicitDocumentNode = true;
        }
        QName name = new QName(local, new Namespace(prefix, uri));
        if (this.ancestors.size() == 1) {
            element = new DefaultElement(name);
            this.document.add((Element)element);
        } else {
            element = this.ancestors.peek().addElement(name);
        }
        this.ancestors.push((Branch)element);
        NamespaceMap parentNamespaces = this.nsStack.peek();
        if (namespaces != parentNamespaces) {
            NamespaceBinding[] declarations;
            for (NamespaceBinding ns : declarations = namespaces.getDifferences(parentNamespaces, false)) {
                element.addNamespace(ns.getPrefix(), ns.getNamespaceUri().toString());
            }
        }
        this.nsStack.push(namespaces);
        for (AttributeInfo att : attributes) {
            NodeName nameCode = att.getNodeName();
            String attlocal = nameCode.getLocalPart();
            String atturi = nameCode.getNamespaceUri().toString();
            String attprefix = nameCode.getPrefix();
            String value = att.getValue();
            Namespace ns = new Namespace(attprefix, atturi);
            if (uri.equals("http://www.w3.org/XML/1998/namespace") && attlocal.equals("id")) {
                value = Whitespace.trim(value);
                this.idIndex.put(value, (Element)this.ancestors.peek());
            }
            DefaultAttribute attr = new DefaultAttribute(attlocal, value, ns);
            element.add((Attribute)attr);
        }
    }

    @Override
    public void endElement() throws XPathException {
        this.flush();
        this.ancestors.pop();
        this.nsStack.pop();
        Branch parent = this.ancestors.peek();
        if (parent == this.document && this.implicitDocumentNode) {
            this.endDocument();
        }
    }

    @Override
    public void characters(UnicodeString chars, Location locationId, int properties) throws XPathException {
        this.textBuffer.append(chars);
    }

    private void flush() {
        if (this.textBuffer.length() != 0) {
            DefaultText text = new DefaultText(this.textBuffer.toString());
            this.ancestors.peek().add((Node)text);
            this.textBuffer.setLength(0);
        }
    }

    @Override
    public void processingInstruction(String target, UnicodeString data, Location locationId, int properties) throws XPathException {
        this.flush();
        DefaultProcessingInstruction pi = new DefaultProcessingInstruction(target, data.toString());
        this.ancestors.peek().add((ProcessingInstruction)pi);
    }

    @Override
    public void comment(UnicodeString chars, Location locationId, int properties) throws XPathException {
        this.flush();
        DefaultComment comment = new DefaultComment(chars.toString());
        this.ancestors.peek().add((Comment)comment);
    }

    @Override
    public boolean usesTypeAnnotations() {
        return false;
    }

    public Document getDocument() {
        return this.document;
    }

    @Override
    public NodeInfo getCurrentRoot() {
        DOM4JDocumentWrapper wrapper = new DOM4JDocumentWrapper(this.document, this.systemId, this.config);
        wrapper.setUserData("saxon-id-index", this.idIndex);
        return wrapper.getRootNode();
    }
}

