/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.lib;

import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.net.UnknownServiceException;
import javax.xml.transform.Result;
import javax.xml.transform.stream.StreamResult;
import net.sf.saxon.lib.OutputURIResolver;
import net.sf.saxon.lib.StandardResultDocumentResolver;
import net.sf.saxon.trans.XPathException;
import ro.sync.basic.util.URLUtil;

public class StandardOutputResolver
implements OutputURIResolver {
    private static final StandardOutputResolver theInstance = new StandardOutputResolver();

    public static StandardOutputResolver getInstance() {
        return theInstance;
    }

    @Override
    public StandardOutputResolver newInstance() {
        return this;
    }

    @Override
    public Result resolve(String href, String base) throws XPathException {
        String which = "base";
        try {
            URI absoluteURI;
            if (href.isEmpty()) {
                if (base == null) {
                    throw new XPathException("The system identifier of the principal output file is unknown", "SXRD0002");
                }
                absoluteURI = new URI(base);
            } else {
                which = "relative";
                absoluteURI = new URI(href);
            }
            if (!absoluteURI.isAbsolute()) {
                if (base == null) {
                    throw new XPathException("The system identifier of the principal output file is unknown", "SXRD0002");
                }
                which = "base";
                URI baseURI = new URI(base);
                which = "relative";
                absoluteURI = baseURI.resolve(href);
                try {
                    URL baseUrl = baseURI.toURL();
                    if (URLUtil.isFromUNCPath((URL)baseUrl)) {
                        URL resolved = URLUtil.resolveRelativeSystemIDs((URL)baseUrl, (String)href);
                        absoluteURI = resolved.toURI();
                    }
                }
                catch (MalformedURLException malformedURLException) {
                    // empty catch block
                }
            }
            return this.createResult(absoluteURI);
        }
        catch (URISyntaxException err) {
            throw new XPathException("Invalid syntax for " + which + " URI", "SXRD0001");
        }
        catch (IllegalArgumentException err2) {
            throw new XPathException("Invalid " + which + " URI syntax", "SXRD0001");
        }
        catch (MalformedURLException err3) {
            throw new XPathException("Resolved URL is malformed", err3).withErrorCode("SXRD0001");
        }
        catch (UnknownServiceException err4) {
            throw new XPathException("Specified protocol does not allow output", err4).withErrorCode("SXRD0001");
        }
        catch (IOException err5) {
            throw new XPathException("Cannot open connection to specified URL", err5).withErrorCode("SXRD0001");
        }
    }

    protected Result createResult(URI absoluteURI) throws XPathException, IOException {
        boolean tryURL = false;
        if ("file".equals(absoluteURI.getScheme())) {
            try {
                return StandardResultDocumentResolver.makeOutputFile(absoluteURI);
            }
            catch (XPathException e) {
                tryURL = true;
            }
        }
        if (tryURL || !"file".equals(absoluteURI.getScheme())) {
            URLConnection connection = absoluteURI.toURL().openConnection();
            connection.setDoInput(false);
            connection.setDoOutput(true);
            connection.connect();
            OutputStream stream = connection.getOutputStream();
            StreamResult result = new StreamResult(stream);
            result.setSystemId(absoluteURI.toASCIIString());
            return result;
        }
        return null;
    }

    @Override
    public void close(Result result) throws XPathException {
        if (result instanceof StreamResult) {
            Writer writer;
            OutputStream stream = ((StreamResult)result).getOutputStream();
            if (stream != null) {
                try {
                    stream.close();
                }
                catch (IOException err) {
                    throw new XPathException("Failed while closing output file", err).withErrorCode("SXRD0003");
                }
            }
            if ((writer = ((StreamResult)result).getWriter()) != null) {
                try {
                    writer.close();
                }
                catch (IOException err) {
                    throw new XPathException("Failed while closing output file", err).withErrorCode("SXRD0003");
                }
            }
        }
    }
}

