/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr.parser;

import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.Operand;
import net.sf.saxon.expr.flwor.FLWORExpression;
import net.sf.saxon.expr.instruct.TraceExpression;
import net.sf.saxon.expr.parser.CodeInjector;

public class ExpressionToolUtil {
    public static Expression injectCodeXQuery(Expression exp, CodeInjector injector) {
        if (exp instanceof FLWORExpression) {
            ((FLWORExpression)exp).injectCode(injector);
        } else if (exp instanceof TraceExpression) {
            Expression child = ((TraceExpression)exp).getChild();
            Iterable<Operand> childOps = child.operands();
            for (Operand operand : childOps) {
                operand.setChildExpression(ExpressionToolUtil.injectCodeXQuery(operand.getChildExpression(), injector));
            }
        } else {
            for (Operand o : exp.operands()) {
                o.setChildExpression(ExpressionToolUtil.injectCodeXQuery(o.getChildExpression(), injector));
            }
        }
        return injector.inject(exp);
    }
}

