/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon;

import com.saxonica.config.EnterpriseConfiguration;
import com.saxonica.config.JavaPlatformEE;
import com.saxonica.config.JavaPlatformPE;
import com.saxonica.config.ProfessionalConfiguration;
import net.sf.saxon.Configuration;
import net.sf.saxon.Platform;
import net.sf.saxon.java.JavaPlatform;

public final class Version {
    private static final int MAJOR_VERSION = 12;
    private static final int MINOR_VERSION = 5;
    private static final int PATCH_VERSION = 0;
    private static final int BUILD = 32818;
    private static final String MAJOR_RELEASE_DATE = "2023-01-12";
    private static final String MINOR_RELEASE_DATE = "2024-06-18";
    public static Class<? extends Configuration> configurationClass = Configuration.class;
    public static String softwareEdition;
    public static Platform platform;

    private Version() {
    }

    public static String getProductName() {
        return "SAXON";
    }

    public static String getProductVendor() {
        return "Saxonica";
    }

    public static String getProductVariantAndVersion(String edition) {
        return edition + " " + Version.getProductVersion();
    }

    public static String getProductVersion() {
        return "12.5";
    }

    public static int[] getStructuredVersionNumber() {
        return new int[]{12, 5, 32818, 0};
    }

    public static String getReleaseDate() {
        return MINOR_RELEASE_DATE;
    }

    public static String getMajorReleaseDate() {
        return MAJOR_RELEASE_DATE;
    }

    public static String getProductTitle() {
        return Version.getProductName() + "-" + Version.getSoftwarePlatform() + "-" + softwareEdition + " " + Version.getProductVersion() + " from Saxonica";
    }

    public static String getSoftwarePlatform() {
        return "J";
    }

    public static String getWebSiteAddress() {
        return "http://www.saxonica.com/";
    }

    public static void main(String[] args) {
        System.err.println(Version.getProductTitle() + " (build 32818)");
        if (args.length > 0 && args[0].equals("-resources")) {
            platform.showEmbeddedResources();
        }
    }

    static {
        configurationClass = ProfessionalConfiguration.class;
        configurationClass = EnterpriseConfiguration.class;
        softwareEdition = "HE";
        softwareEdition = "EE";
        softwareEdition = "PE";
        platform = new JavaPlatform();
        platform = new JavaPlatformPE();
        platform = new JavaPlatformEE();
    }
}

